/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache;

import java.io.Serializable;
import java.util.Set;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public abstract class CacheFactoryService<K extends Serializable, V extends Identifiable<K>>
implements Service<CacheFactory<K, V>> {
    public static final ServiceName BASE_CACHE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "cache"});
    public static final ServiceName DEFAULT_SFSB_CACHE_SERVICE_NAME = BASE_CACHE_SERVICE_NAME.append(new String[]{"sfsb-default"});
    public static final ServiceName DEFAULT_CLUSTERED_SFSB_CACHE_SERVICE_NAME = BASE_CACHE_SERVICE_NAME.append(new String[]{"clustered-sfsb-default"});
    private static final ServiceName BASE_CACHE_FACTORY_SERVICE_NAME = BASE_CACHE_SERVICE_NAME.append(new String[]{"factory"});
    private final String name;
    private final Set<String> aliases;
    private volatile CacheFactory<K, V> factory;

    public static ServiceName getServiceName(String name) {
        return BASE_CACHE_FACTORY_SERVICE_NAME.append(new String[]{name});
    }

    public CacheFactoryService(String name, Set<String> aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public ServiceBuilder<CacheFactory<K, V>> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(CacheFactoryService.getServiceName(this.name), (Service)this);
        for (String alias : this.aliases) {
            builder.addAliases(new ServiceName[]{CacheFactoryService.getServiceName(alias)});
        }
        return builder;
    }

    public CacheFactory<K, V> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.factory;
    }

    public void start(StartContext context) {
        this.factory = this.createCacheFactory();
    }

    protected abstract CacheFactory<K, V> createCacheFactory();

    public void stop(StopContext context) {
        this.factory = null;
    }
}

