/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedExecutorService;
import org.jboss.threads.JBossExecutors;

public class ManagedScheduledExecutorService
extends ManagedExecutorService
implements ScheduledExecutorService {
    private final ScheduledThreadPoolExecutor executor;

    public ManagedScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
        super(executor);
        this.executor = executor;
    }

    @Override
    protected ExecutorService protectExecutor(ExecutorService executor) {
        return JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)((ScheduledExecutorService)executor));
    }

    @Override
    void internalShutdown() {
        this.executor.shutdown();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public long getTaskCount() {
        return this.executor.getTaskCount();
    }
}

