/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.registry.InvalidRequestException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.model.uddi.v2.AssertionStatusReport;
import org.apache.ws.scout.model.uddi.v2.AuthToken;
import org.apache.ws.scout.model.uddi.v2.BindingDetail;
import org.apache.ws.scout.model.uddi.v2.BindingTemplate;
import org.apache.ws.scout.model.uddi.v2.BusinessDetail;
import org.apache.ws.scout.model.uddi.v2.BusinessEntity;
import org.apache.ws.scout.model.uddi.v2.BusinessList;
import org.apache.ws.scout.model.uddi.v2.BusinessService;
import org.apache.ws.scout.model.uddi.v2.CategoryBag;
import org.apache.ws.scout.model.uddi.v2.DeleteBinding;
import org.apache.ws.scout.model.uddi.v2.DeleteBusiness;
import org.apache.ws.scout.model.uddi.v2.DeletePublisherAssertions;
import org.apache.ws.scout.model.uddi.v2.DeleteService;
import org.apache.ws.scout.model.uddi.v2.DeleteTModel;
import org.apache.ws.scout.model.uddi.v2.DiscoveryURLs;
import org.apache.ws.scout.model.uddi.v2.DispositionReport;
import org.apache.ws.scout.model.uddi.v2.FindBinding;
import org.apache.ws.scout.model.uddi.v2.FindBusiness;
import org.apache.ws.scout.model.uddi.v2.FindQualifiers;
import org.apache.ws.scout.model.uddi.v2.FindService;
import org.apache.ws.scout.model.uddi.v2.FindTModel;
import org.apache.ws.scout.model.uddi.v2.GetAssertionStatusReport;
import org.apache.ws.scout.model.uddi.v2.GetAuthToken;
import org.apache.ws.scout.model.uddi.v2.GetBusinessDetail;
import org.apache.ws.scout.model.uddi.v2.GetPublisherAssertions;
import org.apache.ws.scout.model.uddi.v2.GetRegisteredInfo;
import org.apache.ws.scout.model.uddi.v2.GetServiceDetail;
import org.apache.ws.scout.model.uddi.v2.GetTModelDetail;
import org.apache.ws.scout.model.uddi.v2.IdentifierBag;
import org.apache.ws.scout.model.uddi.v2.Name;
import org.apache.ws.scout.model.uddi.v2.ObjectFactory;
import org.apache.ws.scout.model.uddi.v2.PublisherAssertion;
import org.apache.ws.scout.model.uddi.v2.PublisherAssertions;
import org.apache.ws.scout.model.uddi.v2.RegisteredInfo;
import org.apache.ws.scout.model.uddi.v2.SaveBinding;
import org.apache.ws.scout.model.uddi.v2.SaveBusiness;
import org.apache.ws.scout.model.uddi.v2.SaveService;
import org.apache.ws.scout.model.uddi.v2.SaveTModel;
import org.apache.ws.scout.model.uddi.v2.ServiceDetail;
import org.apache.ws.scout.model.uddi.v2.ServiceList;
import org.apache.ws.scout.model.uddi.v2.SetPublisherAssertions;
import org.apache.ws.scout.model.uddi.v2.TModel;
import org.apache.ws.scout.model.uddi.v2.TModelBag;
import org.apache.ws.scout.model.uddi.v2.TModelDetail;
import org.apache.ws.scout.model.uddi.v2.TModelList;
import org.apache.ws.scout.registry.IRegistry;
import org.apache.ws.scout.registry.JAXBContextUtil;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.transport.TransportException;
import org.apache.ws.scout.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements IRegistry {
    public static final String DEFAULT_ADMIN_ENDPOINT = "http://localhost:8080/juddi/admin";
    public static final String DEFAULT_TRANSPORT_CLASS = "org.apache.ws.scout.transport.SaajTransport";
    public static final String DEFAULT_SECURITY_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String DEFAULT_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String DEFAULT_UDDI_VERSION = "2.0";
    public static final String DEFAULT_UDDI_NAMESPACE = "urn:uddi-org:api_v2";
    private URI adminURI;
    private URI inquiryURI;
    private URI publishURI;
    private URI securityURI;
    private Transport transport;
    private String securityProvider;
    private String protocolHandler;
    private String uddiVersion;
    private String uddiNamespace;
    private ObjectFactory objectFactory = new ObjectFactory();
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private static Log log = LogFactory.getLog(RegistryImpl.class);

    public RegistryImpl(Properties props) throws InvalidRequestException {
        this.init(props);
    }

    private void init(Properties props) throws InvalidRequestException {
        if (props == null) {
            props = new Properties();
        }
        try {
            String securityURL;
            this.setInquiryURI(new URI(props.getProperty("javax.xml.registry.queryManagerURL")));
            if (props.containsKey("javax.xml.registry.lifeCycleManagerURL")) {
                this.setPublishURI(new URI(props.getProperty("javax.xml.registry.lifeCycleManagerURL")));
            }
            if ((securityURL = props.getProperty("javax.xml.registry.securityManagerURL", props.getProperty("javax.xml.registry.lifeCycleManagerURL"))) != null) {
                this.setSecurityURI(new URI(securityURL));
            }
            this.setAdminURI(new URI(props.getProperty("scout.proxy.adminURL", DEFAULT_ADMIN_ENDPOINT)));
            this.setSecurityProvider(props.getProperty("scout.proxy.securityProvider", DEFAULT_SECURITY_PROVIDER));
            this.setProtocolHandler(props.getProperty("scout.proxy.protocolHandler", DEFAULT_PROTOCOL_HANDLER));
            this.setUddiVersion(props.getProperty("scout.proxy.uddiVersion", DEFAULT_UDDI_VERSION));
            this.setUddiNamespace(props.getProperty("scout.proxy.uddiNamespace", DEFAULT_UDDI_NAMESPACE));
            this.setTransport(this.getTransport(props.getProperty("scout.proxy.transportClass", DEFAULT_TRANSPORT_CLASS)));
            JAXBContext context = JAXBContextUtil.getContext(DEFAULT_UDDI_VERSION);
            this.unmarshaller = context.createUnmarshaller();
            this.marshaller = context.createMarshaller();
        }
        catch (URISyntaxException muex) {
            throw new InvalidRequestException(muex.getMessage(), (Throwable)muex);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String execute(String uddiRequest, String urltype) throws TransportException {
        URI endPointURL = null;
        endPointURL = urltype.equalsIgnoreCase("INQUIRY") ? this.getInquiryURI() : this.getPublishURI();
        return this.transport.send(uddiRequest, endPointURL);
    }

    public JAXBElement<?> execute(JAXBElement<?> uddiRequest, URI endPointURI) throws RegistryException {
        String responseName;
        Element response;
        Document doc;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.marshaller.marshal(uddiRequest, (OutputStream)baos);
            doc = docBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (SAXException saxe) {
            throw new RegistryException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException(pce);
        }
        catch (IOException ioe) {
            throw new RegistryException(ioe);
        }
        catch (JAXBException ioe) {
            throw new RegistryException((Exception)((Object)ioe));
        }
        Element request = doc.getDocumentElement();
        request.setAttribute("xmlns", this.getUddiNamespace());
        if (!"3.0".equals(this.getUddiVersion())) {
            request.setAttribute("generic", this.getUddiVersion());
        }
        try {
            response = this.transport.send(request, endPointURI);
        }
        catch (TransportException te) {
            throw new RegistryException(te);
        }
        if (response.getNamespaceURI() == null) {
            response.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getUddiNamespace());
        }
        if ((responseName = response.getLocalName()) == null) {
            throw new RegistryException("Unsupported response from registry. A value was not present.");
        }
        if (responseName.toLowerCase().equals("fault")) {
            NodeList nodeList = null;
            String fCode = null;
            nodeList = response.getElementsByTagName("faultcode");
            if (nodeList.getLength() > 0) {
                fCode = nodeList.item(0).getNodeValue();
            }
            String fString = null;
            nodeList = response.getElementsByTagName("faultstring");
            if (nodeList.getLength() > 0) {
                fString = nodeList.item(0).getNodeValue();
            }
            String fActor = null;
            nodeList = response.getElementsByTagName("faultactor");
            if (nodeList.getLength() > 0) {
                fActor = nodeList.item(0).getNodeValue();
            }
            DispositionReport dispRpt = null;
            nodeList = response.getElementsByTagName("detail");
            if (nodeList.getLength() > 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("dispositionReport")).getLength() > 0) {
                JAXBElement dispRptObj = null;
                try {
                    dispRptObj = (JAXBElement)this.unmarshaller.unmarshal((Node)((Element)nodeList.item(0)));
                }
                catch (JAXBException xmle) {
                    throw new RegistryException((Exception)((Object)xmle));
                }
                dispRpt = (DispositionReport)dispRptObj.getValue();
            }
            RegistryException e = new RegistryException(fCode, fString, fActor, dispRpt);
            throw e;
        }
        JAXBElement uddiResponse = null;
        try {
            String xml = XMLUtils.convertNodeToXMLString(response);
            log.debug((Object)("Response is: " + xml));
            StringReader reader = new StringReader(xml);
            uddiResponse = (JAXBElement)this.unmarshaller.unmarshal((Source)new StreamSource(reader));
        }
        catch (JAXBException xmle) {
            throw new RegistryException((Exception)((Object)xmle));
        }
        return uddiResponse;
    }

    public URI getAdminURI() {
        return this.adminURI;
    }

    public void setAdminURI(URI url) {
        this.adminURI = url;
    }

    @Override
    public URI getInquiryURI() {
        return this.inquiryURI;
    }

    @Override
    public void setInquiryURI(URI inquiryURI) {
        this.inquiryURI = inquiryURI;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    @Override
    public URI getPublishURI() {
        return this.publishURI;
    }

    @Override
    public URI getSecurityURI() {
        return this.securityURI;
    }

    @Override
    public void setPublishURI(URI publishURI) {
        this.publishURI = publishURI;
    }

    @Override
    public void setSecurityURI(URI securityURI) {
        this.securityURI = securityURI;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getUddiNamespace() {
        return this.uddiNamespace;
    }

    public void setUddiNamespace(String uddiNS) {
        this.uddiNamespace = uddiNS;
    }

    public String getUddiVersion() {
        return this.uddiVersion;
    }

    public void setUddiVersion(String uddiVersion) {
        this.uddiVersion = uddiVersion;
    }

    @Override
    public DispositionReport deleteBinding(String authInfo, String[] bindingKeyArray) throws RegistryException {
        DeleteBinding request = this.objectFactory.createDeleteBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingKeyArray != null) {
            request.getBindingKey().addAll(Arrays.asList(bindingKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteBinding(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteBusiness(String authInfo, String[] businessKeyArray) throws RegistryException {
        DeleteBusiness request = this.objectFactory.createDeleteBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessKeyArray != null) {
            request.getBusinessKey().addAll(Arrays.asList(businessKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteBusiness(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deletePublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryException {
        DeletePublisherAssertions request = this.objectFactory.createDeletePublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.getPublisherAssertion().addAll(Arrays.asList(assertionArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeletePublisherAssertions(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteService(String authInfo, String[] serviceKeyArray) throws RegistryException {
        DeleteService request = this.objectFactory.createDeleteService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceKeyArray != null) {
            request.getServiceKey().addAll(Arrays.asList(serviceKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteService(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteTModel(String authInfo, String[] tModelKeyArray) throws RegistryException {
        DeleteTModel request = this.objectFactory.createDeleteTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelKeyArray != null) {
            request.getTModelKey().addAll(Arrays.asList(tModelKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteTModel(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public BusinessList findBusiness(Name[] nameArray, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBusiness request = this.objectFactory.createFindBusiness();
        if (nameArray != null) {
            request.getName().addAll(Arrays.asList(nameArray));
        }
        if (discoveryURLs != null) {
            request.setDiscoveryURLs(discoveryURLs);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        } else {
            request.setTModelBag(this.objectFactory.createTModelBag());
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        JAXBElement<?> o = this.execute(this.objectFactory.createFindBusiness(request), this.getInquiryURI());
        BusinessList bl = (BusinessList)o.getValue();
        return bl;
    }

    @Override
    public BindingDetail findBinding(String serviceKey, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindBinding request = this.objectFactory.createFindBinding();
        if (serviceKey != null) {
            request.setServiceKey(serviceKey);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        } else {
            TModelBag tmb = this.objectFactory.createTModelBag();
            request.setTModelBag(tmb);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        JAXBElement<?> o = this.execute(this.objectFactory.createFindBinding(request), this.getInquiryURI());
        BindingDetail bd = (BindingDetail)o.getValue();
        return bd;
    }

    @Override
    public ServiceList findService(String businessKey, Name[] nameArray, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindService request = this.objectFactory.createFindService();
        if (businessKey != null) {
            request.setBusinessKey(businessKey);
        }
        if (nameArray != null) {
            request.getName().addAll(Arrays.asList(nameArray));
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        JAXBElement<?> o = this.execute(this.objectFactory.createFindService(request), this.getInquiryURI());
        ServiceList sl = (ServiceList)o.getValue();
        return sl;
    }

    @Override
    public TModelList findTModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws RegistryException {
        FindTModel request = this.objectFactory.createFindTModel();
        Name jaxbName = this.objectFactory.createName();
        if (name != null) {
            jaxbName.setValue(name);
        }
        request.setName(jaxbName);
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(maxRows);
        JAXBElement<?> o = this.execute(this.objectFactory.createFindTModel(request), this.getInquiryURI());
        TModelList tml = (TModelList)o.getValue();
        return tml;
    }

    @Override
    public AssertionStatusReport getAssertionStatusReport(String authInfo, String completionStatus) throws RegistryException {
        GetAssertionStatusReport request = this.objectFactory.createGetAssertionStatusReport();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (completionStatus != null) {
            request.setCompletionStatus(completionStatus);
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetAssertionStatusReport(request), this.getPublishURI());
        AssertionStatusReport asr = (AssertionStatusReport)o.getValue();
        return asr;
    }

    @Override
    public AuthToken getAuthToken(String userID, String cred) throws RegistryException {
        GetAuthToken request = this.objectFactory.createGetAuthToken();
        if (userID != null) {
            request.setUserID(userID);
        }
        if (cred != null) {
            request.setCred(cred);
        }
        URI getAuthTokenURI = this.getSecurityURI();
        JAXBElement<?> o = this.execute(this.objectFactory.createGetAuthToken(request), getAuthTokenURI);
        AuthToken at = (AuthToken)o.getValue();
        return at;
    }

    @Override
    public BusinessDetail getBusinessDetail(String businessKey) throws RegistryException {
        String[] keys = new String[]{businessKey};
        return this.getBusinessDetail(keys);
    }

    @Override
    public BusinessDetail getBusinessDetail(String[] businessKeyArray) throws RegistryException {
        GetBusinessDetail request = this.objectFactory.createGetBusinessDetail();
        if (businessKeyArray != null) {
            request.getBusinessKey().addAll(Arrays.asList(businessKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetBusinessDetail(request), this.getInquiryURI());
        BusinessDetail bd = (BusinessDetail)o.getValue();
        return bd;
    }

    @Override
    public PublisherAssertions getPublisherAssertions(String authInfo) throws RegistryException {
        GetPublisherAssertions request = this.objectFactory.createGetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetPublisherAssertions(request), this.getPublishURI());
        PublisherAssertions pa = (PublisherAssertions)o.getValue();
        return pa;
    }

    @Override
    public RegisteredInfo getRegisteredInfo(String authInfo) throws RegistryException {
        GetRegisteredInfo request = this.objectFactory.createGetRegisteredInfo();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetRegisteredInfo(request), this.getPublishURI());
        RegisteredInfo ri = (RegisteredInfo)o.getValue();
        return ri;
    }

    @Override
    public ServiceDetail getServiceDetail(String serviceKey) throws RegistryException {
        String[] keys = new String[]{serviceKey};
        return this.getServiceDetail(keys);
    }

    @Override
    public ServiceDetail getServiceDetail(String[] serviceKeyArray) throws RegistryException {
        GetServiceDetail request = this.objectFactory.createGetServiceDetail();
        if (serviceKeyArray != null) {
            request.getServiceKey().addAll(Arrays.asList(serviceKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetServiceDetail(request), this.getInquiryURI());
        ServiceDetail sd = (ServiceDetail)o.getValue();
        return sd;
    }

    @Override
    public TModelDetail getTModelDetail(String tModelKey) throws RegistryException {
        String[] keys = new String[]{tModelKey};
        return this.getTModelDetail(keys);
    }

    @Override
    public TModelDetail getTModelDetail(String[] tModelKeyArray) throws RegistryException {
        GetTModelDetail request = this.objectFactory.createGetTModelDetail();
        if (tModelKeyArray != null) {
            request.getTModelKey().addAll(Arrays.asList(tModelKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetTModelDetail(request), this.getInquiryURI());
        TModelDetail tmd = (TModelDetail)o.getValue();
        return tmd;
    }

    @Override
    public PublisherAssertions setPublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryException {
        SetPublisherAssertions request = this.objectFactory.createSetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.getPublisherAssertion().addAll(Arrays.asList(assertionArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSetPublisherAssertions(request), this.getPublishURI());
        PublisherAssertions pa = (PublisherAssertions)o.getValue();
        return pa;
    }

    @Override
    public BindingDetail saveBinding(String authInfo, BindingTemplate[] bindingArray) throws RegistryException {
        SaveBinding request = this.objectFactory.createSaveBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingArray != null) {
            request.getBindingTemplate().addAll(Arrays.asList(bindingArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveBinding(request), this.getPublishURI());
        BindingDetail bd = (BindingDetail)o.getValue();
        return bd;
    }

    @Override
    public BusinessDetail saveBusiness(String authInfo, BusinessEntity[] businessArray) throws RegistryException {
        SaveBusiness request = this.objectFactory.createSaveBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessArray != null) {
            request.getBusinessEntity().addAll(Arrays.asList(businessArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveBusiness(request), this.getPublishURI());
        BusinessDetail bd = (BusinessDetail)o.getValue();
        return bd;
    }

    @Override
    public ServiceDetail saveService(String authInfo, BusinessService[] serviceArray) throws RegistryException {
        SaveService request = this.objectFactory.createSaveService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceArray != null) {
            request.getBusinessService().addAll(Arrays.asList(serviceArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveService(request), this.getPublishURI());
        ServiceDetail sd = (ServiceDetail)o.getValue();
        return sd;
    }

    @Override
    public TModelDetail saveTModel(String authInfo, TModel[] tModelArray) throws RegistryException {
        SaveTModel request = this.objectFactory.createSaveTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelArray != null) {
            request.getTModel().addAll(Arrays.asList(tModelArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveTModel(request), this.getPublishURI());
        TModelDetail tmd = (TModelDetail)o.getValue();
        return tmd;
    }

    public Transport getTransport(String className) {
        Transport transport = null;
        Class transportClass = null;
        if (className == null) {
            className = DEFAULT_TRANSPORT_CLASS;
        }
        try {
            transportClass = RegistryImpl.getClassForName(className);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException(cnfex);
        }
        try {
            transport = (Transport)transportClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return transport;
    }

    public static Class getClassForName(String name) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> clazz = null;
        try {
            ClassLoader ccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            clazz = Class.forName(name, true, ccl);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to load the class " + name + " with context class loader " + e));
        }
        if (null == clazz) {
            ClassLoader scl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            try {
                clazz = Class.forName(name, true, scl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return clazz;
    }
}

