/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.service.MBeanServices;
import org.jboss.as.service.NullInjector;
import org.jboss.as.service.ReflectionUtils;
import org.jboss.as.service.SarLogger;
import org.jboss.as.service.SarMessages;
import org.jboss.as.service.descriptor.JBossServiceAttributeConfig;
import org.jboss.as.service.descriptor.JBossServiceConfig;
import org.jboss.as.service.descriptor.JBossServiceConstructorConfig;
import org.jboss.as.service.descriptor.JBossServiceDependencyConfig;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptor;
import org.jboss.common.beans.property.PropertyEditors;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MethodInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.MethodValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class ParsedServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        JBossServiceXmlDescriptor serviceXmlDescriptor = (JBossServiceXmlDescriptor)deploymentUnit.getAttachment(JBossServiceXmlDescriptor.ATTACHMENT_KEY);
        if (serviceXmlDescriptor == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw SarMessages.MESSAGES.failedToGetAttachment("module", deploymentUnit);
        }
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        if (reflectionIndex == null) {
            throw SarMessages.MESSAGES.failedToGetAttachment("reflection index", deploymentUnit);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        List<JBossServiceConfig> serviceConfigs = serviceXmlDescriptor.getServiceConfigs();
        ServiceTarget target = phaseContext.getServiceTarget();
        for (JBossServiceConfig serviceConfig : serviceConfigs) {
            this.addServices(target, serviceConfig, (ClassLoader)classLoader, reflectionIndex);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addServices(ServiceTarget target, JBossServiceConfig mBeanConfig, ClassLoader classLoader, DeploymentReflectionIndex index) throws DeploymentUnitProcessingException {
        JBossServiceAttributeConfig[] attributeConfigs;
        String mBeanClassName = mBeanConfig.getCode();
        List<ClassReflectionIndex<?>> mBeanClassHierarchy = ReflectionUtils.getClassHierarchy(mBeanClassName, index, classLoader);
        Object mBeanInstance = ParsedServiceDeploymentProcessor.newInstance(mBeanConfig, mBeanClassHierarchy, classLoader);
        String mBeanName = mBeanConfig.getName();
        MBeanServices mBeanServices = new MBeanServices(mBeanName, mBeanInstance, mBeanClassHierarchy, target);
        JBossServiceDependencyConfig[] dependencyConfigs = mBeanConfig.getDependencyConfigs();
        if (dependencyConfigs != null) {
            Service<Object> createDestroyService = mBeanServices.getCreateDestroyService();
            for (JBossServiceDependencyConfig dependencyConfig : dependencyConfigs) {
                Injector<Object> injector = ParsedServiceDeploymentProcessor.getInjector(dependencyConfig, mBeanClassHierarchy, createDestroyService);
                mBeanServices.addDependency(dependencyConfig.getDependencyName(), injector);
            }
        }
        if ((attributeConfigs = mBeanConfig.getAttributeConfigs()) != null) {
            Service<Object> createDestroyService = mBeanServices.getCreateDestroyService();
            for (JBossServiceAttributeConfig attributeConfig : attributeConfigs) {
                Injector<Object> injector;
                Value<?> value;
                String propertyName = attributeConfig.getName();
                JBossServiceAttributeConfig.Inject injectConfig = attributeConfig.getInject();
                JBossServiceAttributeConfig.ValueFactory valueFactoryConfig = attributeConfig.getValueFactory();
                if (injectConfig != null) {
                    value = ParsedServiceDeploymentProcessor.getValue(injectConfig, mBeanClassHierarchy);
                    injector = ParsedServiceDeploymentProcessor.getPropertyInjector(propertyName, mBeanClassHierarchy, createDestroyService, value);
                    mBeanServices.addDependency(injectConfig.getBeanName(), injector);
                    continue;
                }
                if (valueFactoryConfig != null) {
                    value = ParsedServiceDeploymentProcessor.getValue(valueFactoryConfig, mBeanClassHierarchy, classLoader);
                    injector = ParsedServiceDeploymentProcessor.getPropertyInjector(propertyName, mBeanClassHierarchy, createDestroyService, value);
                    mBeanServices.addDependency(valueFactoryConfig.getBeanName(), injector);
                    continue;
                }
                value = ParsedServiceDeploymentProcessor.getValue(attributeConfig, mBeanClassHierarchy);
                injector = ParsedServiceDeploymentProcessor.getPropertyInjector(propertyName, mBeanClassHierarchy, createDestroyService, Values.injectedValue());
                mBeanServices.addInjectionValue(injector, value);
            }
        }
        mBeanServices.install();
    }

    private static Injector<Object> getInjector(JBossServiceDependencyConfig dependencyConfig, List<ClassReflectionIndex<?>> mBeanClassHierarchy, Service<Object> service) {
        String attrName = dependencyConfig.getOptionalAttributeName();
        return attrName != null ? ParsedServiceDeploymentProcessor.getPropertyInjector(attrName, mBeanClassHierarchy, service, Values.injectedValue()) : NullInjector.getInstance();
    }

    private static Value<?> getValue(JBossServiceAttributeConfig.Inject injectConfig, List<ClassReflectionIndex<?>> mBeanClassHierarchy) {
        String propertyName = injectConfig.getPropertyName();
        ThreadLocalValue valueToInject = Values.injectedValue();
        if (propertyName != null) {
            Method getter = ReflectionUtils.getGetter(mBeanClassHierarchy, propertyName);
            ImmediateValue getterValue = new ImmediateValue((Object)getter);
            valueToInject = Values.cached((Value)new MethodValue((Value)getterValue, (Value)valueToInject, Values.emptyList()));
        }
        return valueToInject;
    }

    private static Value<?> getValue(JBossServiceAttributeConfig.ValueFactory valueFactory, List<ClassReflectionIndex<?>> mBeanClassHierarchy, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        String methodName = valueFactory.getMethodName();
        JBossServiceAttributeConfig.ValueFactoryParameter[] parameters = valueFactory.getParameters();
        ArrayList paramTypes = new ArrayList(parameters.length);
        ArrayList<ImmediateValue> paramValues = new ArrayList<ImmediateValue>(parameters.length);
        for (JBossServiceAttributeConfig.ValueFactoryParameter parameter : parameters) {
            Class<?> attributeTypeValue = ReflectionUtils.getClass(parameter.getType(), classLoader);
            paramTypes.add(attributeTypeValue);
            paramValues.add(new ImmediateValue(ParsedServiceDeploymentProcessor.newValue(attributeTypeValue, parameter.getValue())));
        }
        ImmediateValue methodValue = new ImmediateValue((Object)ReflectionUtils.getMethod(mBeanClassHierarchy, methodName, paramTypes.toArray(new Class[0]), true));
        return Values.cached((Value)new MethodValue((Value)methodValue, (Value)Values.injectedValue(), paramValues));
    }

    private static Value<?> getValue(JBossServiceAttributeConfig attributeConfig, List<ClassReflectionIndex<?>> mBeanClassHierarchy) {
        String attributeName = attributeConfig.getName();
        Method setterMethod = ReflectionUtils.getSetter(mBeanClassHierarchy, attributeName);
        Class<?> setterType = setterMethod.getParameterTypes()[0];
        return new ImmediateValue(ParsedServiceDeploymentProcessor.newValue(setterType, attributeConfig.getValue()));
    }

    private static Object newInstance(JBossServiceConfig serviceConfig, List<ClassReflectionIndex<?>> mBeanClassHierarchy, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        JBossServiceConstructorConfig constructorConfig = serviceConfig.getConstructorConfig();
        int paramCount = constructorConfig != null ? constructorConfig.getArguments().length : 0;
        Class[] types = new Class[paramCount];
        Object[] params = new Object[paramCount];
        if (constructorConfig != null) {
            JBossServiceConstructorConfig.Argument[] arguments = constructorConfig.getArguments();
            for (int i = 0; i < paramCount; ++i) {
                JBossServiceConstructorConfig.Argument argument = arguments[i];
                types[i] = ReflectionUtils.getClass(argument.getType(), classLoader);
                params[i] = ParsedServiceDeploymentProcessor.newValue(ReflectionUtils.getClass(argument.getType(), classLoader), argument.getValue());
            }
        }
        Constructor constructor = mBeanClassHierarchy.get(0).getConstructor(types);
        Object mBeanInstance = ReflectionUtils.newInstance(constructor, params);
        return mBeanInstance;
    }

    private static Injector<Object> getPropertyInjector(String propertyName, List<ClassReflectionIndex<?>> mBeanClassHierarchy, Service<?> service, Value<?> value) {
        Method setterMethod = ReflectionUtils.getSetter(mBeanClassHierarchy, propertyName);
        return new MethodInjector(setterMethod, service, Values.nullValue(), Collections.singletonList(value));
    }

    private static Object newValue(Class<?> type, String value) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            SarLogger.DEPLOYMENT_SERVICE_LOGGER.propertyNotFound(type);
            return null;
        }
        editor.setAsText(value);
        return editor.getValue();
    }
}

