/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import org.jboss.as.domain.http.server.ErrorHandler;
import org.jboss.as.domain.http.server.RealmReadinessFilter;
import org.jboss.as.domain.http.server.ResourceHandler;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.HttpContext;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.modules.ModuleLoadException;

public enum ConsoleMode {
    CONSOLE{

        @Override
        ResourceHandler createConsoleHandler(String slot) throws ModuleLoadException {
            return new ConsoleHandler(slot);
        }
    }
    ,
    SLAVE_HC{

        @Override
        ResourceHandler createConsoleHandler(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForSlave(slot);
        }
    }
    ,
    ADMIN_ONLY{

        @Override
        ResourceHandler createConsoleHandler(String slot) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForAdminMode(slot);
        }
    }
    ,
    NO_CONSOLE{

        @Override
        ResourceHandler createConsoleHandler(String slot) throws ModuleLoadException {
            return null;
        }
    };


    ResourceHandler createConsoleHandler(String slot) throws ModuleLoadException {
        throw new IllegalStateException("Not overridden for " + (Object)((Object)this));
    }

    static class DisabledConsoleHandler
    extends ResourceHandler {
        private static final String ERROR_MODULE = "org.jboss.as.domain-http-error-context";
        private static final String CONTEXT = "/consoleerror";
        private static final String NO_CONSOLE_FOR_SLAVE = "/noConsoleForSlaveDcError.html";
        private static final String NO_CONSOLE_FOR_ADMIN_MODE = "/noConsoleForAdminModeError.html";

        private DisabledConsoleHandler(String slot, String resource) throws ModuleLoadException {
            super(CONTEXT, resource, DisabledConsoleHandler.getClassLoader(ERROR_MODULE, slot));
        }

        static DisabledConsoleHandler createNoConsoleForSlave(String slot) throws ModuleLoadException {
            return new DisabledConsoleHandler(slot, NO_CONSOLE_FOR_SLAVE);
        }

        static DisabledConsoleHandler createNoConsoleForAdminMode(String slot) throws ModuleLoadException {
            return new DisabledConsoleHandler(slot, NO_CONSOLE_FOR_ADMIN_MODE);
        }

        @Override
        protected boolean skipCache(String resource) {
            return true;
        }
    }

    private static class ConsoleHandler
    extends ResourceHandler {
        private static final String NOCACHE_JS = ".nocache.js";
        private static final String INDEX_HTML = "index.html";
        private static final String APP_HTML = "App.html";
        private static final String CONSOLE_MODULE = "org.jboss.as.console";
        private static final String CONTEXT = "/console";
        private static final String DEFAULT_RESOURCE = "/index.html";

        ConsoleHandler(String slot) throws ModuleLoadException {
            super(CONTEXT, DEFAULT_RESOURCE, ConsoleHandler.getClassLoader(CONSOLE_MODULE, slot));
        }

        @Override
        protected boolean skipCache(String resource) {
            return resource.endsWith(NOCACHE_JS) || resource.endsWith(APP_HTML) || resource.endsWith(INDEX_HTML);
        }

        @Override
        public void start(HttpServer httpServer, SecurityRealm securityRealm) {
            HttpContext httpContext = httpServer.createContext(this.getContext(), (HttpHandler)this);
            if (securityRealm != null && !securityRealm.getSupportedAuthenticationMechanisms().contains(AuthenticationMechanism.CLIENT_CERT)) {
                httpContext.getFilters().add(new RealmReadinessFilter(securityRealm, ErrorHandler.getRealmRedirect()));
            }
        }
    }
}

