/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Transaction;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor {
    private final AtomicLong invalidations = new AtomicLong(0L);
    protected Map<GlobalTransaction, List<VisitableCommand>> txMods;
    private CommandsFactory commandsFactory;
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled;
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void initTxMap() {
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead(ctx)) {
            return this.handleInvalidate(ctx, command, command.getKey());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(ctx) && ctx.isOriginLocal()) {
            this.rpcManager.broadcastRpcCommand(command, this.defaultSynchronous);
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are %s", ctx.getFlags());
        if (InvalidationInterceptor.shouldInvokeRemoteTxCommand(ctx)) {
            List<WriteCommand> mods = Arrays.asList(command.getModifications());
            Transaction runningTransaction = ctx.getTransaction();
            if (runningTransaction == null) {
                throw new IllegalStateException("we must have an associated transaction");
            }
            this.broadcastInvalidateForPrepare(mods, runningTransaction, ctx);
        } else {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        }
        return retval;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful() && !ctx.isInTxScope() && keys != null && keys.length != 0) {
            return this.invalidateAcrossCluster(this.isSynchronous(ctx), ctx, keys, ctx.isUseFutureReturnType(), retval);
        }
        return retval;
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, Transaction tx, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope() && !this.isLocalModeForced(ctx)) {
            if (modifications == null || modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, ctx, filterVisitor.result.toArray(), false, null);
                }
                catch (Throwable t) {
                    log.warn("Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected Object invalidateAcrossCluster(boolean synchronous, InvocationContext ctx, Object[] keys, boolean useFuture, Object retvalForFuture) throws Throwable {
        if (!this.isLocalModeForced(ctx)) {
            this.incrementInvalidations();
            InvalidateCommand command = this.commandsFactory.buildInvalidateCommand(keys);
            if (log.isDebugEnabled()) {
                log.debug("Cache [" + this.rpcManager.getTransport().getAddress() + "] replicating " + command);
            }
            if (useFuture) {
                NotifyingFutureImpl future = new NotifyingFutureImpl(retvalForFuture);
                this.rpcManager.broadcastRpcCommandInFuture(command, future);
                return future;
            }
            this.rpcManager.broadcastRpcCommand(command, synchronous);
        }
        return retvalForFuture;
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @Metric(displayName="Statistics enabled", dataType=DataType.TRAIT)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Operation(displayName="Enable/disable statistics")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations")
    @Metric(displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains((Object)Flag.CACHE_MODE_LOCAL);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand(command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains((Object)Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand(command);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand(command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

