/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Immutables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MarshalledValueInterceptor
extends CommandInterceptor {
    private StreamingMarshaller marshaller;
    private boolean wrapKeys = true;
    private boolean wrapValues = true;
    private InternalEntryFactory entryFactory;
    private static final Log log = LogFactory.getLog(MarshalledValueInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectMarshaller(@ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, InternalEntryFactory entryFactory) {
        this.marshaller = marshaller;
        this.entryFactory = entryFactory;
    }

    @Start
    protected void start() {
        this.wrapKeys = this.configuration.isStoreKeysAsBinary();
        this.wrapValues = this.configuration.isStoreValuesAsBinary();
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (this.wrapKeys) {
            if (command.multipleKeys()) {
                Collection<Object> rawKeys = command.getKeys();
                HashMap<Object, Object> keyToMarshalledKeyMapping = new HashMap<Object, Object>(rawKeys.size());
                for (Object k : rawKeys) {
                    if (MarshalledValue.isTypeExcluded(k.getClass())) continue;
                    keyToMarshalledKeyMapping.put(k, this.createMarshalledValue(k, ctx));
                }
                if (!keyToMarshalledKeyMapping.isEmpty()) {
                    command.replaceKeys(keyToMarshalledKeyMapping);
                }
            } else {
                Object key = command.getSingleKey();
                if (!MarshalledValue.isTypeExcluded(key.getClass())) {
                    command.replaceKey(key, this.createMarshalledValue(key, ctx));
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>(command.getMap().size());
        Map<Object, Object> map = this.wrapMap(command.getMap(), marshalledValues, ctx);
        command.setMap(map);
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.compactAndProcessRetVal(marshalledValues, retVal, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        boolean isRawComparisonRequired;
        MarshalledValue key = null;
        MarshalledValue value = null;
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getValue().getClass())) {
            value = this.createMarshalledValue(command.getValue(), ctx);
            command.setValue(value);
        }
        boolean bl = isRawComparisonRequired = !ctx.isOriginLocal() && command.getKey() instanceof MarshalledValue;
        if (isRawComparisonRequired) {
            ((MarshalledValue)command.getKey()).setEqualityPreferenceForInstance(false);
        }
        try {
            Object retVal = this.invokeNextInterceptor(ctx, command);
            this.compact(key);
            this.compact(value);
            Object object = this.processRetVal(retVal, ctx);
            return object;
        }
        finally {
            if (isRawComparisonRequired) {
                ((MarshalledValue)command.getKey()).setEqualityPreferenceForInstance(true);
            }
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        MarshalledValue value = null;
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(value);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        MarshalledValue value = null;
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(value);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        MarshalledValue mv = null;
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            mv = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(mv);
            this.compact(mv);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(mv);
        return this.processRetVal(retVal, ctx);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        Set keys = (Set)this.invokeNextInterceptor(ctx, command);
        if (this.wrapKeys) {
            HashSet copy = new HashSet(keys.size());
            for (Object key : keys) {
                if (key instanceof MarshalledValue) {
                    key = ((MarshalledValue)key).get();
                }
                copy.add(key);
            }
            return Immutables.immutableSetWrap(copy);
        }
        return Immutables.immutableSetWrap(keys);
    }

    @Override
    public Object visitValuesCommand(InvocationContext ctx, ValuesCommand command) throws Throwable {
        Collection values = (Collection)this.invokeNextInterceptor(ctx, command);
        if (this.wrapValues) {
            ArrayList copy = new ArrayList();
            for (Object value : values) {
                if (value instanceof MarshalledValue) {
                    value = ((MarshalledValue)value).get();
                }
                copy.add(value);
            }
            return Immutables.immutableCollectionWrap(copy);
        }
        return Immutables.immutableCollectionWrap(values);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        Set entries = (Set)this.invokeNextInterceptor(ctx, command);
        HashSet<InternalCacheEntry> copy = new HashSet<InternalCacheEntry>(entries.size());
        for (InternalCacheEntry entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof MarshalledValue) {
                key = ((MarshalledValue)key).get();
            }
            if (value instanceof MarshalledValue) {
                value = ((MarshalledValue)value).get();
            }
            InternalCacheEntry newEntry = Immutables.immutableInternalCacheEntry(this.entryFactory.create(key, value, entry));
            copy.add(newEntry);
        }
        return Immutables.immutableSetWrap(copy);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        MarshalledValue key = null;
        MarshalledValue newValue = null;
        MarshalledValue oldValue = null;
        if (this.wrapKeys && !MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (this.wrapValues && !MarshalledValue.isTypeExcluded(command.getNewValue().getClass())) {
            newValue = this.createMarshalledValue(command.getNewValue(), ctx);
            command.setNewValue(newValue);
        }
        if (this.wrapValues && command.getOldValue() != null && !MarshalledValue.isTypeExcluded(command.getOldValue().getClass())) {
            oldValue = this.createMarshalledValue(command.getOldValue(), ctx);
            command.setOldValue(oldValue);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(key);
        this.compact(newValue);
        this.compact(oldValue);
        return this.processRetVal(retVal, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        boolean isRemote;
        boolean bl = isRemote = !ctx.isOriginLocal();
        if (isRemote) {
            this.forceComparison(false, command);
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (isRemote) {
                this.forceComparison(true, command);
            }
        }
    }

    private void forceComparison(boolean isCompareInstance, InvalidateCommand command) {
        if (this.wrapKeys) {
            for (Object key : command.getKeys()) {
                if (!(key instanceof MarshalledValue)) continue;
                ((MarshalledValue)key).setEqualityPreferenceForInstance(isCompareInstance);
            }
        }
    }

    private Object compactAndProcessRetVal(Set<MarshalledValue> marshalledValues, Object retVal, InvocationContext ctx) {
        if (trace) {
            log.trace("Compacting MarshalledValues created");
        }
        for (MarshalledValue mv : marshalledValues) {
            this.compact(mv);
        }
        return this.processRetVal(retVal, ctx);
    }

    private void compact(MarshalledValue mv) {
        if (mv == null) {
            return;
        }
        mv.compact(false, false);
    }

    private Object processRetVal(Object retVal, InvocationContext ctx) {
        if (retVal instanceof MarshalledValue && ctx.isOriginLocal()) {
            if (trace) {
                log.tracef("Return is a marshall value, so extract instance from: %s", retVal);
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    protected Map<Object, Object> wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) {
        if (m == null) {
            if (trace) {
                log.trace("Map is nul; returning an empty map.");
            }
            return Collections.emptyMap();
        }
        if (trace) {
            log.tracef("Wrapping map contents of argument %s", m);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>(m.size());
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object newValue;
            Object key = me.getKey();
            Object value = me.getValue();
            Object newKey = key == null || MarshalledValue.isTypeExcluded(key.getClass()) || !this.wrapKeys ? key : this.createMarshalledValue(key, ctx);
            Object object = newValue = value == null || MarshalledValue.isTypeExcluded(value.getClass()) || !this.wrapValues ? value : this.createMarshalledValue(value, ctx);
            if (newKey instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newKey);
            }
            if (newValue instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newValue);
            }
            copy.put(newKey, newValue);
        }
        return copy;
    }

    protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) {
        return new MarshalledValue(toWrap, ctx.isOriginLocal(), this.marshaller);
    }
}

