/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v11;

import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.v11.DsPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;

public class DsPoolImpl
extends CommonPoolImpl
implements DsPool {
    private static final long serialVersionUID = -8705723067326455982L;
    protected final Boolean allowMultipleUsers;

    public DsPoolImpl(Integer minPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean allowMultipleUsers) throws ValidateException {
        super(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy);
        this.allowMultipleUsers = allowMultipleUsers;
    }

    public final Boolean isAllowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(DsPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(DsPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(DsPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(DsPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(DsPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(DsPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(DsPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(DsPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(DsPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(DsPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.allowMultipleUsers != null && this.allowMultipleUsers.booleanValue()) {
            sb.append("<").append(DsPool.Tag.ALLOW_MULTIPLE_USERS).append("/>");
        }
        sb.append("</pool>");
        return sb.toString();
    }
}

