/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentManagerTarget;
import org.jboss.as.ee.deployment.spi.DeploymentMessages;
import org.jboss.as.ee.deployment.spi.DeploymentMetaData;
import org.jboss.as.ee.deployment.spi.DeploymentWorker;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.JarUtils;
import org.jboss.as.ee.deployment.spi.TargetModuleExt;
import org.jboss.as.ee.deployment.spi.TargetModuleIDImpl;
import org.jboss.as.ee.deployment.spi.TargetModuleInfo;
import org.jboss.as.ee.deployment.spi.URIParser;
import org.jboss.as.ee.deployment.spi.configurations.WarConfiguration;
import org.jboss.as.ee.deployment.spi.status.DeploymentStatusImpl;
import org.jboss.as.ee.deployment.spi.status.ProgressObjectImpl;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.util.xml.JBossEntityResolver;
import org.xml.sax.EntityResolver;

public class DeploymentManagerImpl
implements DeploymentManager {
    public static final String DEPLOYER_URI = "http://org.jboss.as.ee.deployment/jsr88";
    private Target[] targets;
    private final URI deployURI;
    private boolean isConnected;
    private final ModelControllerClient client;

    public DeploymentManagerImpl(URI deployURI, boolean isConnected) {
        this(deployURI, isConnected, null, null);
    }

    public DeploymentManagerImpl(URI deployURI, boolean isConnected, String username, String password) {
        this.deployURI = deployURI;
        this.isConnected = isConnected;
        this.targets = null;
        this.client = isConnected ? DeploymentManagerImpl.create(deployURI, username, password) : null;
    }

    public Target[] getTargets() {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        if (this.targets == null) {
            if (this.deployURI.isOpaque()) {
                throw new UnsupportedOperationException(DeploymentMessages.MESSAGES.opaqueDeploymentUriNotImplemented());
            }
            DeploymentLogger.ROOT_LOGGER.debugf("Non-Opaque URI seen, checking query for targetType", new Object[0]);
            URIParser parser = new URIParser(this.deployURI);
            String targetType = parser.getParameter("targetType");
            if ("as7".equals(targetType)) {
                this.targets = new Target[]{new DeploymentManagerTarget(this.deployURI, this.client)};
            } else {
                throw new IllegalArgumentException(DeploymentMessages.MESSAGES.invalidTargetType(this.deployURI));
            }
        }
        return this.targets;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("getRunningModules [type=%s,targets=%s]", moduleType, Arrays.asList(targets));
        HashSet<TargetModuleExt> moduleSet = new HashSet<TargetModuleExt>();
        TargetModuleID[] availableModules = this.getAvailableModules(moduleType, targets);
        if (availableModules == null) {
            DeploymentLogger.ROOT_LOGGER.debugf("No modules available", new Object[0]);
            return null;
        }
        for (int i = 0; i < availableModules.length; ++i) {
            TargetModuleExt moduleID = (TargetModuleExt)availableModules[i];
            if (!moduleID.isRunning()) continue;
            moduleSet.add(moduleID);
        }
        DeploymentLogger.ROOT_LOGGER.debugf("Found [%d] running modules", moduleSet.size());
        TargetModuleID[] idarr = new TargetModuleID[moduleSet.size()];
        moduleSet.toArray(idarr);
        return idarr;
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("getNonRunningModules [type=%s,targets=%s]", moduleType, Arrays.asList(targets));
        HashSet<TargetModuleExt> moduleSet = new HashSet<TargetModuleExt>();
        TargetModuleID[] availableModules = this.getAvailableModules(moduleType, targets);
        if (availableModules == null) {
            DeploymentLogger.ROOT_LOGGER.debugf("No modules available", new Object[0]);
            return null;
        }
        for (int i = 0; i < availableModules.length; ++i) {
            TargetModuleExt moduleID = (TargetModuleExt)availableModules[i];
            if (moduleID.isRunning()) continue;
            moduleSet.add(moduleID);
        }
        DeploymentLogger.ROOT_LOGGER.debugf("Found [%d] non running modules", moduleSet.size());
        TargetModuleID[] idarr = new TargetModuleID[moduleSet.size()];
        moduleSet.toArray(idarr);
        return idarr;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("getAvailableModules [type=%s,targets=%s]", moduleType, Arrays.asList(targets));
        ArrayList<TargetModuleID> targetModules = new ArrayList<TargetModuleID>();
        for (int i = 0; i < targets.length; ++i) {
            JBossTarget target = (JBossTarget)targets[i];
            TargetModuleID[] tmids = target.getAvailableModules(moduleType);
            targetModules.addAll(Arrays.asList(tmids));
        }
        DeploymentLogger.ROOT_LOGGER.debugf("Found [%d] available modules", targetModules.size());
        if (targetModules.size() > 0) {
            TargetModuleID[] idarr = new TargetModuleID[targetModules.size()];
            targetModules.toArray(idarr);
            return idarr;
        }
        return null;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject obj) throws InvalidModuleException {
        if (obj == null) {
            throw new IllegalArgumentException(DeploymentMessages.MESSAGES.nullArgument("deployableObject"));
        }
        if (obj.getType().equals(ModuleType.WAR)) {
            return new WarConfiguration(obj);
        }
        throw new InvalidModuleException(DeploymentMessages.MESSAGES.moduleTypeNotSupported(obj.getType()));
    }

    public ProgressObject distribute(Target[] targets, File moduleArchive, File deploymentPlan) {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        FileInputStream isModuleArchive = null;
        FileInputStream isDeploymentPlan = null;
        try {
            isModuleArchive = new FileInputStream(moduleArchive);
            isDeploymentPlan = new FileInputStream(deploymentPlan);
            return this.distribute(targets, isModuleArchive, isDeploymentPlan);
        }
        catch (FileNotFoundException e) {
            String message = DeploymentMessages.MESSAGES.cannotFindDeploymentFile(e.getMessage());
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, message);
            DeploymentLogger.ROOT_LOGGER.errorf(message, new Object[0]);
            return new ProgressObjectImpl(status, null);
        }
    }

    public ProgressObject distribute(Target[] targets, InputStream moduleArchive, InputStream deploymentPlan) {
        return this.doDistribute(targets, null, moduleArchive, deploymentPlan);
    }

    public ProgressObject distribute(Target[] targets, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        return this.doDistribute(targets, type, moduleArchive, deploymentPlan);
    }

    private ProgressObject doDistribute(Target[] targets, ModuleType moduleType, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentManagerState state = new DeploymentManagerState();
        TargetModuleID[] targetModuleIDs = new TargetModuleID[targets.length];
        try {
            state.unpackDeploymentPlan(deploymentPlan);
            state.initDeploymentMetaData();
            TargetModuleInfo moduleInfo = state.createDeployment(moduleArchive);
            for (int i = 0; i < targets.length; ++i) {
                JBossTarget target = (JBossTarget)targets[i];
                String moduleID = moduleInfo.getModuleID();
                ModuleType type = moduleType != null ? moduleType : moduleInfo.getModuleType();
                File contentFile = moduleInfo.getContentFile();
                targetModuleIDs[i] = new TargetModuleIDImpl(target, moduleID, null, type, contentFile);
            }
        }
        catch (IOException e) {
            String message = DeploymentMessages.MESSAGES.deploymentValidationFailed();
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, message);
            DeploymentLogger.ROOT_LOGGER.errorf(e, message, new Object[0]);
            state.cleanup();
            return new ProgressObjectImpl(status, targetModuleIDs);
        }
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress, state);
        worker.start();
        return progress;
    }

    private static ModuleType determineModuleType(String entryName) {
        ModuleType moduleType = null;
        if (entryName.endsWith("/application.xml")) {
            moduleType = ModuleType.EAR;
        } else if (entryName.endsWith("/application-client.xml")) {
            moduleType = ModuleType.CAR;
        } else if (entryName.endsWith("/ra.xml")) {
            moduleType = ModuleType.RAR;
        } else if (entryName.endsWith("/web.xml")) {
            moduleType = ModuleType.WAR;
        } else if (entryName.endsWith("/ejb-jar.xml") || entryName.endsWith("/jboss.xml")) {
            moduleType = ModuleType.EJB;
        }
        return moduleType;
    }

    private static <T> T ifNotNull(T val, T def) {
        return val != null ? val : def;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        throw new UnsupportedOperationException();
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, InputStream inputStream, InputStream inputStream1) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        throw new UnsupportedOperationException();
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("start %s", Arrays.asList(targetModuleIDs));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.START, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress, null);
        worker.start();
        return progress;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("stop %s", Arrays.asList(targetModuleIDs));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.STOP, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress, null);
        worker.start();
        return progress;
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        DeploymentLogger.ROOT_LOGGER.debugf("undeploy %s", Arrays.asList(targetModuleIDs));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.UNDEPLOY, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress, null);
        worker.start();
        return progress;
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList) {
        if (!this.isConnected) {
            throw new IllegalStateException(DeploymentMessages.MESSAGES.deploymentManagerNotConnected());
        }
        throw new UnsupportedOperationException();
    }

    public void release() {
        this.isConnected = false;
        StreamUtils.safeClose((Closeable)this.client);
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocaleSupported(Locale locale) {
        return Locale.getDefault().equals(locale);
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{Locale.getDefault()};
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException();
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return dConfigBeanVersionType == DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionTypeSupported(DConfigBeanVersionType version) {
        return version == DConfigBeanVersionType.V1_4;
    }

    public void setDConfigBeanVersionType(DConfigBeanVersionType version) {
        throw new UnsupportedOperationException();
    }

    private static ModelControllerClient create(URI deployURI, String username, String password) {
        try {
            URIParser parser = new URIParser(deployURI);
            String serverHost = parser.getParameter("serverHost");
            String serverPort = parser.getParameter("serverPort");
            String host = serverHost != null ? serverHost : InetAddress.getLocalHost().getHostAddress();
            Integer port = serverPort != null ? Integer.parseInt(serverPort) : 9999;
            if (username != null && password != null) {
                return ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)DeploymentManagerImpl.getCallbackHandler(username, password));
            }
            return ModelControllerClient.Factory.create((String)host, (int)port);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(DeploymentMessages.MESSAGES.cannotConnectToManagementTarget(deployURI), ex);
        }
    }

    private static CallbackHandler getCallbackHandler(final String username, final String password) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }

    static class DeploymentManagerState {
        private List<File> tmpFiles = new ArrayList<File>();
        private Map<String, File> deploymentPlanMapping;
        private DeploymentMetaData metaData;

        DeploymentManagerState() {
        }

        DeploymentMetaData getDeploymentMetaData() {
            return this.metaData;
        }

        TargetModuleInfo createDeployment(InputStream moduleArchive) throws IOException {
            File tmpFile = File.createTempFile("jsr88_deployment_", ".zip");
            DeploymentLogger.ROOT_LOGGER.debugf("temporary deployment file: %s", tmpFile);
            this.tmpFiles.add(tmpFile);
            JarInputStream jis = new JarInputStream(moduleArchive);
            FileOutputStream fos = new FileOutputStream(tmpFile);
            Manifest manifest = jis.getManifest();
            JarOutputStream jos = manifest != null ? new JarOutputStream((OutputStream)fos, manifest) : new JarOutputStream(fos);
            ModuleType moduleType = null;
            JarEntry entry = jis.getNextJarEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith("/")) {
                    moduleType = (ModuleType)DeploymentManagerImpl.ifNotNull(DeploymentManagerImpl.determineModuleType(entryName), moduleType);
                    if (entryName.endsWith(".jar") || entryName.endsWith(".war")) {
                        File tmpSubModule = this.processSubModule(entryName, jis);
                        FileInputStream fis = new FileInputStream(tmpSubModule);
                        JarUtils.addJarEntry(jos, entryName, fis);
                        fis.close();
                    } else if (this.getDescriptorFile("!/" + entryName) == null) {
                        JarUtils.addJarEntry(jos, entryName, jis);
                    } else {
                        DeploymentLogger.ROOT_LOGGER.debugf("Skip entry found in deployment plan: %s", entryName);
                    }
                }
                entry = jis.getNextJarEntry();
            }
            String moduleName = this.getDeploymentMetaData().getDeploymentName();
            if (moduleType == null) {
                if (moduleName.endsWith(ModuleType.EAR.getModuleExtension())) {
                    moduleType = ModuleType.EAR;
                } else if (moduleName.endsWith(ModuleType.WAR.getModuleExtension())) {
                    moduleType = ModuleType.WAR;
                } else if (moduleName.endsWith(ModuleType.RAR.getModuleExtension())) {
                    moduleType = ModuleType.RAR;
                } else {
                    throw new RuntimeException(DeploymentMessages.MESSAGES.cannotObtainModuleType(moduleName));
                }
            }
            String depname = this.getDeploymentMetaData().getDeploymentName();
            TargetModuleInfo moduleInfo = new TargetModuleInfo(depname, moduleType, tmpFile);
            this.addDeploymentPlanEntry(jos, null);
            jos.close();
            return moduleInfo;
        }

        private File processSubModule(String entryName, JarInputStream jis) throws IOException {
            File tmpModule = this.getTempFile(entryName);
            FileOutputStream fos = new FileOutputStream(tmpModule);
            JarUtils.copyStream(fos, jis);
            fos.close();
            JarInputStream jisModule = new JarInputStream(new FileInputStream(tmpModule));
            File tmpJBossModule = this.getTempFile("jboss_" + entryName);
            JarOutputStream jos = null;
            fos = new FileOutputStream(tmpJBossModule);
            Manifest manifest = jisModule.getManifest();
            jos = manifest != null ? new JarOutputStream((OutputStream)fos, manifest) : new JarOutputStream(fos);
            JarEntry entry = jisModule.getNextJarEntry();
            while (entry != null) {
                String subEntryName = entry.getName();
                if (this.getDescriptorFile(entryName + "!/" + subEntryName) == null) {
                    JarUtils.addJarEntry(jos, subEntryName, jisModule);
                } else {
                    DeploymentLogger.ROOT_LOGGER.debugf("Skip entry found in deployment plan: %s", subEntryName);
                }
                entry = jisModule.getNextJarEntry();
            }
            jisModule.close();
            this.addDeploymentPlanEntry(jos, entryName);
            jos.close();
            return tmpJBossModule;
        }

        void cleanup() {
            for (File tmpFile : this.tmpFiles) {
                if (tmpFile.exists()) {
                    if (tmpFile.delete()) continue;
                    DeploymentLogger.ROOT_LOGGER.cannotDeleteDeploymentFile(tmpFile);
                    tmpFile.deleteOnExit();
                    continue;
                }
                DeploymentLogger.ROOT_LOGGER.deploymentDoesNotExist(tmpFile);
            }
        }

        File getDescriptorFile(String entry) {
            return this.deploymentPlanMapping.get(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unpackDeploymentPlan(InputStream deploymentPlan) throws IOException {
            if (deploymentPlan == null) {
                return;
            }
            this.deploymentPlanMapping = new HashMap<String, File>();
            try {
                JarInputStream jarDeploymentPlan = new JarInputStream(deploymentPlan);
                JarEntry entry = jarDeploymentPlan.getNextJarEntry();
                while (entry != null) {
                    String entryName = entry.getName();
                    DeploymentLogger.ROOT_LOGGER.debugf("unpack deployment plan entry: %s", entryName);
                    File tempFile = this.getTempFile(entryName);
                    this.deploymentPlanMapping.put(entryName, tempFile);
                    FileOutputStream out = new FileOutputStream(tempFile);
                    JarUtils.copyStream(out, jarDeploymentPlan);
                    out.close();
                    entry = jarDeploymentPlan.getNextJarEntry();
                }
            }
            finally {
                deploymentPlan.close();
            }
        }

        void initDeploymentMetaData() throws IOException {
            File metaTmpFile = this.deploymentPlanMapping.get("deployment-plan.xml");
            if (metaTmpFile == null) {
                throw new IOException(DeploymentMessages.MESSAGES.deploymentPlanDoesNotContainEntry("deployment-plan.xml"));
            }
            try {
                SAXReader reader = new SAXReader();
                reader.setEntityResolver((EntityResolver)new JBossEntityResolver());
                Document metaDoc = reader.read(metaTmpFile);
                this.metaData = new DeploymentMetaData(metaDoc);
                DeploymentLogger.ROOT_LOGGER.debugf("deployment-plan.xml\n" + this.metaData.toXMLString(), new Object[0]);
            }
            catch (Exception e) {
                DeploymentLogger.ROOT_LOGGER.errorf(e, DeploymentMessages.MESSAGES.cannotObtainMetaData(), new Object[0]);
            }
        }

        void addDeploymentPlanEntry(JarOutputStream jos, String moduleName) throws IOException {
            if (moduleName == null) {
                moduleName = "";
            }
            String moduleKey = moduleName + "!/";
            for (String key : this.deploymentPlanMapping.keySet()) {
                if (!key.startsWith(moduleKey)) continue;
                String dpName = key.substring(moduleKey.length());
                DeploymentLogger.ROOT_LOGGER.debugf("found deployment plan entry: %s", dpName);
                File dpFile = this.deploymentPlanMapping.get(key);
                FileInputStream dpin = new FileInputStream(dpFile);
                JarUtils.addJarEntry(jos, dpName, dpin);
                dpin.close();
            }
        }

        private File getTempFile(String entryName) throws IOException {
            entryName = entryName.replace('/', '_');
            int index = entryName.lastIndexOf(".");
            String prefix = entryName.substring(0, index);
            String suffix = entryName.substring(index);
            File tempFile = File.createTempFile("jsr88_" + prefix, suffix);
            this.tmpFiles.add(tempFile);
            return tempFile;
        }
    }
}

