/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.msc.service.ServiceName;

public class MessagingServices {
    private static final ServiceName JBOSS_MESSAGING = ServiceName.JBOSS.append(new String[]{"messaging"});
    private static final String CORE_QUEUE_BASE = "queue";
    private static final String STARTUP_POOL = "startup-pool";

    public static ServiceName getHornetQServiceName(PathAddress pathAddress) {
        String hornetQServerName = null;
        for (int i = pathAddress.size() - 1; i >= 0; --i) {
            PathElement pe = pathAddress.getElement(i);
            if (!"hornetq-server".equals(pe.getKey())) continue;
            hornetQServerName = pe.getValue();
            break;
        }
        return JBOSS_MESSAGING.append(new String[]{hornetQServerName});
    }

    public static ServiceName getHornetQServiceName(String serverName) {
        return JBOSS_MESSAGING.append(new String[]{serverName});
    }

    public static ServiceName getHornetQStartupPoolServiceName(ServiceName hqServiceName) {
        return hqServiceName.append(new String[]{STARTUP_POOL});
    }

    public static ServiceName getQueueBaseServiceName(ServiceName hornetqServiceName) {
        return hornetqServiceName.append(new String[]{CORE_QUEUE_BASE});
    }

    public static enum TransportConfigType {
        Remote,
        InVM,
        Generic;

    }
}

