/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.LocalKeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.impl.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryService;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.DistributedCacheManager;
import org.jboss.as.clustering.web.DistributedCacheManagerFactoryService;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshallerFactory;
import org.jboss.as.clustering.web.impl.SessionAttributeMarshallerFactoryImpl;
import org.jboss.as.clustering.web.impl.TransactionBatchingManager;
import org.jboss.as.clustering.web.infinispan.InfinispanWebMessages;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactory;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactoryImpl;
import org.jboss.as.clustering.web.infinispan.WebSessionCacheConfigurationService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class DistributedCacheManagerFactory
implements org.jboss.as.clustering.web.DistributedCacheManagerFactory {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private static final ServiceName JVM_ROUTE_REGISTRY_SERVICE_NAME = DistributedCacheManagerFactoryService.JVM_ROUTE_REGISTRY_ENTRY_PROVIDER_SERVICE_NAME.getParent();
    private SessionAttributeStorageFactory storageFactory = new SessionAttributeStorageFactoryImpl();
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private SessionAttributeMarshallerFactory marshallerFactory = new SessionAttributeMarshallerFactoryImpl();
    private KeyAffinityServiceFactory affinityFactory = new LocalKeyAffinityServiceFactory((Executor)Executors.newSingleThreadExecutor(), 10);
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<SharedLocalYieldingClusterLockManager> lockManager = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();

    public <T extends OutgoingDistributableSessionData> DistributedCacheManager<T> getDistributedCacheManager(LocalDistributableSessionManager manager) throws ClusteringNotSupportedException {
        Registry jvmRouteRegistry = (Registry)this.registry.getValue();
        AdvancedCache cache = ((Cache)this.cache.getValue()).getAdvancedCache();
        if (!cache.getCacheConfiguration().invocationBatching().enabled()) {
            ServiceName cacheServiceName = this.getCacheServiceName(manager.getReplicationConfig());
            throw new ClusteringNotSupportedException(InfinispanWebMessages.MESSAGES.failedToConfigureWebApp(cacheServiceName.getParent().getSimpleName(), cacheServiceName.getSimpleName()));
        }
        TransactionBatchingManager batchingManager = new TransactionBatchingManager(cache.getTransactionManager());
        SessionAttributeStorage storage = this.storageFactory.createStorage(manager.getReplicationConfig().getReplicationGranularity(), this.marshallerFactory.createMarshaller(manager));
        return new org.jboss.as.clustering.web.infinispan.DistributedCacheManager(manager, (Cache<String, Map<Object, Object>>)new AtomicMapCache(cache), (Registry<String, Void>)jvmRouteRegistry, (SharedLocalYieldingClusterLockManager)this.lockManager.getOptionalValue(), storage, (BatchingManager)batchingManager, this.invoker, this.affinityFactory);
    }

    public boolean addDeploymentDependencies(ServiceName deploymentServiceName, ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, JBossWebMetaData metaData) {
        ServiceName templateCacheServiceName = this.getCacheServiceName(metaData.getReplicationConfig());
        if (registry.getService(templateCacheServiceName) == null) {
            return false;
        }
        String templateCacheName = templateCacheServiceName.getSimpleName();
        ServiceName containerServiceName = templateCacheServiceName.getParent();
        String containerName = containerServiceName.getSimpleName();
        ServiceName templateCacheConfigurationServiceName = AbstractCacheConfigurationService.getServiceName((String)containerName, (String)templateCacheName);
        String cacheName = deploymentServiceName.getParent().getSimpleName() + deploymentServiceName.getSimpleName();
        ServiceName cacheConfigurationServiceName = AbstractCacheConfigurationService.getServiceName((String)containerName, (String)cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName((String)containerName, (String)cacheName);
        InjectedValue container = new InjectedValue();
        InjectedValue config = new InjectedValue();
        target.addService(cacheConfigurationServiceName, (Service)new WebSessionCacheConfigurationService(cacheName, (Value<EmbeddedCacheManager>)container, (Value<Configuration>)config)).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)container).addDependency(templateCacheConfigurationServiceName, Configuration.class, (Injector)config).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        final InjectedValue cacheContainer = new InjectedValue();
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)cacheContainer.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        target.addService(cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addDependency(cacheConfigurationServiceName).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)cacheContainer).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        builder.addDependency(cacheServiceName, Cache.class, this.cache);
        builder.addDependency(JVM_ROUTE_REGISTRY_SERVICE_NAME, Registry.class, this.registry);
        builder.addDependency(SharedLocalYieldingClusterLockManagerService.getServiceName((String)containerName), SharedLocalYieldingClusterLockManager.class, this.lockManager);
        return true;
    }

    public Collection<ServiceController<?>> installServices(ServiceTarget target) {
        InjectedValue cache = new InjectedValue();
        InjectedValue providerValue = new InjectedValue();
        ServiceController controller = target.addService(JVM_ROUTE_REGISTRY_SERVICE_NAME, (Service)new RegistryService((Value)cache, (Value)providerValue)).addDependency(CacheService.getServiceName((String)DEFAULT_CACHE_CONTAINER, null), Cache.class, (Injector)cache).addDependency(DistributedCacheManagerFactoryService.JVM_ROUTE_REGISTRY_ENTRY_PROVIDER_SERVICE_NAME, Registry.RegistryEntryProvider.class, (Injector)providerValue).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Collections.singleton(controller);
    }

    private ServiceName getCacheServiceName(ReplicationConfig config) {
        String cacheName;
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = config != null ? config.getCacheName() : null) != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"___defaultcache"}) : serviceName;
    }

    public Injector<Registry> getRegistryInjector() {
        return this.registry;
    }

    public Injector<SharedLocalYieldingClusterLockManager> getLockManagerInjector() {
        return this.lockManager;
    }

    public Injector<Cache> getCacheInjector() {
        return this.cache;
    }

    public void setSessionAttributeMarshallerFactory(SessionAttributeMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setSessionAttributeStorageFactory(SessionAttributeStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void setCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }
}

