/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;

public class OSGiExtensionLocator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(OSGiExtensionLocator.class);
    private ConcurrentMap<Long, List<Extension>> extensions = new ConcurrentHashMap<Long, List<Extension>>();
    private long id;
    private Extension listener;

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            try {
                this.register(event.getBundle());
            }
            catch (Exception exception) {}
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        this.id = context.getBundle().getBundleId();
        this.registerBusListener();
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId()) continue;
            this.register(bundle);
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.unregisterBusListener();
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
    }

    private void registerBusListener() {
        this.listener = new Extension(OSGIBusListener.class);
        ExtensionRegistry.addExtensions(Collections.singletonList(this.listener));
    }

    private void unregisterBusListener() {
        ExtensionRegistry.removeExtensions(Collections.singletonList(this.listener));
        this.listener = null;
    }

    protected void register(Bundle bundle) throws IOException {
        CopyOnWriteArrayList<Extension> list = (CopyOnWriteArrayList<Extension>)this.extensions.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                InputStream ins = u.openStream();
                List<Extension> orig = new ExtensionFragmentParser().getExtensionsFromText(ins);
                ins.close();
                LOG.info("Loading the extension from bundle " + bundle.getBundleId());
                if (orig == null || orig.isEmpty()) continue;
                if (list == null) {
                    list = new CopyOnWriteArrayList<Extension>();
                    this.extensions.put(bundle.getBundleId(), list);
                }
                for (Extension ext : orig) {
                    list.add(new OSGiExtension(ext, bundle));
                }
                ExtensionRegistry.addExtensions(list);
            }
        }
    }

    protected void unregister(long bundleId) {
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            LOG.info("Removed the extensions for bundle " + bundleId);
            ExtensionRegistry.removeExtensions(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        @Override
        public Class<?> getClassObject(ClassLoader cl) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.bundle.loadClass(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.getClassObject(cl);
        }

        @Override
        public Class<?> loadInterface(ClassLoader cl) {
            try {
                return this.bundle.loadClass(this.interfaceName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadInterface(cl);
            }
        }

        @Override
        public Extension cloneNoObject() {
            OSGiExtension ext = new OSGiExtension(this, this.bundle);
            ext.obj = null;
            return ext;
        }
    }

    public static class OSGIBusListener
    implements BusLifeCycleListener {
        public static final String CONTEXT_SYMBOLIC_NAME_PROPERTY = "cxf.context.symbolicname";
        public static final String CONTEXT_VERSION_PROPERTY = "cxf.context.version";
        public static final String CONTEXT_NAME_PROPERTY = "cxf.bus.id";
        Bus bus;
        ServiceRegistration service;

        public OSGIBusListener(Bus b) {
            this.bus = b;
            ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }

        private Version getBundleVersion(Bundle bundle) {
            Dictionary headers = bundle.getHeaders();
            String version = (String)headers.get("Bundle-Version");
            return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
        }

        public void initComplete() {
            BundleContext context = (BundleContext)this.bus.getExtension(BundleContext.class);
            if (context != null) {
                Properties props = new Properties();
                props.put(CONTEXT_SYMBOLIC_NAME_PROPERTY, context.getBundle().getSymbolicName());
                props.put(CONTEXT_VERSION_PROPERTY, this.getBundleVersion(context.getBundle()));
                props.put(CONTEXT_NAME_PROPERTY, this.bus.getId());
                this.service = context.registerService(Bus.class.getName(), (Object)this.bus, (Dictionary)props);
            }
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            if (this.service != null) {
                this.service.unregister();
                this.service = null;
            }
        }
    }
}

