/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.DeserializerSupport;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QNameDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger(QNameDeserializer.class);

    @Override
    public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
        return this.deserialize(xmlName, xmlType, this.sourceToElement(xmlFragment), serContext);
    }

    private Object deserialize(QName xmlName, QName xmlType, Element xmlFragment, SerializationContext serContext) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        QName value = null;
        String valueStr = this.unwrapValueStr(xmlFragment);
        if (valueStr != null) {
            NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
            this.updateNamespaceRegistry(xmlFragment, nsRegistry);
            value = SimpleTypeBindings.unmarshalQName((String)valueStr, (NamespaceContext)nsRegistry);
        }
        return value;
    }

    private void updateNamespaceRegistry(Element xmlFragment, NamespaceRegistry nsRegistry) {
        NamedNodeMap attribs = xmlFragment.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Node attr = attribs.item(i);
            String nodeName = attr.getNodeName();
            if (!nodeName.startsWith("xmlns:")) continue;
            String prefix = nodeName.substring(6);
            String nsURI = attr.getNodeValue();
            nsRegistry.registerURI(nsURI, prefix);
        }
    }
}

