/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.extensions.json.BadgerFishDOMDocumentParser;
import org.w3c.dom.Document;

public class JsonMessageUnMarshaller
implements UnMarshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JsonMessageUnMarshaller.class);
    private static Logger log = Logger.getLogger(JsonMessageUnMarshaller.class);

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata, Map<String, Object> headers) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            MessageFactoryImpl factory = new MessageFactoryImpl();
            SOAPMessage soapMsg = factory.createMessage();
            Document doc = new BadgerFishDOMDocumentParser().parse(inputStream);
            soapMsg.getSOAPBody().addDocument(doc);
            return soapMsg;
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_JSON_INPUT_STREAM", (Object[])new Object[0]));
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

