/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.jaxrpc;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.Constants;
import org.jboss.ws.extensions.security.WSSecurityDispatcher;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public abstract class WSSecurityHandler
extends GenericHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSSecurityHandler.class);
    private static Logger log = Logger.getLogger(WSSecurityHandler.class);
    protected static String FAULT_THROWN = "org.jboss.ws.wsse.faultThrown";

    public QName[] getHeaders() {
        return new QName[]{Constants.WSSE_HEADER_QNAME};
    }

    protected boolean thrownByMe(MessageContext msgContext) {
        Boolean bool = (Boolean)msgContext.getProperty(FAULT_THROWN);
        return bool != null && bool != false;
    }

    protected boolean handleInboundSecurity(MessageContext msgContext) {
        SOAPException exception = null;
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                new WSSecurityDispatcher().decodeMessage(configuration, soapMessage, null);
            }
        }
        catch (SOAPException ex) {
            exception = ex;
        }
        if (exception != null) {
            msgContext.setProperty(FAULT_THROWN, (Object)true);
            if (exception instanceof SOAPFaultException) {
                throw (SOAPFaultException)((Object)exception);
            }
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_HANDLE_INBOUND_WSSE", (Object[])new Object[0]), (Throwable)exception);
            return false;
        }
        return true;
    }

    protected boolean handleOutboundSecurity(MessageContext msgContext) {
        SOAPException exception = null;
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                String user = (String)ctx.get("javax.xml.rpc.security.auth.username");
                String pass = (String)ctx.get("javax.xml.rpc.security.auth.password");
                new WSSecurityDispatcher().encodeMessage(configuration, soapMessage, null, user, pass);
            }
        }
        catch (SOAPException ex) {
            exception = ex;
        }
        if (exception != null) {
            msgContext.setProperty(FAULT_THROWN, (Object)true);
            if (exception instanceof SOAPFaultException) {
                throw (SOAPFaultException)((Object)exception);
            }
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_HANDLE_OUTBOUND_WSSE", (Object[])new Object[0]), (Throwable)exception);
            return false;
        }
        return true;
    }

    private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext) {
        EndpointMetaData epMetaData = ((CommonMessageContext)msgContext).getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        WSSecurityConfiguration config = serviceMetaData.getSecurityConfiguration();
        if (config == null) {
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
                config = wsseConfFactory.createConfiguration(vfsRoot, this.getConfigResourceName());
            }
            catch (IOException e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_SECURITY_CONFIG", (Object[])new Object[]{this.getConfigResourceName()}));
            }
            serviceMetaData.setSecurityConfiguration(config);
        }
        return config;
    }

    protected abstract String getConfigResourceName();
}

