/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.Constants;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.Versions;
import org.xnio.AbstractIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class VersionedConectionFactory {
    private static final Logger log = Logger.getLogger(VersionedConectionFactory.class);

    VersionedConectionFactory() {
    }

    static VersionedConnection createVersionedConnection(Channel channel, Map<String, ?> environment) throws IOException {
        IoFuture<InitialHeader> futureHeader = ClientVersionReceiver.getInitialHeader(channel);
        IoFuture.Status result = futureHeader.await(5L, TimeUnit.SECONDS);
        switch (result) {
            case DONE: {
                break;
            }
            case FAILED: {
                throw futureHeader.getException();
            }
            default: {
                throw new IOException("Timeout out waiting for header, status=" + result.toString());
            }
        }
        InitialHeader header = (InitialHeader)futureHeader.get();
        byte highest = 0;
        for (byte current : header.versions) {
            if (current <= highest) continue;
            highest = current;
        }
        return Versions.getVersionedConnection(highest, channel, environment);
    }

    private static class VersionedIoFuture<T>
    extends AbstractIoFuture<T> {
        private VersionedIoFuture() {
        }

        protected boolean setResult(T result) {
            return super.setResult(result);
        }

        protected boolean setException(IOException exception) {
            return super.setException(exception);
        }
    }

    private static class InitialHeader {
        private byte[] versions;
        private byte stability;

        private InitialHeader() {
        }

        static /* synthetic */ byte[] access$002(InitialHeader x0, byte[] x1) {
            x0.versions = x1;
            return x1;
        }
    }

    private static class ClientVersionReceiver
    implements Channel.Receiver {
        private final VersionedIoFuture<InitialHeader> future;

        private ClientVersionReceiver(VersionedIoFuture<InitialHeader> future) {
            this.future = future;
        }

        public static IoFuture<InitialHeader> getInitialHeader(Channel channel) {
            VersionedIoFuture<InitialHeader> future = new VersionedIoFuture<InitialHeader>();
            channel.receiveMessage((Channel.Receiver)new ClientVersionReceiver(future));
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream((InputStream)messageInputStream);
            try {
                log.tracef("Bytes Available %d", (Object)dis.available());
                byte[] firstThree = new byte[3];
                dis.read(firstThree);
                log.tracef("First Three %s", (Object)new String(firstThree));
                if (!Arrays.equals(firstThree, Constants.JMX)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                log.tracef("Bytes Available %d", (Object)dis.available());
                int versionCount = dis.readInt();
                log.tracef("Expecting %d versions", (Object)versionCount);
                byte[] versions = new byte[versionCount];
                dis.read(versions);
                if (log.isDebugEnabled()) {
                    StringBuffer sbVersions = new StringBuffer("Versions ");
                    for (byte current : versions) {
                        sbVersions.append(" 0x0").append(current);
                    }
                    log.debugf("Available version (%s)", (Object)sbVersions);
                }
                byte stability = dis.readByte();
                switch (stability) {
                    case 0: {
                        log.debug((Object)"Calling a stable server");
                        break;
                    }
                    case 1: {
                        log.warn((Object)"Calling a snapshot server");
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognised stability value.");
                    }
                }
                InitialHeader ih = new InitialHeader();
                InitialHeader.access$002(ih, versions);
                ih.stability = stability;
                this.future.setResult(ih);
            }
            catch (IOException e) {
                log.error((Object)"Unable to negotiate connection.", (Throwable)e);
                this.future.setException(e);
            }
            finally {
                IoUtils.safeClose((Closeable)dis);
            }
        }

        public void handleError(Channel channel, IOException e) {
            log.error((Object)"Error on channel", (Throwable)e);
            this.future.setException(e);
        }

        public void handleEnd(Channel channel) {
            log.error((Object)"Channel ended.");
            this.future.setException(new IOException("Channel ended"));
        }
    }
}

