/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Comparator;
import org.jacorb.notification.interfaces.Message;

public class QueueUtil {
    static final Message[] MESSAGE_ARRAY_TEMPLATE = new Message[0];
    public static Comparator ASCENDING_TIMEOUT_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            Message _left = (Message)left;
            Message _right = (Message)right;
            if (_left.hasTimeout()) {
                if (!_right.hasTimeout()) {
                    return -1;
                }
                return QueueUtil.compareLong(_left.getTimeout(), _right.getTimeout());
            }
            if (_right.hasTimeout()) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator ASCENDING_INSERT_ORDER_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            Message _left = (Message)left;
            Message _right = (Message)right;
            return QueueUtil.compareLong(_left.getReceiveTimestamp(), _right.getReceiveTimestamp());
        }
    };
    public static Comparator DESCENDING_INSERT_ORDER_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return -ASCENDING_INSERT_ORDER_COMPARATOR.compare(left, right);
        }
    };
    public static Comparator ASCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            Message _right = (Message)right;
            Message _left = (Message)left;
            return _left.getPriority() - _right.getPriority();
        }
    };
    public static Comparator DESCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return -ASCENDING_PRIORITY_COMPARATOR.compare(left, right);
        }
    };

    private QueueUtil() {
    }

    private static int compareLong(long left, long right) {
        return left < right ? -1 : (left == right ? 0 : 1);
    }
}

