/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.MessageQueueAdapter;
import org.jacorb.notification.queue.RWLockEventQueueDecorator;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.TypedProxyPullSupplierImplMBean;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.Repository;
import org.omg.CORBA.ServerRequest;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullConsumer;
import org.omg.CosNotification.EventTypeHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullSupplierOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullSupplierPOATie;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPullSupplierImpl
extends AbstractProxySupplier
implements TypedProxyPullSupplierOperations,
ITypedProxy,
TypedProxyPullSupplierImplMBean {
    private final Any trueAny_;
    private final Any falseAny_;
    private final DynAnyFactory dynAnyFactory_;
    private final String supportedInterface_;
    private PullConsumer pullConsumer_;
    private TypedProxyPullSupplier typedProxyPullSupplierServant_;
    private Object typedProxyPullSupplier_;
    private final Map messageQueueMap_;
    private final Map invalidResponses_;
    private final Repository repository_;
    private PropertySetAdapter reconfigureEventQueues_ = new PropertySetAdapter(){

        public void actionPropertySetChanged(PropertySet source) {
            TypedProxyPullSupplierImpl.this.configureEventQueue();
        }
    };

    private final NVList prepareResponse(Message mesg) {
        try {
            Property[] _props = mesg.toTypedEvent();
            NVList _args = this.getORB().create_list(_props.length - 1);
            for (int x = 1; x < _props.length; ++x) {
                _args.add_value(_props[x].name, _props[x].value, 2);
            }
            return _args;
        }
        catch (NoTranslationException e) {
            throw new RuntimeException();
        }
    }

    public TypedProxyPullSupplierImpl(ITypedAdmin admin, ConsumerAdmin consumerAdmin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager, DynAnyFactory dynAnyFactory, Repository repository) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.trueAny_ = orb.create_any();
        this.falseAny_ = orb.create_any();
        this.trueAny_.insert_boolean(true);
        this.falseAny_.insert_boolean(false);
        this.supportedInterface_ = admin.getSupportedInterface();
        this.dynAnyFactory_ = dynAnyFactory;
        this.repository_ = repository;
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, (PropertySetListener)this.reconfigureEventQueues_);
        try {
            FullInterfaceDescription interfaceDescription = this.getInterfaceDescription();
            this.validateInterface(interfaceDescription);
            this.messageQueueMap_ = Collections.unmodifiableMap(this.newMessageQueueMap(interfaceDescription));
            this.invalidResponses_ = Collections.unmodifiableMap(this.newInvalidResponseMap(interfaceDescription));
        }
        catch (InconsistentTypeCode e) {
            throw new RuntimeException();
        }
    }

    private void ensureMethodOnlyUsesOutParams(OperationDescription operation) throws IllegalArgumentException {
        int _noOfParameters = operation.parameters.length;
        for (int x = 0; x < _noOfParameters; ++x) {
            switch (operation.parameters[x].mode.value()) {
                case 0: 
                case 2: {
                    throw new IllegalArgumentException("only OUT params allowed");
                }
            }
        }
    }

    private void prepareInvalidResponse(Map map, OperationDescription operation) throws InconsistentTypeCode {
        NVList _expectedParams = this.getORB().create_list(operation.parameters.length);
        for (int x = 0; x < operation.parameters.length; ++x) {
            DynAny _dynAny = this.dynAnyFactory_.create_dyn_any_from_type_code(operation.parameters[x].type);
            _expectedParams.add_value(operation.parameters[x].name, _dynAny.to_any(), 2);
        }
        map.put(operation.name, _expectedParams);
    }

    private final Map newMessageQueueMap(FullInterfaceDescription interfaceDescription) {
        HashMap<String, RWLockEventQueueDecorator> map = new HashMap<String, RWLockEventQueueDecorator>();
        for (int x = 0; x < interfaceDescription.operations.length; ++x) {
            if (interfaceDescription.operations[x].name.startsWith("try_")) continue;
            this.logger_.debug("Create Queue for Operation: " + interfaceDescription.operations[x].name);
            MessageQueueAdapter _messageQueue = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
            map.put(interfaceDescription.operations[x].name, new RWLockEventQueueDecorator(_messageQueue));
        }
        return map;
    }

    private final Map newInvalidResponseMap(FullInterfaceDescription interfaceDescription) throws InconsistentTypeCode {
        HashMap map = new HashMap();
        for (int x = 0; x < interfaceDescription.operations.length; ++x) {
            if (interfaceDescription.operations[x].name.startsWith("try_")) continue;
            this.prepareInvalidResponse(map, interfaceDescription.operations[x]);
        }
        return map;
    }

    private final void validateInterface(FullInterfaceDescription interfaceDescription) {
        for (int x = 0; x < interfaceDescription.operations.length; ++x) {
            this.ensureMethodOnlyUsesOutParams(interfaceDescription.operations[x]);
        }
    }

    private FullInterfaceDescription getInterfaceDescription() {
        InterfaceDef _interfaceDef = InterfaceDefHelper.narrow(this.repository_.lookup_id(this.supportedInterface_));
        return _interfaceDef.describe_interface();
    }

    private final void configureEventQueue() {
        try {
            for (String _key : this.messageQueueMap_.keySet()) {
                RWLockEventQueueDecorator _queueAdapter = (RWLockEventQueueDecorator)this.messageQueueMap_.get(_key);
                MessageQueueAdapter _newQueue = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
                _queueAdapter.replaceDelegate(_newQueue);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public int getPendingMessagesCount() {
        try {
            Iterator i = this.messageQueueMap_.keySet().iterator();
            int _count = 0;
            while (i.hasNext()) {
                String _key = (String)i.next();
                RWLockEventQueueDecorator _queueAdapter = (RWLockEventQueueDecorator)this.messageQueueMap_.get(_key);
                _count += _queueAdapter.getPendingMessagesCount();
            }
            return _count;
        }
        catch (InterruptedException e) {
            return -1;
        }
    }

    public Any pull() throws Disconnected {
        throw new NO_IMPLEMENT();
    }

    public Any try_pull(BooleanHolder booleanHolder) throws Disconnected {
        throw new NO_IMPLEMENT();
    }

    public void disconnect_pull_supplier() {
        this.destroy();
    }

    public void connect_typed_pull_consumer(PullConsumer pullConsumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.connectClient(pullConsumer);
        this.pullConsumer_ = pullConsumer;
    }

    public Object get_typed_supplier() {
        if (this.typedProxyPullSupplierServant_ == null) {
            this.typedProxyPullSupplierServant_ = new TypedProxyPullSupplier();
            this.typedProxyPullSupplier_ = this.typedProxyPullSupplierServant_._this_object(this.getORB());
        }
        return this.typedProxyPullSupplier_;
    }

    public ProxyType MyType() {
        return ProxyType.PULL_TYPED;
    }

    public Servant newServant() {
        return new TypedProxyPullSupplierPOATie(this);
    }

    public void queueMessage(Message message) {
        try {
            String _fullQualifiedOperation;
            Property[] _props = message.toTypedEvent();
            if ("operation".equals(_props[0].name)) {
                _fullQualifiedOperation = _props[0].value.extract_string();
            } else if ("event_type".equals(_props[0].name)) {
                _fullQualifiedOperation = EventTypeHelper.extract((Any)_props[0].value).type_name;
            } else {
                throw new IllegalArgumentException();
            }
            int idx = _fullQualifiedOperation.lastIndexOf("::");
            String _operation = _fullQualifiedOperation.substring(idx + 2);
            Message _clonedMessage = (Message)message.clone();
            try {
                ((MessageQueueAdapter)this.messageQueueMap_.get(_operation)).enqeue(_clonedMessage);
            }
            catch (InterruptedException e) {
                _clonedMessage.dispose();
            }
        }
        catch (NoTranslationException noTranslationException) {
            // empty catch block
        }
    }

    public void deliverPendingData() {
    }

    public void disconnectClient() {
        this.pullConsumer_.disconnect_pull_consumer();
        this.pullConsumer_ = null;
    }

    protected long getCost() {
        return 0L;
    }

    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    private class TypedProxyPullSupplier
    extends DynamicImplementation {
        private final String[] supportedInterfaces_;

        private TypedProxyPullSupplier() {
            this.supportedInterfaces_ = new String[]{TypedProxyPullSupplierImpl.this.supportedInterface_};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(ServerRequest request) {
            String _operation = request.operation();
            boolean _isTryOp = false;
            if (_operation.startsWith("try_")) {
                _isTryOp = true;
                _operation = _operation.substring(4);
            }
            try {
                MessageQueueAdapter _queue = (MessageQueueAdapter)TypedProxyPullSupplierImpl.this.messageQueueMap_.get(_operation);
                Message _mesg = _isTryOp ? _queue.getMessageNoBlock() : _queue.getMessageBlocking();
                try {
                    NVList _args;
                    if (_mesg == null) {
                        _args = (NVList)TypedProxyPullSupplierImpl.this.invalidResponses_.get(_operation);
                        if (_isTryOp) {
                            request.set_result(TypedProxyPullSupplierImpl.this.falseAny_);
                        }
                    } else {
                        _args = TypedProxyPullSupplierImpl.this.prepareResponse(_mesg);
                        if (_isTryOp) {
                            request.set_result(TypedProxyPullSupplierImpl.this.trueAny_);
                        }
                    }
                    request.arguments(_args);
                }
                finally {
                    if (_mesg != null) {
                        _mesg.dispose();
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public String[] _all_interfaces(POA poa, byte[] oid) {
            return this.supportedInterfaces_;
        }

        public POA _default_POA() {
            return TypedProxyPullSupplierImpl.this.getPOA();
        }
    }
}

