/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.omg.CORBA.TIMEOUT;

public class PortRangeSocketFactory
extends AbstractSocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";
    private int portMin;
    private int portMax;

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.portMin = this.getPortProperty(config, MIN_PROP);
        this.portMax = this.getPortProperty(config, MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                Socket socket = new Socket(host, port, localHost, localPort);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("PortRangeSocketFactory: Created server socket at :" + localPort);
                }
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + host + ":" + port);
        }
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    private int getPortProperty(Configuration config, String name) throws ConfigurationException {
        int port = config.getAttributeAsInteger(name);
        if (port < 0) {
            port += 65536;
        }
        if (port <= 0 || port > 65535) {
            throw new ConfigurationException("PortRangeFactory: " + name + " invalid port number");
        }
        return port;
    }

    protected Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        InetAddress localHost = InetAddress.getLocalHost();
        boolean useTimeout = timeout != 0;
        long expireTime = useTimeout ? System.currentTimeMillis() + (long)timeout : Long.MAX_VALUE;
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            Socket socket = new Socket();
            try {
                socket.bind(new InetSocketAddress(localHost, localPort));
                socket.connect(new InetSocketAddress(host, port), timeout);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("PortRangeSocketFactory: Created socket between " + localHost.getHostAddress() + ":" + localPort + " and " + host + ":" + port);
                }
                return socket;
            }
            catch (SocketTimeoutException e) {
                this.tryToClose(socket);
                throw e;
            }
            catch (IOException ex) {
                this.tryToClose(socket);
                if (!useTimeout || System.currentTimeMillis() <= expireTime) continue;
                throw new TIMEOUT("couldn't open socket within " + timeout + ". Last exception details: " + ex.toString());
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + host + ":" + port);
        }
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    private void tryToClose(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            this.logger.warn("unable to close socket", (Throwable)e);
        }
    }
}

