/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;
import org.slf4j.Logger;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private boolean hideZoneID = true;
    private Logger logger;

    public IIOPAddress(String hoststr, int port) {
        this();
        this.source_name = hoststr;
        this.init_port(port);
    }

    private void init_port(int port) {
        this.port = port < 0 ? port + 65536 : port;
    }

    public IIOPAddress() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getLogger("jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
        this.hideZoneID = configuration.getAttribute("jacorb.ipv6.hide_zoneid", "on").equals("on");
    }

    private void init_host() {
        InetAddress localhost = null;
        boolean hasZoneId = false;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            try {
                localhost = InetAddress.getByName(null);
            }
            catch (UnknownHostException ex2) {
                // empty catch block
            }
        }
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = localhost;
        } else {
            int slash = this.source_name.indexOf(47);
            if (slash > 0) {
                this.source_name = this.source_name.substring(0, slash);
            }
            try {
                this.host = InetAddress.getByName(this.source_name);
            }
            catch (UnknownHostException ex) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn("init_host, " + this.source_name + " unresolvable");
                }
                this.unresolvable = true;
                try {
                    this.host = InetAddress.getByName(null);
                }
                catch (UnknownHostException ex2) {
                    // empty catch block
                }
            }
        }
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        return new IIOPAddress(host, port);
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.host.getHostAddress();
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.dnsEnabled ? this.host.getCanonicalHostName() : this.host.getHostAddress();
    }

    public void setHostname(String hn) {
        this.host = null;
        this.source_name = hn;
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            IIOPAddress x = (IIOPAddress)other;
            if (this.port == x.port) {
                return this.source_name.equals(x.source_name);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.source_name != null) {
            return this.source_name.hashCode() + this.port;
        }
        if (this.host != null) {
            return this.host.hashCode() + this.port;
        }
        return this.port;
    }

    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    public boolean fromString(String s) {
        if (s.charAt(0) == '[') {
            return this.fromStringIPv6(s);
        }
        return this.fromStringIPv4(s);
    }

    private boolean fromStringIPv6(String s) {
        int end_bracket = s.indexOf(93);
        if (end_bracket < 0) {
            return false;
        }
        this.source_name = s.substring(1, end_bracket);
        int port_colon = s.indexOf(58, end_bracket);
        if (port_colon < 0) {
            return false;
        }
        int _port = Integer.parseInt(s.substring(port_colon + 1));
        this.init_host();
        this.init_port(_port);
        return true;
    }

    private boolean fromStringIPv4(String s) {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return false;
        }
        this.source_name = colon > 0 ? s.substring(0, colon) : "";
        int _port = 0;
        if (colon < s.length() - 1) {
            _port = Integer.parseInt(s.substring(colon + 1));
        }
        this.init_host();
        this.init_port(_port);
        return true;
    }

    public void write(CDROutputStream cdr) {
        int zoneIndex;
        String hostname = this.getHostname();
        if (this.hideZoneID && (zoneIndex = hostname.indexOf(37)) != -1) {
            hostname = hostname.substring(0, zoneIndex);
        }
        cdr.write_string(hostname);
        cdr.write_ushort((short)this.port);
    }

    public static IIOPAddress read(CDRInputStream cdr) {
        String hostname = cdr.read_string();
        short port = cdr.read_ushort();
        return new IIOPAddress(hostname, port);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress other) {
        if (other.source_name != null) {
            this.setHostname(other.source_name);
        }
        if (other.port != -1) {
            this.setPort(other.port);
        }
    }
}

