/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.orb.policies.PolicyUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA._PolicyManagerLocalBase;
import org.slf4j.Logger;

public class PolicyManager
extends _PolicyManagerLocalBase {
    private final Map policy_overrides = new HashMap();
    private final Logger logger;

    public PolicyManager(Configuration config) {
        this.logger = config.getLogger("jacorb.orb.policies");
    }

    public synchronized Policy[] get_policy_overrides(int[] ts) {
        if (ts == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        if (ts.length == 0) {
            return this.policy_overrides.values().toArray(new Policy[0]);
        }
        ArrayList<Policy> policyList = new ArrayList<Policy>();
        for (int i = 0; i < ts.length; ++i) {
            Policy policy = (Policy)this.policy_overrides.get(ObjectUtil.newInteger(ts[i]));
            if (policy == null) continue;
            policyList.add(policy);
        }
        Policy[] result = policyList.toArray(new Policy[0]);
        if (this.logger.isDebugEnabled() && result.length > 0) {
            this.logger.debug("get_policy_overrides returns " + result.length + " policies");
        }
        return result;
    }

    public synchronized void set_policy_overrides(Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        if (policies == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        HashMap<Integer, Policy> newPolicies = new HashMap<Integer, Policy>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < policies.length; ++i) {
            if (!PolicyUtil.isInvocationPolicy(policies[i].policy_type())) {
                throw new NO_PERMISSION("Not an invocation policy, type " + policies[i].policy_type());
            }
            Integer key = ObjectUtil.newInteger(policies[i].policy_type());
            if (newPolicies.put(key, policies[i]) != null) {
                throw new BAD_PARAM("Multiple policies of type " + policies[i].policy_type(), 30, CompletionStatus.COMPLETED_NO);
            }
            sb.append(" " + policies[i].policy_type());
        }
        if (set_add == SetOverrideType.SET_OVERRIDE) {
            PolicyUtil.checkValidity(newPolicies);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SET_OVERRIDE, types: " + sb.toString());
            }
            this.policy_overrides.clear();
            this.policy_overrides.putAll(newPolicies);
        } else if (set_add == SetOverrideType.ADD_OVERRIDE) {
            HashMap<Integer, Policy> test = new HashMap<Integer, Policy>(this.policy_overrides);
            test.putAll(this.policy_overrides);
            test.putAll(newPolicies);
            PolicyUtil.checkValidity(test);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ADD_OVERRIDE, types: " + sb.toString());
            }
            this.policy_overrides.clear();
            this.policy_overrides.putAll(test);
        }
    }
}

