/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security.jaspi.modules;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.security.jaspi.modules.WebServerAuthModule;

public class HTTPClientCertServerAuthModule
extends WebServerAuthModule {
    protected Context context;
    protected boolean cache = false;
    public static final String CERTIFICATES_ATTR = "javax.servlet.request.X509Certificate";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        throw new RuntimeException("Not Applicable");
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Request request = (Request)messageInfo.getRequestMessage();
        Response response = (Response)messageInfo.getResponseMessage();
        this.context = request.getContext();
        X509Certificate[] certs = (X509Certificate[])request.getAttribute(CERTIFICATES_ATTR);
        if (certs == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute(CERTIFICATES_ATTR);
        }
        if (certs == null || certs.length < 1) {
            WebLogger.WEB_SECURITY_LOGGER.debugf("No certificates included with this request", new Object[0]);
            try {
                response.sendError(401, sm.getString("authenticator.certificates"));
            }
            catch (IOException e) {
                // empty catch block
            }
            return AuthStatus.FAILURE;
        }
        Principal principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            WebLogger.WEB_SECURITY_LOGGER.debugf("Realm.authenticate() returned false", new Object[0]);
            try {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
            }
            catch (IOException e) {
                // empty catch block
            }
            return AuthStatus.FAILURE;
        }
        this.registerWithCallbackHandler(principal, principal.getName(), null);
        return AuthStatus.SUCCESS;
    }
}

