/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.CMPFieldBridge;
import org.jboss.as.cmp.ejbql.ASTAbs;
import org.jboss.as.cmp.ejbql.ASTAbstractSchema;
import org.jboss.as.cmp.ejbql.ASTAvg;
import org.jboss.as.cmp.ejbql.ASTBooleanLiteral;
import org.jboss.as.cmp.ejbql.ASTCollectionMemberDeclaration;
import org.jboss.as.cmp.ejbql.ASTConcat;
import org.jboss.as.cmp.ejbql.ASTCount;
import org.jboss.as.cmp.ejbql.ASTEJBQL;
import org.jboss.as.cmp.ejbql.ASTEntityComparison;
import org.jboss.as.cmp.ejbql.ASTExactNumericLiteral;
import org.jboss.as.cmp.ejbql.ASTFrom;
import org.jboss.as.cmp.ejbql.ASTIdentifier;
import org.jboss.as.cmp.ejbql.ASTIsEmpty;
import org.jboss.as.cmp.ejbql.ASTLCase;
import org.jboss.as.cmp.ejbql.ASTLength;
import org.jboss.as.cmp.ejbql.ASTLimitOffset;
import org.jboss.as.cmp.ejbql.ASTLocate;
import org.jboss.as.cmp.ejbql.ASTMax;
import org.jboss.as.cmp.ejbql.ASTMemberOf;
import org.jboss.as.cmp.ejbql.ASTMin;
import org.jboss.as.cmp.ejbql.ASTMod;
import org.jboss.as.cmp.ejbql.ASTNullComparison;
import org.jboss.as.cmp.ejbql.ASTOrderBy;
import org.jboss.as.cmp.ejbql.ASTParameter;
import org.jboss.as.cmp.ejbql.ASTPath;
import org.jboss.as.cmp.ejbql.ASTRangeVariableDeclaration;
import org.jboss.as.cmp.ejbql.ASTSelect;
import org.jboss.as.cmp.ejbql.ASTSqrt;
import org.jboss.as.cmp.ejbql.ASTSubstring;
import org.jboss.as.cmp.ejbql.ASTSum;
import org.jboss.as.cmp.ejbql.ASTUCase;
import org.jboss.as.cmp.ejbql.ASTValueClassComparison;
import org.jboss.as.cmp.ejbql.ASTWhere;
import org.jboss.as.cmp.ejbql.ASTWhereConditionalTerm;
import org.jboss.as.cmp.ejbql.BasicVisitor;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.ejbql.EJBQLParser;
import org.jboss.as.cmp.ejbql.EJBQLTypes;
import org.jboss.as.cmp.ejbql.JBossQLParser;
import org.jboss.as.cmp.ejbql.Node;
import org.jboss.as.cmp.ejbql.SelectFunction;
import org.jboss.as.cmp.ejbql.SimpleNode;
import org.jboss.as.cmp.jdbc.AliasManager;
import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCTypeFactory;
import org.jboss.as.cmp.jdbc.QLCompiler;
import org.jboss.as.cmp.jdbc.QueryParameter;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;

public final class JDBCEJBQLCompiler
extends BasicVisitor
implements QLCompiler {
    private final Catalog catalog;
    private Class returnType;
    private Class[] parameterTypes;
    private JDBCReadAheadMetaData readAhead;
    private boolean lazyResultSetLoading;
    private AliasManager aliasManager;
    private Set declaredPaths = new HashSet();
    private Set ctermJoinPaths = new HashSet();
    private Set allJoinPaths = new HashSet();
    private Map ctermCollectionMemberJoinPaths = new HashMap();
    private Map allCollectionMemberJoinPaths = new HashMap();
    private Map ctermLeftJoinPaths = new HashMap();
    private Map allLeftJoinPaths = new HashMap();
    private JDBCTypeMappingMetaData typeMapping;
    private JDBCTypeFactory typeFactory;
    private boolean subquerySupported;
    private boolean forceDistinct;
    private String sql;
    private int offsetParam;
    private int offsetValue;
    private int limitParam;
    private int limitValue;
    private JDBCStoreManager selectManager;
    private Object selectObject;
    private List inputParameters = new ArrayList();
    private JDBCType functionJDBCType;
    private List leftJoinCMRList = new ArrayList();
    private StringBuffer onFindCMRJoin;
    private boolean countCompositePk;
    private String selectAlias;
    private boolean selectDistinct;

    public JDBCEJBQLCompiler(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void compileEJBQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        this.lazyResultSetLoading = metadata.isLazyResultSetLoading();
        EJBQLParser parser = new EJBQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    @Override
    public void compileJBossQL(String ejbql, Class returnType, Class[] parameterTypes, JDBCQueryMetaData metadata) throws Exception {
        this.reset();
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.readAhead = metadata.getReadAhead();
        this.lazyResultSetLoading = metadata.isLazyResultSetLoading();
        JBossQLParser parser = new JBossQLParser(new StringReader(""));
        try {
            ASTEJBQL ejbqlNode = parser.parse(this.catalog, parameterTypes, ejbql);
            this.sql = ejbqlNode.jjtAccept(this, new StringBuffer()).toString();
        }
        catch (Exception e) {
            this.reset();
            throw e;
        }
        catch (Error e) {
            this.reset();
            throw e;
        }
    }

    private void reset() {
        this.returnType = null;
        this.parameterTypes = null;
        this.readAhead = null;
        this.inputParameters.clear();
        this.declaredPaths.clear();
        this.clearPerTermJoinPaths();
        this.allJoinPaths.clear();
        this.allCollectionMemberJoinPaths.clear();
        this.allLeftJoinPaths.clear();
        this.selectObject = null;
        this.selectManager = null;
        this.typeFactory = null;
        this.typeMapping = null;
        this.aliasManager = null;
        this.subquerySupported = true;
        this.forceDistinct = false;
        this.limitParam = 0;
        this.limitValue = 0;
        this.offsetParam = 0;
        this.offsetValue = 0;
        this.leftJoinCMRList.clear();
        this.onFindCMRJoin = null;
        this.countCompositePk = false;
        this.selectAlias = null;
        this.selectDistinct = false;
        this.functionJDBCType = null;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public int getOffsetValue() {
        return this.offsetValue;
    }

    @Override
    public int getOffsetParam() {
        return this.offsetParam;
    }

    @Override
    public int getLimitValue() {
        return this.limitValue;
    }

    @Override
    public int getLimitParam() {
        return this.limitParam;
    }

    @Override
    public boolean isSelectEntity() {
        return this.selectObject instanceof JDBCEntityBridge;
    }

    @Override
    public JDBCAbstractEntityBridge getSelectEntity() {
        return (JDBCAbstractEntityBridge)this.selectObject;
    }

    @Override
    public boolean isSelectField() {
        return this.selectObject instanceof JDBCCMPFieldBridge;
    }

    @Override
    public JDBCFieldBridge getSelectField() {
        return (JDBCCMPFieldBridge)this.selectObject;
    }

    @Override
    public SelectFunction getSelectFunction() {
        return (SelectFunction)this.selectObject;
    }

    @Override
    public JDBCStoreManager getStoreManager() {
        return this.selectManager;
    }

    @Override
    public List getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public List getLeftJoinCMRList() {
        return this.leftJoinCMRList;
    }

    @Override
    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw CmpMessages.MESSAGES.unknownNodeType(node);
    }

    private void setTypeFactory(JDBCTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.typeMapping = typeFactory.getTypeMapping();
        this.aliasManager = new AliasManager(this.typeMapping.getAliasHeaderPrefix(), this.typeMapping.getAliasHeaderSuffix(), this.typeMapping.getAliasMaxLength());
        this.subquerySupported = this.typeMapping.isSubquerySupported();
    }

    private Class getParameterType(int index) {
        int zeroBasedIndex = index - 1;
        Class[] params = this.parameterTypes;
        if (zeroBasedIndex < params.length) {
            return params[zeroBasedIndex];
        }
        return null;
    }

    private void verifyParameterEntityType(int number, JDBCEntityBridge entity) {
        Class parameterType = this.getParameterType(number);
        Class<?> remoteClass = entity.getMetaData().getRemoteClass();
        Class<?> localClass = entity.getMetaData().getLocalClass();
        if (!(localClass != null && localClass.isAssignableFrom(parameterType) || remoteClass != null && remoteClass.isAssignableFrom(parameterType))) {
            throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(entity.getEntityName(), parameterType.getName());
        }
    }

    private void compareEntity(boolean not, Node fromNode, Node toNode, StringBuffer buf) {
        buf.append('(');
        if (not) {
            buf.append(" NOT ").append('(');
        }
        ASTPath fromPath = (ASTPath)fromNode;
        this.addJoinPath(fromPath);
        String fromAlias = this.aliasManager.getAlias(fromPath.getPath());
        JDBCEntityBridge fromEntity = (JDBCEntityBridge)fromPath.getEntity();
        if (toNode instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)toNode;
            this.verifyParameterEntityType(toParam.number, fromEntity);
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromEntity));
            SQLUtil.getWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, buf);
        } else {
            ASTPath toPath = (ASTPath)toNode;
            this.addJoinPath(toPath);
            String toAlias = this.aliasManager.getAlias(toPath.getPath());
            JDBCEntityBridge toEntity = (JDBCEntityBridge)toPath.getEntity();
            if (!fromEntity.equals(toEntity)) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromEntity.getEntityName(), toEntity.getEntityName());
            }
            SQLUtil.getSelfCompareWhereClause(fromEntity.getPrimaryKeyFields(), fromAlias, toAlias, buf);
        }
        if (not) {
            buf.append(')');
        }
        buf.append(')');
    }

    private void existsClause(ASTPath path, StringBuffer buf, boolean not) {
        if (!path.isCMRField()) {
            throw CmpMessages.MESSAGES.pathMustBeCmrField();
        }
        JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
        String pathStr = path.getPath(path.size() - 2);
        String parentAlias = this.aliasManager.getAlias(pathStr);
        if (!this.subquerySupported) {
            this.addLeftJoinPath(pathStr, path);
            this.forceDistinct = true;
            this.addJoinPath(path);
            if (cmrField.getRelationMetaData().isForeignKeyMappingStyle()) {
                JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
                String childAlias = this.aliasManager.getAlias(path.getPath());
                SQLUtil.getIsNullClause(!not, childEntity.getPrimaryKeyFields(), childAlias, buf);
            } else {
                String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
                SQLUtil.getIsNullClause(!not, cmrField.getTableKeyFields(), relationTableAlias, buf);
            }
            return;
        }
        if (not) {
            buf.append(" NOT ");
        }
        buf.append("EXISTS ").append('(');
        if (cmrField.getRelationMetaData().isForeignKeyMappingStyle()) {
            JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
            String childAlias = this.aliasManager.getAlias(path.getPath());
            buf.append("SELECT ");
            SQLUtil.getColumnNamesClause(childEntity.getPrimaryKeyFields(), childAlias, buf).append(" FROM ").append(childEntity.getQualifiedTableName()).append(' ').append(childAlias).append(" WHERE ");
            SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
        } else {
            String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
            buf.append("SELECT ");
            SQLUtil.getColumnNamesClause(cmrField.getTableKeyFields(), relationTableAlias, buf).append(" FROM ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" WHERE ");
            SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf);
        }
        buf.append(')');
    }

    @Override
    public Object visit(ASTEJBQL node, Object data) {
        StringBuffer buf;
        Node selectNode = node.jjtGetChild(0);
        Node fromNode = node.jjtGetChild(1);
        Node whereNode = null;
        Node orderByNode = null;
        Node limitNode = null;
        for (int childNode = 2; childNode < node.jjtGetNumChildren(); ++childNode) {
            Node temp = node.jjtGetChild(childNode);
            if (temp instanceof ASTWhere) {
                whereNode = temp;
                continue;
            }
            if (temp instanceof ASTOrderBy) {
                orderByNode = temp;
                continue;
            }
            if (!(temp instanceof ASTLimitOffset)) continue;
            limitNode = temp;
        }
        StringBuffer select = new StringBuffer();
        selectNode.jjtAccept(this, select);
        HashSet selectJoinPaths = new HashSet(this.ctermJoinPaths);
        HashMap selectCollectionMemberJoinPaths = new HashMap(this.ctermCollectionMemberJoinPaths);
        HashMap selectLeftJoinPaths = new HashMap(this.ctermLeftJoinPaths);
        StringBuffer where = new StringBuffer();
        if (whereNode != null) {
            whereNode.jjtAccept(this, where);
        }
        this.ctermJoinPaths = selectJoinPaths;
        this.ctermCollectionMemberJoinPaths = selectCollectionMemberJoinPaths;
        this.ctermLeftJoinPaths = selectLeftJoinPaths;
        StringBuffer orderBy = new StringBuffer();
        if (orderByNode != null) {
            orderByNode.jjtAccept(this, orderBy);
            for (int i = 0; i < orderByNode.jjtGetNumChildren(); ++i) {
                Node orderByPath = orderByNode.jjtGetChild(i);
                ASTPath path = (ASTPath)orderByPath.jjtGetChild(0);
                if (this.isSelected(path)) continue;
                select.append(", ");
                path.jjtAccept(this, select);
            }
        }
        if (limitNode != null) {
            limitNode.jjtAccept(this, null);
        }
        StringBuffer from = new StringBuffer(50);
        fromNode.jjtAccept(this, from);
        StringBuffer fromThetaJoin = new StringBuffer();
        this.createThetaJoin(fromThetaJoin);
        if (where.length() != 0 && fromThetaJoin.length() != 0) {
            where.insert(0, '(').append(')').append(" AND ").append(fromThetaJoin);
        } else if (fromThetaJoin.length() != 0) {
            where.append(fromThetaJoin.toString());
        }
        this.selectDistinct = this.isDistinct(selectNode);
        if (this.lazyResultSetLoading) {
            buf = new StringBuffer(200);
            if (this.isSelectEntity()) {
                JDBCFieldBridge[] pkFields = this.getSelectEntity().getPrimaryKeyFields();
                if (pkFields.length == 1) {
                    buf.append('(').append("SELECT ").append("count(");
                    if (this.selectDistinct) {
                        buf.append("DISTINCT ");
                    }
                    SQLUtil.getColumnNamesClause(pkFields, this.selectAlias, buf);
                    buf.append(')').append(" FROM ");
                    buf.append(from);
                    if (where.length() > 0) {
                        buf.append(" WHERE ").append(where);
                    }
                    buf.append("), ");
                    select.insert(0, buf);
                } else {
                    buf.append('(').append("SELECT ").append("count(*)").append(" FROM ").append('(').append("SELECT ");
                    if (this.selectDistinct) {
                        buf.append("DISTINCT ");
                    }
                    SQLUtil.getColumnNamesClause(pkFields, this.selectAlias, buf);
                    buf.append(" FROM ").append(from);
                    if (where.length() > 0) {
                        buf.append(" WHERE ").append(where);
                    }
                    buf.append(") t_count), ");
                    select.insert(0, buf);
                }
            } else if (this.isSelectField()) {
                buf.append('(').append("SELECT ").append("count(");
                if (this.selectDistinct) {
                    buf.append("DISTINCT ");
                }
                buf.append(select).append(')').append(" FROM ");
                buf.append(from);
                if (where.length() > 0) {
                    buf.append(" WHERE ").append(where);
                }
                buf.append("), ");
                select.insert(0, buf);
            }
        }
        if (this.selectDistinct) {
            select.insert(0, "DISTINCT ");
        }
        buf = (StringBuffer)data;
        if (this.selectManager.getMetaData().hasRowLocking()) {
            JDBCFunctionMappingMetaData rowLockingTemplate = this.typeMapping.getRowLockingTemplate();
            Object[] args = new Object[]{select, from, where.length() == 0 ? null : where, orderBy.length() == 0 ? null : orderBy};
            rowLockingTemplate.getFunctionSql(args, buf);
        } else {
            buf.append("SELECT ").append(select).append(" FROM ").append(from);
            if (where.length() > 0) {
                buf.append(" WHERE ").append(where);
            }
            if (orderBy.length() != 0) {
                buf.append(" ORDER BY ").append(orderBy);
            }
        }
        if (this.countCompositePk) {
            buf.insert(0, "SELECT COUNT(*) FROM (").append(") t_count");
        }
        return buf;
    }

    @Override
    public Object visit(ASTFrom node, Object data) {
        int i;
        StringBuffer buf = (StringBuffer)data;
        node.jjtGetChild(0).jjtAccept(this, buf);
        for (int i2 = 1; i2 < node.jjtGetNumChildren(); ++i2) {
            buf.append(", ");
            node.jjtGetChild(i2).jjtAccept(this, buf);
        }
        if (!this.allJoinPaths.isEmpty()) {
            for (ASTPath path : this.allJoinPaths) {
                for (i = 0; i < path.size(); ++i) {
                    this.declareTables(path, i, buf);
                }
            }
        }
        if (!this.allCollectionMemberJoinPaths.isEmpty()) {
            for (ASTPath path : this.allCollectionMemberJoinPaths.values()) {
                for (i = 0; i < path.size() - 1; ++i) {
                    this.declareTables(path, i, buf);
                }
            }
        }
        if (!this.allLeftJoinPaths.isEmpty()) {
            HashSet allLeftJoins = new HashSet();
            Iterator<Object> iter = this.allLeftJoinPaths.values().iterator();
            while (iter.hasNext()) {
                allLeftJoins.addAll((Set)iter.next());
            }
            for (ASTPath path : allLeftJoins) {
                for (int i3 = 0; i3 < path.size() - 1; ++i3) {
                    this.declareTables(path, i3, buf);
                }
            }
        }
        return buf;
    }

    private void declareTables(ASTPath path, int i, StringBuffer buf) {
        if (!path.isCMRField(i) || this.declaredPaths.contains(path.getPath(i))) {
            return;
        }
        JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField(i);
        JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity(i);
        buf.append(", ").append(entity.getQualifiedTableName()).append(' ').append(this.aliasManager.getAlias(path.getPath(i)));
        this.leftJoins(path.getPath(i), buf);
        if (cmrField.getRelationMetaData().isTableMappingStyle()) {
            String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath(i));
            buf.append(", ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias);
        }
        this.declaredPaths.add(path.getPath(i));
    }

    private void leftJoins(String parentPath, StringBuffer buf) {
        Set paths = (Set)this.ctermLeftJoinPaths.get(parentPath);
        if (this.subquerySupported || paths == null) {
            return;
        }
        for (ASTPath path : paths) {
            JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
            String parentAlias = this.aliasManager.getAlias(parentPath);
            if (cmrField.getRelationMetaData().isForeignKeyMappingStyle()) {
                JDBCEntityBridge childEntity = (JDBCEntityBridge)cmrField.getRelatedEntity();
                String childAlias = this.aliasManager.getAlias(path.getPath());
                buf.append(" LEFT JOIN ").append(childEntity.getQualifiedTableName()).append(' ').append(childAlias).append(" ON ");
                SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
                continue;
            }
            String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
            buf.append(" LEFT JOIN ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" ON ");
            SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf);
        }
    }

    private void createThetaJoin(StringBuffer buf) {
        HashSet joinedAliases = new HashSet();
        if (!this.ctermJoinPaths.isEmpty()) {
            for (ASTPath aSTPath : this.ctermJoinPaths) {
                for (int i = 0; i < aSTPath.size(); ++i) {
                    this.createThetaJoin(aSTPath, i, joinedAliases, buf);
                }
            }
        }
        if (!this.ctermCollectionMemberJoinPaths.isEmpty()) {
            for (Map.Entry entry : this.ctermCollectionMemberJoinPaths.entrySet()) {
                String childAlias = (String)entry.getKey();
                ASTPath path = (ASTPath)entry.getValue();
                this.createThetaJoin(path, path.size() - 1, joinedAliases, childAlias, buf);
                for (int i = 0; i < path.size() - 1; ++i) {
                    this.createThetaJoin(path, i, joinedAliases, buf);
                }
            }
        }
        if (!this.ctermLeftJoinPaths.isEmpty()) {
            HashSet allLeftJoins = new HashSet();
            Iterator iterator = this.ctermLeftJoinPaths.values().iterator();
            while (iterator.hasNext()) {
                allLeftJoins.addAll((Set)iterator.next());
            }
            for (ASTPath path : allLeftJoins) {
                for (int i = 0; i < path.size() - 1; ++i) {
                    this.createThetaJoin(path, i, joinedAliases, buf);
                }
            }
        }
    }

    private void createThetaJoin(ASTPath path, int i, Set joinedAliases, StringBuffer buf) {
        String childAlias = this.aliasManager.getAlias(path.getPath(i));
        this.createThetaJoin(path, i, joinedAliases, childAlias, buf);
    }

    private void createThetaJoin(ASTPath path, int i, Set joinedAliases, String childAlias, StringBuffer buf) {
        if (!path.isCMRField(i) || joinedAliases.contains(childAlias)) {
            return;
        }
        JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField(i);
        String parentAlias = this.aliasManager.getAlias(path.getPath(i - 1));
        if (joinedAliases.size() > 0) {
            buf.append(" AND ");
        }
        if (cmrField.getRelationMetaData().isForeignKeyMappingStyle()) {
            SQLUtil.getJoinClause(cmrField, parentAlias, childAlias, buf);
        } else {
            String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath(i));
            SQLUtil.getRelationTableJoinClause(cmrField, parentAlias, relationTableAlias, buf).append(" AND ");
            SQLUtil.getRelationTableJoinClause(cmrField.getRelatedCMRField(), childAlias, relationTableAlias, buf);
        }
        joinedAliases.add(childAlias);
    }

    @Override
    public Object visit(ASTCollectionMemberDeclaration node, Object data) {
        JDBCCMRFieldBridge cmrField;
        StringBuffer buf = (StringBuffer)data;
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        this.declaredPaths.add(path.getPath());
        JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity();
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        String alias = this.aliasManager.getAlias(id.identifier);
        this.addCollectionMemberJoinPath(alias, path);
        this.aliasManager.addAlias(path.getPath(), alias);
        buf.append(entity.getQualifiedTableName());
        buf.append(' ');
        buf.append(alias);
        this.leftJoins(path.getPath(), buf);
        if (this.onFindCMRJoin != null && alias.equals(this.selectAlias)) {
            buf.append(this.onFindCMRJoin);
            this.onFindCMRJoin = null;
        }
        if ((cmrField = (JDBCCMRFieldBridge)path.getCMRField()).getRelationMetaData().isTableMappingStyle()) {
            String relationTableAlias = this.aliasManager.getRelationTableAlias(path.getPath());
            buf.append(", ").append(cmrField.getQualifiedTableName()).append(' ').append(relationTableAlias);
        }
        return buf;
    }

    @Override
    public Object visit(ASTRangeVariableDeclaration node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        ASTAbstractSchema schema = (ASTAbstractSchema)node.jjtGetChild(0);
        JDBCEntityBridge entity = (JDBCEntityBridge)schema.entity;
        ASTIdentifier id = (ASTIdentifier)node.jjtGetChild(1);
        String alias = this.aliasManager.getAlias(id.identifier);
        buf.append(entity.getQualifiedTableName()).append(' ').append(alias);
        this.leftJoins(id.identifier, buf);
        if (this.onFindCMRJoin != null && alias.equals(this.selectAlias)) {
            buf.append(this.onFindCMRJoin);
            this.onFindCMRJoin = null;
        }
        return buf;
    }

    @Override
    public Object visit(ASTSelect node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Node child0 = node.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            ASTPath path = (ASTPath)child0;
            if (path.isCMPField()) {
                JDBCCMPFieldBridge selectField = (JDBCCMPFieldBridge)path.getCMPField();
                this.selectManager = (JDBCStoreManager)selectField.getManager();
                this.selectObject = selectField;
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.addJoinPath(path);
                this.selectAlias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
                SQLUtil.getColumnNamesClause(selectField, this.selectAlias, buf);
            } else {
                JDBCEntityBridge selectEntity = (JDBCEntityBridge)path.getEntity();
                this.selectManager = (JDBCStoreManager)selectEntity.getManager();
                this.selectObject = selectEntity;
                this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
                this.selectEntity(path, node.distinct, buf);
            }
        } else {
            ASTPath path = this.getPathFromChildren(child0);
            if (path == null) {
                throw CmpMessages.MESSAGES.functionInSelectNoPath();
            }
            if (path.isCMPField()) {
                JDBCCMPFieldBridge selectField = (JDBCCMPFieldBridge)path.getCMPField();
                this.selectManager = (JDBCStoreManager)selectField.getManager();
                if (selectField.getJDBCType().hasMapper()) {
                    this.functionJDBCType = selectField.getJDBCType();
                }
            } else if (path.isCMRField()) {
                JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)path.getCMRField();
                this.selectManager = (JDBCStoreManager)cmrField.getEntity().getManager();
                this.addJoinPath(path);
            } else {
                JDBCEntityBridge entity = (JDBCEntityBridge)path.getEntity();
                this.selectManager = (JDBCStoreManager)entity.getManager();
                this.addJoinPath(path);
            }
            this.setTypeFactory(this.selectManager.getJDBCTypeFactory());
            this.selectObject = child0;
            child0.jjtAccept(this, buf);
        }
        return buf;
    }

    @Override
    public Object visit(ASTWhere node, Object data) {
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTNullComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Node child0 = node.jjtGetChild(0);
        if (child0 instanceof ASTPath) {
            JDBCCMRFieldBridge cmrField;
            ASTPath path = (ASTPath)child0;
            if (path.isCMRField() && (cmrField = (JDBCCMRFieldBridge)path.getCMRField()).getRelationMetaData().isTableMappingStyle()) {
                this.existsClause(path, buf, !node.not);
                return buf;
            }
            String alias = this.aliasManager.getAlias(path.getPath(path.size() - 2));
            JDBCFieldBridge field = (JDBCFieldBridge)path.getField();
            if (field.getJDBCType() == null) {
                this.existsClause(path, buf, !node.not);
                return buf;
            }
            if (path.fieldList.size() > 2) {
                for (int i = 0; i < path.fieldList.size(); ++i) {
                    Object pathEl = path.fieldList.get(i);
                    if (!(pathEl instanceof JDBCCMRFieldBridge)) continue;
                    this.addJoinPath(path);
                    break;
                }
            }
            buf = SQLUtil.getIsNullClause(node.not, field, alias, buf);
        } else if (child0 instanceof ASTParameter) {
            ASTParameter param = (ASTParameter)child0;
            Class type = this.getParameterType(param.number);
            QueryParameter queryParam = new QueryParameter(param.number - 1, this.typeFactory.getJDBCType(type));
            this.inputParameters.add(queryParam);
            buf.append("? IS ");
            if (node.not) {
                buf.append(" NOT ");
            }
            buf.append("NULL");
        } else {
            throw CmpMessages.MESSAGES.unexpectedNodeInNull(node);
        }
        return buf;
    }

    @Override
    public Object visit(ASTIsEmpty node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        ASTPath path = (ASTPath)node.jjtGetChild(0);
        this.existsClause(path, buf, !node.not);
        return buf;
    }

    @Override
    public Object visit(ASTMemberOf node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        ASTPath toPath = (ASTPath)node.jjtGetChild(1);
        JDBCCMRFieldBridge toCMRField = (JDBCCMRFieldBridge)toPath.getCMRField();
        JDBCEntityBridge toChildEntity = (JDBCEntityBridge)toPath.getEntity();
        String pathStr = toPath.getPath(toPath.size() - 2);
        String toParentAlias = this.aliasManager.getAlias(pathStr);
        String toChildAlias = this.aliasManager.getAlias(toPath.getPath());
        String relationTableAlias = null;
        if (toCMRField.getRelationMetaData().isTableMappingStyle()) {
            relationTableAlias = this.aliasManager.getRelationTableAlias(toPath.getPath());
        }
        String fromAlias = null;
        int fromParamNumber = -1;
        if (node.jjtGetChild(0) instanceof ASTParameter) {
            ASTParameter fromParam = (ASTParameter)node.jjtGetChild(0);
            this.verifyParameterEntityType(fromParam.number, toChildEntity);
            fromParamNumber = fromParam.number;
        } else {
            ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
            this.addJoinPath(fromPath);
            JDBCEntityBridge fromEntity = (JDBCEntityBridge)fromPath.getEntity();
            fromAlias = this.aliasManager.getAlias(fromPath.getPath());
            if (!fromEntity.equals(toChildEntity)) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromEntity.getEntityName(), toChildEntity.getEntityName());
            }
        }
        this.addLeftJoinPath(pathStr, toPath);
        if (!this.subquerySupported) {
            this.addJoinPath(toPath);
            if (node.not) {
                buf.append(" NOT ");
            }
            buf.append('(');
            if (relationTableAlias == null) {
                SQLUtil.getIsNullClause(true, toChildEntity.getPrimaryKeyFields(), toChildAlias, buf);
            } else {
                SQLUtil.getIsNullClause(true, toCMRField.getTableKeyFields(), relationTableAlias, buf);
            }
        } else {
            if (node.not) {
                buf.append(" NOT ");
            }
            buf.append("EXISTS ").append('(');
            if (relationTableAlias == null) {
                buf.append("SELECT ");
                SQLUtil.getColumnNamesClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, buf).append(" FROM ").append(toChildEntity.getQualifiedTableName()).append(' ').append(toChildAlias).append(" WHERE ");
                SQLUtil.getJoinClause(toCMRField, toParentAlias, toChildAlias, buf);
            } else {
                buf.append("SELECT ");
                SQLUtil.getColumnNamesClause(toCMRField.getRelatedCMRField().getTableKeyFields(), relationTableAlias, buf).append(" FROM ").append(toCMRField.getQualifiedTableName()).append(' ').append(relationTableAlias).append(" WHERE ");
                SQLUtil.getRelationTableJoinClause(toCMRField, toParentAlias, relationTableAlias, buf);
            }
        }
        buf.append(" AND ");
        if (fromAlias != null) {
            if (relationTableAlias == null) {
                SQLUtil.getSelfCompareWhereClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, fromAlias, buf);
            } else {
                SQLUtil.getRelationTableJoinClause(toCMRField.getRelatedCMRField(), fromAlias, relationTableAlias, buf);
            }
        } else {
            this.inputParameters.addAll(QueryParameter.createParameters(fromParamNumber - 1, toChildEntity));
            if (relationTableAlias == null) {
                SQLUtil.getWhereClause(toChildEntity.getPrimaryKeyFields(), toChildAlias, buf);
            } else {
                SQLUtil.getWhereClause(toCMRField.getRelatedCMRField().getTableKeyFields(), relationTableAlias, buf);
            }
        }
        buf.append(')');
        return buf;
    }

    @Override
    public Object visit(ASTValueClassComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        boolean not = node.opp.equals("<>");
        String comparison = node.opp;
        buf.append('(');
        if (not) {
            buf.append(" NOT ").append('(');
            comparison = "=";
        }
        ASTPath fromPath = (ASTPath)node.jjtGetChild(0);
        this.addJoinPath(fromPath);
        String fromAlias = this.aliasManager.getAlias(fromPath.getPath(fromPath.size() - 2));
        JDBCCMPFieldBridge fromCMPField = (JDBCCMPFieldBridge)fromPath.getCMPField();
        Node toNode = node.jjtGetChild(1);
        if (toNode instanceof ASTParameter) {
            ASTParameter toParam = (ASTParameter)toNode;
            Class parameterType = this.getParameterType(toParam.number);
            if (!fromCMPField.getFieldType().equals(parameterType)) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromCMPField.getFieldType().getName(), parameterType.getName());
            }
            this.inputParameters.addAll(QueryParameter.createParameters(toParam.number - 1, fromCMPField));
            SQLUtil.getWhereClause(fromCMPField.getJDBCType(), fromAlias, comparison, buf);
        } else {
            ASTPath toPath = (ASTPath)toNode;
            this.addJoinPath(toPath);
            String toAlias = this.aliasManager.getAlias(toPath.getPath(toPath.size() - 2));
            JDBCCMPFieldBridge toCMPField = (JDBCCMPFieldBridge)toPath.getCMPField();
            if (!fromCMPField.getFieldType().equals(toCMPField.getFieldType())) {
                throw CmpMessages.MESSAGES.onlyLikeTypesCanBeCompared(fromCMPField.getFieldType().getName(), toCMPField.getFieldType().getName());
            }
            SQLUtil.getSelfCompareWhereClause(fromCMPField, toCMPField, fromAlias, toAlias, comparison, buf);
        }
        return (not ? buf.append(')') : buf).append(')');
    }

    @Override
    public Object visit(ASTEntityComparison node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Node arg0 = node.jjtGetChild(0);
        Node arg1 = node.jjtGetChild(1);
        if (node.opp.equals("<>")) {
            this.compareEntity(true, arg0, arg1, buf);
        } else {
            this.compareEntity(false, arg0, arg1, buf);
        }
        return buf;
    }

    @Override
    public Object visit(ASTConcat node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("concat");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTSubstring node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("substring");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1)), new NodeStringWrapper(node.jjtGetChild(2))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTLCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("lcase");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTUCase node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("ucase");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTLength node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("length");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTLocate node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("locate");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1)), node.jjtGetNumChildren() == 3 ? new NodeStringWrapper(node.jjtGetChild(2)) : "1"};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTAbs node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("abs");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTMod node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("mod");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0)), new NodeStringWrapper(node.jjtGetChild(1))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTSqrt node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        JDBCFunctionMappingMetaData function = this.typeMapping.getFunctionMapping("sqrt");
        Object[] args = new Object[]{new NodeStringWrapper(node.jjtGetChild(0))};
        function.getFunctionSql(args, buf);
        return buf;
    }

    @Override
    public Object visit(ASTCount node, Object data) {
        Object[] args;
        StringBuffer buf = (StringBuffer)data;
        node.setResultType(this.returnType);
        ASTPath cntPath = (ASTPath)node.jjtGetChild(0);
        if (cntPath.isCMPField()) {
            args = new Object[]{node.distinct, new NodeStringWrapper(cntPath)};
        } else {
            JDBCEntityBridge entity = (JDBCEntityBridge)cntPath.getEntity();
            JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
            if (pkFields.length > 1) {
                this.countCompositePk = true;
                this.forceDistinct = node.distinct.length() > 0;
                this.selectEntity(cntPath, this.forceDistinct, buf);
                return buf;
            }
            String alias = this.aliasManager.getAlias(cntPath.getPath());
            StringBuffer keyColumn = new StringBuffer(20);
            SQLUtil.getColumnNamesClause(pkFields[0], alias, keyColumn);
            args = new Object[]{node.distinct, keyColumn.toString()};
        }
        return JDBCTypeMappingMetaData.COUNT_FUNC.getFunctionSql(args, buf);
    }

    @Override
    public Object visit(ASTMax node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, new NodeStringWrapper(node.jjtGetChild(0))};
        return JDBCTypeMappingMetaData.MAX_FUNC.getFunctionSql(args, buf);
    }

    @Override
    public Object visit(ASTMin node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, new NodeStringWrapper(node.jjtGetChild(0))};
        return JDBCTypeMappingMetaData.MIN_FUNC.getFunctionSql(args, buf);
    }

    @Override
    public Object visit(ASTAvg node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, new NodeStringWrapper(node.jjtGetChild(0))};
        return JDBCTypeMappingMetaData.AVG_FUNC.getFunctionSql(args, buf);
    }

    @Override
    public Object visit(ASTSum node, Object data) {
        if (this.functionJDBCType != null) {
            node.setResultType(this.functionJDBCType.getJavaTypes()[0]);
            node.setJDBCType(this.functionJDBCType);
        } else {
            node.setResultType(this.returnType);
        }
        StringBuffer buf = (StringBuffer)data;
        Object[] args = new Object[]{node.distinct, new NodeStringWrapper(node.jjtGetChild(0))};
        return JDBCTypeMappingMetaData.SUM_FUNC.getFunctionSql(args, buf);
    }

    @Override
    public Object visit(ASTPath node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (!node.isCMPField()) {
            throw CmpMessages.MESSAGES.canOnlyVisitCmpNodes();
        }
        JDBCCMPFieldBridge cmpField = (JDBCCMPFieldBridge)node.getCMPField();
        switch (node.type) {
            case 5: 
            case 6: {
                if (cmpField.getJDBCType().hasMapper() || cmpField.getJDBCType().getParameterSetter() != null) break;
            }
            case -1: {
                throw CmpMessages.MESSAGES.canNotVisitMultiColumnPath();
            }
        }
        this.addJoinPath(node);
        String alias = this.aliasManager.getAlias(node.getPath(node.size() - 2));
        SQLUtil.getColumnNamesClause(cmpField, alias, buf);
        return buf;
    }

    @Override
    public Object visit(ASTAbstractSchema node, Object data) {
        throw CmpMessages.MESSAGES.canNotVisitAbstractNode();
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        Class type = this.getParameterType(node.number);
        int ejbqlType = EJBQLTypes.getEJBQLType(type);
        if (ejbqlType == 5 || ejbqlType == 6 || ejbqlType == -1) {
            throw CmpMessages.MESSAGES.canNotVisitMultiColumnParameter();
        }
        QueryParameter param = new QueryParameter(node.number - 1, this.typeFactory.getJDBCType(type));
        this.inputParameters.add(param);
        buf.append('?');
        return buf;
    }

    @Override
    public Object visit(ASTBooleanLiteral node, Object data) {
        StringBuffer buf = (StringBuffer)data;
        if (node.value) {
            buf.append(this.typeMapping.getTrueMapping());
        } else {
            buf.append(this.typeMapping.getFalseMapping());
        }
        return data;
    }

    @Override
    public Object visit(ASTLimitOffset node, Object data) {
        Class parameterType;
        SimpleNode param;
        int child = 0;
        if (node.hasOffset) {
            Node offsetNode;
            if ((offsetNode = node.jjtGetChild(child++)) instanceof ASTParameter) {
                param = (ASTParameter)offsetNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw CmpMessages.MESSAGES.offsetParameterMustBeInt();
                }
                this.offsetParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)offsetNode;
                this.offsetValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        if (node.hasLimit) {
            Node limitNode = node.jjtGetChild(child);
            if (limitNode instanceof ASTParameter) {
                param = (ASTParameter)limitNode;
                parameterType = this.getParameterType(param.number);
                if (Integer.TYPE != parameterType && Integer.class != parameterType) {
                    throw CmpMessages.MESSAGES.limitParameterMustBeInt();
                }
                this.limitParam = param.number;
            } else {
                param = (ASTExactNumericLiteral)limitNode;
                this.limitValue = (int)((ASTExactNumericLiteral)param).value;
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTWhereConditionalTerm node, Object data) {
        this.clearPerTermJoinPaths();
        StringBuffer buf = (StringBuffer)data;
        buf.append('(');
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        StringBuffer thetaJoin = new StringBuffer();
        this.createThetaJoin(thetaJoin);
        if (thetaJoin.length() > 0) {
            buf.append(" AND ").append(thetaJoin.toString());
        }
        buf.append(')');
        return data;
    }

    private ASTPath getPathFromChildren(Node selectFunction) {
        for (int childInd = 0; childInd < selectFunction.jjtGetNumChildren(); ++childInd) {
            ASTPath path;
            Node child = selectFunction.jjtGetChild(childInd);
            if (child instanceof ASTPath) {
                return (ASTPath)child;
            }
            if (!(child instanceof SelectFunction) || (path = this.getPathFromChildren(child)) == null) continue;
            return path;
        }
        return null;
    }

    private boolean isSelected(ASTPath path) {
        Node funcNode;
        ASTPath fieldPath;
        boolean selected = false;
        CMPFieldBridge cmpField = path.getCMPField();
        if (this.selectObject instanceof JDBCCMPFieldBridge && cmpField == this.selectObject) {
            selected = true;
        } else if (this.selectObject instanceof JDBCEntityBridge) {
            JDBCEntityBridge entity = (JDBCEntityBridge)this.selectObject;
            JDBCFieldBridge[] pkFields = entity.getPrimaryKeyFields();
            for (int pkInd = 0; pkInd < pkFields.length; ++pkInd) {
                if (pkFields[pkInd] != cmpField) continue;
                selected = true;
                break;
            }
        } else if (this.selectObject instanceof SelectFunction && (fieldPath = this.getPathFromChildren(funcNode = (Node)this.selectObject)).getCMPField() == cmpField) {
            selected = true;
        }
        return selected;
    }

    private void selectEntity(ASTPath path, boolean distinct, StringBuffer buf) {
        JDBCEntityBridge selectEntity = (JDBCEntityBridge)path.getEntity();
        StringBuffer columnNamesClause = new StringBuffer(200);
        this.addJoinPath(path);
        this.selectAlias = this.aliasManager.getAlias(path.getPath());
        SQLUtil.getColumnNamesClause(selectEntity.getPrimaryKeyFields(), this.selectAlias, columnNamesClause);
        if (this.readAhead.isOnFind()) {
            String eagerLoadGroupName = this.readAhead.getEagerLoadGroup();
            boolean[] loadGroupMask = selectEntity.getLoadGroupMask(eagerLoadGroupName);
            if (distinct) {
                SQLUtil.appendSearchableColumnNamesClause(selectEntity.getTableFields(), loadGroupMask, this.selectAlias, columnNamesClause);
            } else {
                SQLUtil.appendColumnNamesClause(selectEntity.getTableFields(), loadGroupMask, this.selectAlias, columnNamesClause);
            }
            try {
                this.leftJoinCMRList = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(selectEntity, path.getPath(), this.readAhead.getLeftJoins(), this.declaredPaths);
            }
            catch (Exception e) {
                throw CmpMessages.MESSAGES.failedToGetLeftJoinNodes(e);
            }
            if (!this.leftJoinCMRList.isEmpty()) {
                this.onFindCMRJoin = new StringBuffer(100);
                JDBCAbstractQueryCommand.leftJoinCMRNodes(this.selectAlias, this.leftJoinCMRList, this.aliasManager, this.onFindCMRJoin);
                JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(this.leftJoinCMRList, this.aliasManager, columnNamesClause);
            }
        }
        buf.append(columnNamesClause);
    }

    private void addJoinPath(ASTPath path) {
        this.ctermJoinPaths.add(path);
        this.allJoinPaths.add(path);
    }

    private void addCollectionMemberJoinPath(String alias, ASTPath path) {
        this.ctermCollectionMemberJoinPaths.put(alias, path);
        this.allCollectionMemberJoinPaths.put(alias, path);
    }

    private void addLeftJoinPath(String pathStr, ASTPath path) {
        Set<ASTPath> set = (HashSet<ASTPath>)this.ctermLeftJoinPaths.get(pathStr);
        if (set == null) {
            set = new HashSet<ASTPath>();
            this.ctermLeftJoinPaths.put(pathStr, set);
        }
        set.add(path);
        set = (Set)this.allLeftJoinPaths.get(pathStr);
        if (set == null) {
            set = new HashSet();
            this.allLeftJoinPaths.put(pathStr, set);
        }
        set.add(path);
    }

    private void clearPerTermJoinPaths() {
        this.ctermJoinPaths.clear();
        this.ctermCollectionMemberJoinPaths.clear();
        this.ctermLeftJoinPaths.clear();
    }

    private boolean isDistinct(Node selectNode) {
        return ((ASTSelect)selectNode).distinct || this.returnType.equals(Set.class) || this.forceDistinct;
    }

    private final class NodeStringWrapper {
        final Node node;

        public NodeStringWrapper(Node node) {
            this.node = node;
        }

        public String toString() {
            return this.node.jjtAccept(JDBCEJBQLCompiler.this, new StringBuffer()).toString();
        }
    }
}

