/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.ReadAheadCache;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.logging.Logger;

public final class JDBCLoadRelationCommand {
    private final JDBCStoreManager manager;
    private final JDBCEntityBridge entity;
    private final Logger log;

    public JDBCLoadRelationCommand(JDBCStoreManager manager) {
        this.manager = manager;
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection execute(JDBCCMRFieldBridge cmrField, Object pk) {
        List list;
        JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
        ReadAheadCache readAheadCache = this.manager.getReadAheadCache();
        ReadAheadCache relatedReadAheadCache = cmrField.getRelatedManager().getReadAheadCache();
        ReadAheadCache.EntityReadAheadInfo info = readAheadCache.getEntityReadAheadInfo(pk);
        List loadKeys = info.getLoadKeys();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List results;
            boolean[] preloadMask = JDBCLoadRelationCommand.getPreloadMask(cmrField);
            String sql = this.getSQL(cmrField, preloadMask, loadKeys.size());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("load relation SQL: " + sql));
            }
            con = cmrField.getDataSource().getConnection();
            ps = con.prepareStatement(sql.toString());
            if (this.entity.getFetchSize() > 0) {
                ps.setFetchSize(this.entity.getFetchSize());
            }
            JDBCCMPFieldBridge[] myKeyFields = this.getMyKeyFields(cmrField);
            JDBCCMPFieldBridge[] relatedKeyFields = JDBCLoadRelationCommand.getRelatedKeyFields(cmrField);
            int paramIndex = 1;
            for (int i = 0; i < loadKeys.size(); ++i) {
                Object key = loadKeys.get(i);
                for (int j = 0; j < myKeyFields.length; ++j) {
                    paramIndex = myKeyFields[j].setPrimaryKeyParameters(ps, paramIndex, key);
                }
            }
            rs = ps.executeQuery();
            HashMap resultsMap = new HashMap(loadKeys.size());
            for (int i = 0; i < loadKeys.size(); ++i) {
                resultsMap.put(loadKeys.get(i), new ArrayList());
            }
            Object[] ref = new Object[1];
            while (rs.next()) {
                Object loadedFk;
                int i;
                int index = 1;
                ref[0] = null;
                Object loadedPk = pk;
                if (loadKeys.size() > 1) {
                    for (i = 0; i < myKeyFields.length; ++i) {
                        index = myKeyFields[i].loadPrimaryKeyResults(rs, index, ref);
                        if (ref[0] == null) break;
                    }
                    loadedPk = ref[0];
                }
                ref[0] = null;
                for (i = 0; i < relatedKeyFields.length; ++i) {
                    index = relatedKeyFields[i].loadPrimaryKeyResults(rs, index, ref);
                    if (ref[0] == null) break;
                }
                if ((loadedFk = ref[0]) == null) continue;
                results = (List)resultsMap.get(loadedPk);
                results.add(loadedFk);
                if (relatedCMRField.isSingleValued()) {
                    relatedReadAheadCache.addPreloadData(loadedFk, relatedCMRField, Collections.singletonList(loadedPk));
                }
                if (preloadMask == null) continue;
                JDBCFieldBridge[] relatedFields = cmrField.getRelatedJDBCEntity().getTableFields();
                for (int i2 = 0; i2 < relatedFields.length; ++i2) {
                    if (!preloadMask[i2]) continue;
                    JDBCFieldBridge field = relatedFields[i2];
                    ref[0] = null;
                    index = field.loadArgumentResults(rs, index, ref);
                    relatedReadAheadCache.addPreloadData(loadedFk, field, ref[0]);
                }
            }
            JDBCReadAheadMetaData readAhead = relatedCMRField.getReadAhead();
            for (Object key : resultsMap.keySet()) {
                results = (List)resultsMap.get(key);
                relatedReadAheadCache.addFinderResults(results, readAhead);
                if (key.equals(pk)) continue;
                readAheadCache.addPreloadData(key, cmrField, results);
            }
            list = (List)resultsMap.get(pk);
        }
        catch (EJBException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.loadRelationFailed(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        return list;
    }

    private String getSQL(JDBCCMRFieldBridge cmrField, boolean[] preloadMask, int keyCount) {
        String relatedTableAlias;
        String relationTableAlias;
        boolean join;
        JDBCCMPFieldBridge[] myKeyFields = this.getMyKeyFields(cmrField);
        JDBCCMPFieldBridge[] relatedKeyFields = JDBCLoadRelationCommand.getRelatedKeyFields(cmrField);
        String relationTable = this.getQualifiedRelationTable(cmrField);
        JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
        String relatedTable = relatedEntity.getQualifiedTableName();
        boolean bl = join = (preloadMask != null || cmrField.allFkFieldsMappedToPkFields()) && relatedKeyFields != relatedEntity.getPrimaryKeyFields();
        if (join) {
            relationTableAlias = this.getRelationTable(cmrField);
            relatedTableAlias = relatedTable.equals(relationTable) ? this.getRelationTable(cmrField) + '_' + cmrField.getFieldName() : relatedEntity.getTableName();
        } else {
            relationTableAlias = "";
            relatedTableAlias = "";
        }
        JDBCFunctionMappingMetaData selectTemplate = this.getSelectTemplate(cmrField);
        return selectTemplate == null ? JDBCLoadRelationCommand.getPlainSQL(keyCount, myKeyFields, relationTableAlias, relatedKeyFields, preloadMask, cmrField, relatedTableAlias, relationTable, join, relatedTable) : JDBCLoadRelationCommand.getSQLByTemplate(keyCount, myKeyFields, relationTableAlias, relatedKeyFields, preloadMask, cmrField, relatedTableAlias, relationTable, join, relatedTable, selectTemplate);
    }

    private JDBCCMPFieldBridge[] getMyKeyFields(JDBCCMRFieldBridge cmrField) {
        if (cmrField.getRelationMetaData().isTableMappingStyle()) {
            return (JDBCCMPFieldBridge[])cmrField.getTableKeyFields();
        }
        if (cmrField.getRelatedCMRField().hasForeignKey()) {
            return (JDBCCMPFieldBridge[])cmrField.getRelatedCMRField().getForeignKeyFields();
        }
        return (JDBCCMPFieldBridge[])this.entity.getPrimaryKeyFields();
    }

    private static JDBCCMPFieldBridge[] getRelatedKeyFields(JDBCCMRFieldBridge cmrField) {
        if (cmrField.getRelationMetaData().isTableMappingStyle()) {
            return (JDBCCMPFieldBridge[])cmrField.getRelatedCMRField().getTableKeyFields();
        }
        if (cmrField.getRelatedCMRField().hasForeignKey()) {
            return (JDBCCMPFieldBridge[])cmrField.getRelatedJDBCEntity().getPrimaryKeyFields();
        }
        return (JDBCCMPFieldBridge[])cmrField.getForeignKeyFields();
    }

    private static boolean[] getPreloadMask(JDBCCMRFieldBridge cmrField) {
        boolean[] preloadMask = null;
        if (cmrField.getReadAhead().isOnFind()) {
            JDBCEntityBridge relatedEntity = cmrField.getRelatedJDBCEntity();
            String eagerLoadGroup = cmrField.getReadAhead().getEagerLoadGroup();
            preloadMask = relatedEntity.getLoadGroupMask(eagerLoadGroup);
        }
        return preloadMask;
    }

    private String getQualifiedRelationTable(JDBCCMRFieldBridge cmrField) {
        if (cmrField.getRelationMetaData().isTableMappingStyle()) {
            return cmrField.getQualifiedTableName();
        }
        if (cmrField.getRelatedCMRField().hasForeignKey()) {
            return cmrField.getRelatedJDBCEntity().getQualifiedTableName();
        }
        return this.entity.getQualifiedTableName();
    }

    private String getRelationTable(JDBCCMRFieldBridge cmrField) {
        if (cmrField.getRelationMetaData().isTableMappingStyle()) {
            return cmrField.getTableName();
        }
        if (cmrField.getRelatedCMRField().hasForeignKey()) {
            return cmrField.getRelatedJDBCEntity().getTableName();
        }
        return this.entity.getTableName();
    }

    private JDBCFunctionMappingMetaData getSelectTemplate(JDBCCMRFieldBridge cmrField) {
        JDBCFunctionMappingMetaData selectTemplate = null;
        if (cmrField.getRelationMetaData().isTableMappingStyle() ? cmrField.getRelationMetaData().hasRowLocking() && (selectTemplate = cmrField.getRelationMetaData().getTypeMapping().getRowLockingTemplate()) == null : (cmrField.getRelatedCMRField().hasForeignKey() ? cmrField.getRelatedJDBCEntity().getMetaData().hasRowLocking() && (selectTemplate = cmrField.getRelatedJDBCEntity().getMetaData().getTypeMapping().getRowLockingTemplate()) == null : this.entity.getMetaData().hasRowLocking() && (selectTemplate = this.entity.getMetaData().getTypeMapping().getRowLockingTemplate()) == null)) {
            throw CmpMessages.MESSAGES.rowLockingNotAllowed();
        }
        return selectTemplate;
    }

    private static String getPlainSQL(int keyCount, JDBCCMPFieldBridge[] myKeyFields, String relationTableAlias, JDBCCMPFieldBridge[] relatedKeyFields, boolean[] preloadMask, JDBCCMRFieldBridge cmrField, String relatedTableAlias, String relationTable, boolean join, String relatedTable) {
        StringBuffer sql = new StringBuffer(400);
        sql.append("SELECT ");
        if (keyCount > 1) {
            SQLUtil.getColumnNamesClause(myKeyFields, relationTableAlias, sql).append(", ");
        }
        SQLUtil.getColumnNamesClause(relatedKeyFields, relationTableAlias, sql);
        if (preloadMask != null) {
            SQLUtil.appendColumnNamesClause(cmrField.getRelatedJDBCEntity().getTableFields(), preloadMask, relatedTableAlias, sql);
        }
        sql.append(" FROM ").append(relationTable);
        if (join) {
            sql.append(' ').append(relationTableAlias).append(", ").append(relatedTable).append(' ').append(relatedTableAlias);
        }
        sql.append(" WHERE ");
        if (join) {
            sql.append('(');
            SQLUtil.getJoinClause(relatedKeyFields, relationTableAlias, cmrField.getRelatedJDBCEntity().getPrimaryKeyFields(), relatedTableAlias, sql).append(')').append(" AND ").append('(');
        }
        String pkWhere = SQLUtil.getWhereClause((JDBCFieldBridge[])myKeyFields, relationTableAlias, new StringBuffer(50)).toString();
        for (int i = 0; i < keyCount; ++i) {
            if (i > 0) {
                sql.append(" OR ");
            }
            sql.append('(').append(pkWhere).append(')');
        }
        if (join) {
            sql.append(')');
        }
        return sql.toString();
    }

    private static String getSQLByTemplate(int keyCount, JDBCCMPFieldBridge[] myKeyFields, String relationTableAlias, JDBCCMPFieldBridge[] relatedKeyFields, boolean[] preloadMask, JDBCCMRFieldBridge cmrField, String relatedTableAlias, String relationTable, boolean join, String relatedTable, JDBCFunctionMappingMetaData selectTemplate) {
        StringBuffer columnNamesClause = new StringBuffer(100);
        if (keyCount > 1) {
            SQLUtil.getColumnNamesClause(myKeyFields, relationTableAlias, columnNamesClause).append(", ");
        }
        SQLUtil.getColumnNamesClause(relatedKeyFields, relationTableAlias, columnNamesClause);
        if (preloadMask != null) {
            SQLUtil.appendColumnNamesClause(cmrField.getRelatedJDBCEntity().getTableFields(), preloadMask, relatedTableAlias, columnNamesClause);
        }
        StringBuffer fromClause = new StringBuffer(100);
        fromClause.append(relationTable);
        if (join) {
            fromClause.append(' ').append(relationTableAlias).append(", ").append(relatedTable).append(' ').append(relatedTableAlias);
        }
        StringBuffer whereClause = new StringBuffer(150);
        if (join) {
            whereClause.append('(');
            SQLUtil.getJoinClause(relatedKeyFields, relationTableAlias, cmrField.getRelatedJDBCEntity().getPrimaryKeyFields(), relatedTableAlias, whereClause).append(')').append(" AND ").append('(');
        }
        String pkWhere = SQLUtil.getWhereClause((JDBCFieldBridge[])myKeyFields, relationTableAlias, new StringBuffer(50)).toString();
        for (int i = 0; i < keyCount; ++i) {
            if (i > 0) {
                whereClause.append(" OR ");
            }
            whereClause.append('(').append(pkWhere).append(')');
        }
        if (join) {
            whereClause.append(')');
        }
        Object[] args = new String[]{columnNamesClause.toString(), fromClause.toString(), whereClause.toString(), null};
        return selectTemplate.getFunctionSql(args, new StringBuffer(500)).toString();
    }
}

