/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2.bridge;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.CMPFieldBridge;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.PersistentContext;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public class JDBCCMPFieldBridge2
implements CMPFieldBridge {
    private final JDBCEntityBridge2 entity;
    private final int rowIndex;
    private final JDBCType jdbcType;
    private final Class pkClass;
    private final Field pkField;
    private final boolean isPrimaryKeyMember;
    private final String fieldName;
    private final Class fieldType;
    private final String columnName;
    private final JDBCCMPFieldBridge2 cmpFieldIAmMappedTo;
    private final Logger log;
    private int versionIndex = -1;

    public JDBCCMPFieldBridge2(JDBCStoreManager2 manager, JDBCEntityBridge2 entity, JDBCCMPFieldMetaData metadata, int rowIndex) {
        this.rowIndex = rowIndex;
        this.entity = entity;
        this.jdbcType = manager.getJDBCTypeFactory().getJDBCType(metadata);
        this.pkClass = metadata.getEntity().getPrimaryKeyClass();
        this.pkField = metadata.getPrimaryKeyField();
        this.isPrimaryKeyMember = metadata.isPrimaryKeyMember();
        this.fieldName = metadata.getFieldName();
        this.fieldType = metadata.getFieldType();
        this.cmpFieldIAmMappedTo = null;
        this.columnName = metadata.getColumnName();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + entity.getEntityName() + "#" + this.getFieldName()));
    }

    public JDBCCMPFieldBridge2(JDBCCMPFieldBridge2 cmpField, JDBCCMPFieldBridge2 relatedPKField) {
        this.entity = cmpField.entity;
        this.rowIndex = cmpField.rowIndex;
        this.jdbcType = cmpField.jdbcType;
        this.columnName = cmpField.columnName;
        this.fieldName = relatedPKField.fieldName;
        this.fieldType = relatedPKField.fieldType;
        this.pkClass = relatedPKField.pkClass;
        this.pkField = relatedPKField.pkField;
        this.isPrimaryKeyMember = false;
        this.cmpFieldIAmMappedTo = cmpField;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.entity.getEntityName() + "#" + this.getFieldName()));
    }

    public void initVersion() {
        this.versionIndex = this.entity.getTable().addVersionField();
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object setPrimaryKeyValue(Object primaryKey, Object value) throws IllegalArgumentException {
        try {
            if (this.pkField != null) {
                if (value == null && primaryKey == null) {
                    return null;
                }
                if (primaryKey == null) {
                    primaryKey = this.pkClass.newInstance();
                }
                this.pkField.set(primaryKey, value);
                return primaryKey;
            }
            return value;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorSettingInstanceField(this.fieldName, e);
        }
    }

    public void setValueInternal(CmpEntityBeanContext ctx, Object value, boolean makeDirty) {
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        if (this.cmpFieldIAmMappedTo != null && this.cmpFieldIAmMappedTo.isPrimaryKeyMember) {
            Object curValue = pctx.getFieldValue(this.rowIndex);
            if (value != null && !value.equals(curValue)) {
                throw CmpMessages.MESSAGES.attemptToModifyPkThroughFk(this.entity.getEntityName(), this.cmpFieldIAmMappedTo.getFieldName(), this.entity.getQualifiedTableName(), this.cmpFieldIAmMappedTo.getColumnName(), curValue, value);
            }
            makeDirty = false;
        } else {
            pctx.setFieldValue(this.rowIndex, value);
        }
        if (makeDirty) {
            pctx.setDirty();
        }
    }

    public int setArgumentParameters(PreparedStatement ps, int parameterIndex, Object arg) {
        try {
            int[] jdbcTypes = this.jdbcType.getJDBCTypes();
            for (int i = 0; i < jdbcTypes.length; ++i) {
                Object columnValue = this.jdbcType.getColumnValue(i, arg);
                this.jdbcType.getParameterSetter()[i].set(ps, parameterIndex++, jdbcTypes[i], columnValue, this.log);
            }
            return parameterIndex;
        }
        catch (SQLException e) {
            throw CmpMessages.MESSAGES.errorSettingParameterForField(this.fieldName, e);
        }
    }

    public Object loadArgumentResults(ResultSet rs, int parameterIndex) throws IllegalArgumentException {
        try {
            Class[] javaTypes = this.jdbcType.getJavaTypes();
            if (javaTypes.length > 1) {
                throw CmpMessages.MESSAGES.complexTypesNotSupported();
            }
            JDBCResultSetReader[] rsReaders = this.jdbcType.getResultSetReaders();
            Object columnValue = null;
            for (int i = 0; i < javaTypes.length; ++i) {
                columnValue = rsReaders[i].get(rs, parameterIndex++, javaTypes[i], this.log);
                columnValue = this.jdbcType.setColumnValue(i, null, columnValue);
            }
            return columnValue;
        }
        catch (SQLException e) {
            throw CmpMessages.MESSAGES.errorGettingResultsForField(this.fieldName, e);
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public JDBCEntityPersistenceStore getManager() {
        return this.entity.getManager();
    }

    @Override
    public void initInstance(CmpEntityBeanContext ctx) {
        Class fieldType = this.getFieldType();
        Serializable value = fieldType == Boolean.TYPE ? Boolean.FALSE : (fieldType == Byte.TYPE ? new Byte(0) : (fieldType == Integer.TYPE ? new Integer(0) : (fieldType == Long.TYPE ? new Long(0L) : (fieldType == Short.TYPE ? new Short(0) : (fieldType == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(fieldType == Double.TYPE ? (Number)new Double(0.0) : (Number)(fieldType == Float.TYPE ? new Float(0.0f) : null)))))));
        this.setValueInternal(ctx, value, false);
    }

    @Override
    public void resetPersistenceContext(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public Object getInstanceValue(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public void setInstanceValue(CmpEntityBeanContext ctx, Object value) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public int loadInstanceResults(ResultSet rs, int parameterIndex, CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public boolean isDirty(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public void setClean(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public boolean isCMPField() {
        return true;
    }

    @Override
    public boolean isPrimaryKeyMember() {
        return this.isPrimaryKeyMember;
    }

    @Override
    public boolean isReadOnly() {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public boolean isReadTimedOut(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public boolean isLoaded(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.methodNotSupported();
    }

    @Override
    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    @Override
    public Object getPrimaryKeyValue(Object primaryKey) throws IllegalArgumentException {
        try {
            if (this.pkField != null) {
                if (primaryKey == null) {
                    return null;
                }
                return this.pkField.get(primaryKey);
            }
            return primaryKey;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorGettingPk(this.fieldName, e);
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object getValue(CmpEntityBeanContext ctx) {
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        return pctx.getFieldValue(this.rowIndex);
    }

    @Override
    public void setValue(CmpEntityBeanContext ctx, Object value) {
        this.setValueInternal(ctx, value, true);
    }

    public Class getFieldType() {
        return this.fieldType;
    }
}

