/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jmx;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.jmx.DatabaseInfoMBean;
import org.h2.jmx.DocumentedMBean;
import org.h2.table.Table;
import org.h2.util.New;

public class DatabaseInfo
implements DatabaseInfoMBean {
    private static final Map<String, ObjectName> MBEANS = New.hashMap();
    private final Database database;

    private DatabaseInfo(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' must not be null");
        }
        this.database = database;
    }

    private static ObjectName getObjectName(String string, String string2) throws JMException {
        string = string.replace(':', '_');
        string2 = string2.replace(':', '_');
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("name", string);
        hashtable.put("path", string2);
        return new ObjectName("org.h2", hashtable);
    }

    public static void registerMBean(ConnectionInfo connectionInfo, Database database) throws JMException {
        String string = connectionInfo.getName();
        if (!MBEANS.containsKey(string)) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            String string2 = database.getShortName();
            ObjectName objectName = DatabaseInfo.getObjectName(string2, string);
            MBEANS.put(string, objectName);
            DatabaseInfo databaseInfo = new DatabaseInfo(database);
            DocumentedMBean documentedMBean = new DocumentedMBean(databaseInfo, DatabaseInfoMBean.class);
            mBeanServer.registerMBean(documentedMBean, objectName);
        }
    }

    public static void unregisterMBean(String string) throws Exception {
        ObjectName objectName = MBEANS.remove(string);
        if (objectName != null) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(objectName);
        }
    }

    public boolean isExclusive() {
        return this.database.getExclusiveSession() != null;
    }

    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    public String getMode() {
        return this.database.getMode().getName();
    }

    public boolean isMultiThreaded() {
        return this.database.isMultiThreaded();
    }

    public boolean isMvcc() {
        return this.database.isMultiVersion();
    }

    public int getLogMode() {
        return this.database.getLogMode();
    }

    public void setLogMode(int n) {
        this.database.setLogMode(n);
    }

    public int getTraceLevel() {
        return this.database.getTraceSystem().getLevelFile();
    }

    public void setTraceLevel(int n) {
        this.database.getTraceSystem().setLevelFile(n);
    }

    public long getFileWriteCountTotal() {
        return this.database.isPersistent() ? this.database.getPageStore().getWriteCountTotal() : 0L;
    }

    public long getFileWriteCount() {
        return this.database.isPersistent() ? this.database.getPageStore().getWriteCount() : 0L;
    }

    public long getFileReadCount() {
        return this.database.isPersistent() ? this.database.getPageStore().getReadCount() : 0L;
    }

    public long getFileSize() {
        return this.database.isPersistent() ? (long)(this.database.getPageStore().getPageCount() * this.database.getPageStore().getPageSize() / 1024) : 0L;
    }

    public int getCacheSizeMax() {
        return this.database.isPersistent() ? this.database.getPageStore().getCache().getMaxMemory() : 0;
    }

    public void setCacheSizeMax(int n) {
        if (this.database.isPersistent()) {
            this.database.getPageStore().getCache().setMaxMemory(n);
        }
    }

    public int getCacheSize() {
        return this.database.isPersistent() ? this.database.getPageStore().getCache().getMemory() : 0;
    }

    public String getVersion() {
        return Constants.getFullVersion();
    }

    public String listSettings() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.database.getSettings().getSettings()).entrySet()) {
            stringBuilder.append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public String listSessions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : this.database.getSessions(false)) {
            Table[] tableArray;
            stringBuilder.append("session id: ").append(session.getId());
            stringBuilder.append(" user: ").append(session.getUser().getName()).append('\n');
            stringBuilder.append("connected: ").append(new Timestamp(session.getSessionStart())).append('\n');
            Command command = session.getCurrentCommand();
            if (command != null) {
                stringBuilder.append("statement: ").append(session.getCurrentCommand()).append('\n');
                long l = session.getCurrentCommandStart();
                if (l != 0L) {
                    stringBuilder.append("started: ").append(new Timestamp(l)).append('\n');
                }
            }
            if ((tableArray = session.getLocks()).length > 0) {
                for (Table table : session.getLocks()) {
                    if (table.isLockedExclusivelyBy(session)) {
                        stringBuilder.append("write lock on ");
                    } else {
                        stringBuilder.append("read lock on ");
                    }
                    stringBuilder.append(table.getSchema().getName()).append('.').append(table.getName()).append('\n');
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

