/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.net.URL;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.naming.NamingMessages;
import org.jboss.dmr.ModelNode;

public class NameBindingAdd110OperationTransformer
implements OperationTransformer {
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        ModelNode resolvedModel = operation.clone();
        if (resolvedModel.hasDefined("binding-type")) {
            String type = resolvedModel.get("binding-type").asString();
            if (type.equals("simple") && resolvedModel.hasDefined("type")) {
                if (URL.class.getName().equals(resolvedModel.get("type").asString())) {
                    return new OperationTransformer.TransformedOperation(operation, this.getOperationResultTransformer(NamingMessages.MESSAGES.failedToTransformSimpleURLNameBindingAddOperation("1.1.0")));
                }
            } else if (type.equals("object-factory") && resolvedModel.hasDefined("environment")) {
                return new OperationTransformer.TransformedOperation(operation, this.getOperationResultTransformer(NamingMessages.MESSAGES.failedToTransformObjectFactoryWithEnvironmentNameBindingAddOperation("1.1.0")));
            }
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }

    private OperationResultTransformer getOperationResultTransformer(final String failureMessage) {
        return new OperationResultTransformer(){

            public ModelNode transformResult(ModelNode result) {
                if (result.get("outcome").asString().equals("ignored-by-unaffected-host-controller")) {
                    return result;
                }
                result = result.clone();
                result.set("outcome", new ModelNode().set("failed"));
                result.set("failure-description", new ModelNode().set(failureMessage));
                return result;
            }
        };
    }
}

