/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jsf.JSFLogger;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class JSFDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JSF_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl");
    private static final ModuleIdentifier JSF_API = ModuleIdentifier.create((String)"javax.faces.api");
    private static final ModuleIdentifier JSF_SUBSYSTEM = ModuleIdentifier.create((String)"org.jboss.as.jsf");
    private static final ModuleIdentifier JSF_INJECTION = ModuleIdentifier.create((String)"org.jboss.as.jsf-injection");
    private static final ModuleIdentifier JSF_INJECTION_1_2 = ModuleIdentifier.create((String)"org.jboss.as.jsf-injection", (String)"1.2");
    private static final ModuleIdentifier JSF_1_2_IMPL = ModuleIdentifier.create((String)"com.sun.jsf-impl", (String)"1.2");
    private static final ModuleIdentifier JSF_1_2_API = ModuleIdentifier.create((String)"javax.faces.api", (String)"1.2");
    private static final ModuleIdentifier BEAN_VALIDATION = ModuleIdentifier.create((String)"org.hibernate.validator");
    private static final ModuleIdentifier JSTL = ModuleIdentifier.create((String)"javax.servlet.jstl.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (JsfVersionMarker.getVersion(deploymentUnit).equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        String jsfVersion = JsfVersionMarker.getVersion(topLevelDeployment);
        this.addJSFAPI(jsfVersion, moduleSpecification, moduleLoader);
        this.addJSFImpl(jsfVersion, moduleSpecification, moduleLoader);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSTL, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, BEAN_VALIDATION, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSF_SUBSYSTEM, false, false, true, false));
        this.addJSFInjection(jsfVersion, moduleSpecification, moduleLoader);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addJSFAPI(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = JSF_API;
        if (jsfVersion.equals("Mojarra-1.2")) {
            jsfModule = JSF_1_2_API;
        }
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, jsfModule, false, false, false, false));
    }

    private void addJSFImpl(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = null;
        if (jsfVersion.equals("Mojarra-1.2")) {
            jsfModule = JSF_1_2_IMPL;
        }
        if (jsfVersion.equals("Mojarra-2.0")) {
            jsfModule = JSF_IMPL;
        }
        if (jsfModule == null) {
            jsfModule = JSF_IMPL;
            JSFLogger.ROOT_LOGGER.unknownJSFVersion(jsfVersion, "Mojarra-2.0");
        }
        ModuleDependency jsf = new ModuleDependency(moduleLoader, jsfModule, false, false, false, false);
        jsf.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(jsf);
    }

    private void addJSFInjection(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfInjecitonModule = JSF_INJECTION;
        if (jsfVersion.equals("Mojarra-1.2")) {
            jsfInjecitonModule = JSF_INJECTION_1_2;
        }
        ModuleDependency jsfInjectionDependency = new ModuleDependency(moduleLoader, jsfInjecitonModule, false, true, true, false);
        moduleSpecification.addSystemDependency(jsfInjectionDependency);
    }
}

