/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class JSFSharedTldsProcessor
implements DeploymentUnitProcessor {
    private static final String[] JSF_TAGLIBS = new String[]{"html_basic.tld", "jsf_core.tld", "mojarra_ext.tld", "myfaces_core.tld", "myfaces_html.tld"};
    private final ArrayList<TldMetaData> jsfTlds = new ArrayList();

    public JSFSharedTldsProcessor() {
        this.init();
    }

    private void init() {
        try {
            ModuleClassLoader jsf = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.create((String)"com.sun.jsf-impl")).getClassLoader();
            for (String tld : JSF_TAGLIBS) {
                InputStream is = jsf.getResourceAsStream("META-INF/" + tld);
                if (is == null) continue;
                TldMetaData tldMetaData = this.parseTLD(is);
                this.jsfTlds.add(tldMetaData);
            }
        }
        catch (ModuleLoadException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldMetaData parseTLD(InputStream is) throws Exception {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit topLevelDeployment;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit deploymentUnit2 = topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        if (JsfVersionMarker.getVersion(topLevelDeployment).equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ArrayList<TldMetaData> tldsMetaData = (ArrayList<TldMetaData>)deploymentUnit.getAttachment(SharedTldsMetaDataBuilder.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            tldsMetaData = new ArrayList<TldMetaData>();
        }
        tldsMetaData.addAll(this.jsfTlds);
        deploymentUnit.putAttachment(SharedTldsMetaDataBuilder.ATTACHMENT_KEY, tldsMetaData);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

