/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.catalina.Container;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.catalina.CatalinaFactoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaHost
implements Host {
    protected final CatalinaFactoryRegistry registry;
    protected final org.apache.catalina.Host host;
    protected final Engine engine;

    public CatalinaHost(CatalinaFactoryRegistry registry, org.apache.catalina.Host host, Engine engine) {
        this.registry = registry;
        this.host = host;
        this.engine = engine;
    }

    public Set<String> getAliases() {
        String name = this.host.getName();
        String[] aliases = this.host.findAliases();
        if (aliases.length == 0) {
            return Collections.singleton(name);
        }
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        hosts.add(name);
        for (String alias : aliases) {
            hosts.add(alias);
        }
        return hosts;
    }

    public Iterable<Context> getContexts() {
        final Iterator<Container> children = Arrays.asList(this.host.findChildren()).iterator();
        final Iterator<Context> contexts = new Iterator<Context>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Context next() {
                return CatalinaHost.this.registry.getContextFactory().createContext((org.apache.catalina.Context)children.next(), CatalinaHost.this);
            }

            @Override
            public void remove() {
                children.remove();
            }
        };
        return new Iterable<Context>(){

            @Override
            public Iterator<Context> iterator() {
                return contexts;
            }
        };
    }

    public Engine getEngine() {
        return this.engine;
    }

    public String getName() {
        return this.host.getName();
    }

    public Context findContext(String path) {
        org.apache.catalina.Context context = (org.apache.catalina.Context)this.host.findChild(path);
        return context != null ? this.registry.getContextFactory().createContext(context, this) : null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaHost)) {
            return false;
        }
        CatalinaHost host = (CatalinaHost)object;
        return this.host == host.host;
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public String toString() {
        return this.host.getName();
    }
}

