/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class HandlerChainRemove
extends AbstractRemoveStepHandler {
    static final HandlerChainRemove INSTANCE = new HandlerChainRemove();

    private HandlerChainRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 1).getKey();
            String handlerChainId = address.getElement(address.size() - 1).getValue();
            for (CommonConfig commonConfig : PackageUtils.getConfigs(config, configType)) {
                List handlerChains;
                if (!configName.equals(commonConfig.getConfigName())) continue;
                if ("pre-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPreHandlerChains();
                } else if ("post-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPostHandlerChains();
                } else {
                    throw WSMessages.MESSAGES.wrongHandlerChainType(handlerChainType, "pre-handler-chain", "post-handler-chain");
                }
                UnifiedHandlerChainMetaData handlerChain = HandlerChainRemove.getChain(handlerChains, handlerChainId);
                if (handlerChain == null) {
                    throw WSMessages.MESSAGES.missingHandlerChain(configName, handlerChainType, handlerChainId);
                }
                handlerChains.remove(handlerChain);
                context.restartRequired();
                return;
            }
            throw WSMessages.MESSAGES.missingConfig(configName);
        }
    }

    private static UnifiedHandlerChainMetaData getChain(List<UnifiedHandlerChainMetaData> handlerChains, String handlerChainId) {
        if (handlerChains != null) {
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (!handlerChainId.equals(handlerChain.getId())) continue;
                return handlerChain;
            }
        }
        return null;
    }
}

