/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.dmr.PropertyAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;

final class PropertyRemove
extends AbstractRemoveStepHandler {
    static final PropertyRemove INSTANCE = new PropertyRemove();

    private PropertyRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String propertyName = address.getElement(address.size() - 1).getValue();
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            for (CommonConfig commonConfig : PackageUtils.getConfigs(config, configType)) {
                if (!configName.equals(commonConfig.getConfigName())) continue;
                if (commonConfig.getProperties().containsKey(propertyName)) {
                    commonConfig.getProperties().remove(propertyName);
                    context.restartRequired();
                }
                return;
            }
            throw WSMessages.MESSAGES.missingConfig(configName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PropertyAdd.INSTANCE.performRuntime(context, operation, model, null, null);
    }
}

