/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.ClientConfigAdd;
import org.jboss.as.webservices.dmr.ClientConfigRemove;
import org.jboss.as.webservices.dmr.EndpointConfigAdd;
import org.jboss.as.webservices.dmr.EndpointConfigRemove;
import org.jboss.as.webservices.dmr.HandlerAdd;
import org.jboss.as.webservices.dmr.HandlerChainAdd;
import org.jboss.as.webservices.dmr.HandlerChainRemove;
import org.jboss.as.webservices.dmr.HandlerRemove;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.PropertyAdd;
import org.jboss.as.webservices.dmr.PropertyRemove;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemAttributeChangeHandler;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemLegacyReader;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.as.webservices.dmr.WSSubsystemReader;
import org.jboss.as.webservices.dmr.WSSubsystemRemove;
import org.jboss.as.webservices.dmr.WSSubsystemWriter;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    private static final PathElement endpointPath = PathElement.pathElement((String)"endpoint");
    private static final PathElement clientConfigPath = PathElement.pathElement((String)"client-config");
    private static final PathElement endpointConfigPath = PathElement.pathElement((String)"endpoint-config");
    private static final PathElement propertyPath = PathElement.pathElement((String)"property");
    private static final PathElement preHandlerChainPath = PathElement.pathElement((String)"pre-handler-chain");
    private static final PathElement postHandlerChainPath = PathElement.pathElement((String)"post-handler-chain");
    private static final PathElement handlerPath = PathElement.pathElement((String)"handler");
    private static final ReloadRequiredWriteAttributeHandler reloadRequiredAttributeHandler = new ReloadRequiredWriteAttributeHandler();
    public static final String SUBSYSTEM_NAME = "webservices";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)WSSubsystemWriter.getInstance());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("remove", (OperationStepHandler)WSSubsystemRemove.INSTANCE, WSSubsystemProviders.SUBSYSTEM_REMOVE, false);
        registration.registerReadWriteAttribute("wsdl-host", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("wsdl-port", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("wsdl-secure-port", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true)), AttributeAccess.Storage.CONFIGURATION);
        registration.registerReadWriteAttribute("modify-wsdl-address", null, (OperationStepHandler)new WSSubsystemAttributeChangeHandler((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true)), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration endpointConfig = registration.registerSubModel(endpointConfigPath, WSSubsystemProviders.ENDPOINT_CONFIG_DESCRIPTION);
        endpointConfig.registerOperationHandler("add", (OperationStepHandler)EndpointConfigAdd.INSTANCE, WSSubsystemProviders.ENDPOINT_CONFIG_ADD_DESCRIPTION, false);
        endpointConfig.registerOperationHandler("remove", (OperationStepHandler)EndpointConfigRemove.INSTANCE, WSSubsystemProviders.ENDPOINT_CONFIG_REMOVE_DESCRIPTION, false);
        this.registerProperty(endpointConfig, false);
        this.registerPreHandlerChain(endpointConfig, false);
        this.registerPostHandlerChain(endpointConfig, false);
        ManagementResourceRegistration clientConfig = registration.registerSubModel(clientConfigPath, WSSubsystemProviders.CLIENT_CONFIG_DESCRIPTION);
        clientConfig.registerOperationHandler("add", (OperationStepHandler)ClientConfigAdd.INSTANCE, WSSubsystemProviders.CLIENT_CONFIG_ADD_DESCRIPTION, false);
        clientConfig.registerOperationHandler("remove", (OperationStepHandler)ClientConfigRemove.INSTANCE, WSSubsystemProviders.CLIENT_CONFIG_REMOVE_DESCRIPTION, false);
        this.registerProperty(clientConfig, true);
        this.registerPreHandlerChain(clientConfig, true);
        this.registerPostHandlerChain(clientConfig, true);
        if (registerRuntimeOnly) {
            ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(WSSubsystemProviders.DEPLOYMENT_DESCRIPTION);
            ManagementResourceRegistration endpoints = deployments.registerSubModel(endpointPath, WSSubsystemProviders.ENDPOINT_DESCRIPTION);
            for (String attributeName : WSEndpointMetrics.ATTRIBUTES) {
                endpoints.registerMetric(attributeName, (OperationStepHandler)WSEndpointMetrics.INSTANCE);
            }
        }
    }

    private void registerProperty(ManagementResourceRegistration config, boolean client) {
        ManagementResourceRegistration property = config.registerSubModel(propertyPath, client ? WSSubsystemProviders.CLIENT_PROPERTY_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PROPERTY_DESCRIPTION);
        property.registerOperationHandler("add", (OperationStepHandler)PropertyAdd.INSTANCE, client ? WSSubsystemProviders.CLIENT_PROPERTY_ADD_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PROPERTY_ADD_DESCRIPTION, false);
        property.registerOperationHandler("remove", (OperationStepHandler)PropertyRemove.INSTANCE, client ? WSSubsystemProviders.CLIENT_PROPERTY_REMOVE_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PROPERTY_REMOVE_DESCRIPTION, false);
        property.registerReadWriteAttribute("value", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
    }

    private void registerPreHandlerChain(ManagementResourceRegistration config, boolean client) {
        ManagementResourceRegistration handlerChain = config.registerSubModel(preHandlerChainPath, client ? WSSubsystemProviders.CLIENT_PRE_HANDLER_CHAIN_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PRE_HANDLER_CHAIN_DESCRIPTION);
        handlerChain.registerOperationHandler("add", (OperationStepHandler)HandlerChainAdd.INSTANCE, client ? WSSubsystemProviders.CLIENT_PRE_HANDLER_CHAIN_ADD_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PRE_HANDLER_CHAIN_ADD_DESCRIPTION, false);
        handlerChain.registerOperationHandler("remove", (OperationStepHandler)HandlerChainRemove.INSTANCE, client ? WSSubsystemProviders.CLIENT_PRE_HANDLER_CHAIN_REMOVE_DESCRIPTION : WSSubsystemProviders.ENDPOINT_PRE_HANDLER_CHAIN_REMOVE_DESCRIPTION, false);
        handlerChain.registerReadWriteAttribute("protocol-bindings", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        this.registerHandler(handlerChain, client);
    }

    private void registerPostHandlerChain(ManagementResourceRegistration config, boolean client) {
        ManagementResourceRegistration handlerChain = config.registerSubModel(postHandlerChainPath, client ? WSSubsystemProviders.CLIENT_POST_HANDLER_CHAIN_DESCRIPTION : WSSubsystemProviders.ENDPOINT_POST_HANDLER_CHAIN_DESCRIPTION);
        handlerChain.registerOperationHandler("add", (OperationStepHandler)HandlerChainAdd.INSTANCE, client ? WSSubsystemProviders.CLIENT_POST_HANDLER_CHAIN_ADD_DESCRIPTION : WSSubsystemProviders.ENDPOINT_POST_HANDLER_CHAIN_ADD_DESCRIPTION, false);
        handlerChain.registerOperationHandler("remove", (OperationStepHandler)HandlerChainRemove.INSTANCE, client ? WSSubsystemProviders.CLIENT_POST_HANDLER_CHAIN_REMOVE_DESCRIPTION : WSSubsystemProviders.ENDPOINT_POST_HANDLER_CHAIN_REMOVE_DESCRIPTION, false);
        handlerChain.registerReadWriteAttribute("protocol-bindings", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        this.registerHandler(handlerChain, client);
    }

    private void registerHandler(ManagementResourceRegistration handlerChain, boolean client) {
        ManagementResourceRegistration postHandler = handlerChain.registerSubModel(handlerPath, WSSubsystemProviders.HANDLER_DESCRIPTION);
        postHandler.registerOperationHandler("add", (OperationStepHandler)HandlerAdd.INSTANCE, WSSubsystemProviders.HANDLER_ADD_DESCRIPTION, false);
        postHandler.registerOperationHandler("remove", (OperationStepHandler)HandlerRemove.INSTANCE, WSSubsystemProviders.HANDLER_REMOVE_DESCRIPTION, false);
        postHandler.registerReadWriteAttribute("class", null, (OperationStepHandler)reloadRequiredAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_0.getUriString(), (XMLElementReader)WSSubsystemLegacyReader.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_1.getUriString(), (XMLElementReader)WSSubsystemReader.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEBSERVICES_1_2.getUriString(), (XMLElementReader)WSSubsystemReader.getInstance());
    }
}

