/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.webservices.dmr.Attribute;
import org.jboss.as.webservices.dmr.Element;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class WSSubsystemReader
implements XMLElementReader<List<ModelNode>> {
    private static final WSSubsystemReader INSTANCE = new WSSubsystemReader();

    private WSSubsystemReader() {
    }

    static WSSubsystemReader getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", "webservices");
        ArrayList<ModelNode> endpointConfigs = new ArrayList<ModelNode>();
        ArrayList<ModelNode> clientConfigs = new ArrayList<ModelNode>();
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEBSERVICES_1_1: {
                    int port;
                    boolean b;
                    Element element = Element.forName(reader.getLocalName());
                    if (element != Element.ENDPOINT_CONFIG && !encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MODIFY_WSDL_ADDRESS: {
                            b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                            subsystem.get("modify-wsdl-address").set(b);
                            continue block19;
                        }
                        case WSDL_HOST: {
                            subsystem.get("wsdl-host").set(this.parseElementNoAttributes(reader));
                            continue block19;
                        }
                        case WSDL_PORT: {
                            port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-port").set(port);
                            continue block19;
                        }
                        case WSDL_SECURE_PORT: {
                            port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-secure-port").set(port);
                            continue block19;
                        }
                        case ENDPOINT_CONFIG: {
                            this.readConfig(reader, subsystem.get("address"), endpointConfigs, false);
                            continue block19;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case WEBSERVICES_1_2: {
                    int port;
                    boolean b;
                    Element element = Element.forName(reader.getLocalName());
                    if (element != Element.ENDPOINT_CONFIG && element != Element.CLIENT_CONFIG && !encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case MODIFY_WSDL_ADDRESS: {
                            b = Boolean.parseBoolean(this.parseElementNoAttributes(reader));
                            subsystem.get("modify-wsdl-address").set(b);
                            continue block19;
                        }
                        case WSDL_HOST: {
                            subsystem.get("wsdl-host").set(this.parseElementNoAttributes(reader));
                            continue block19;
                        }
                        case WSDL_PORT: {
                            port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-port").set(port);
                            continue block19;
                        }
                        case WSDL_SECURE_PORT: {
                            port = Integer.valueOf(this.parseElementNoAttributes(reader));
                            subsystem.get("wsdl-secure-port").set(port);
                            continue block19;
                        }
                        case ENDPOINT_CONFIG: {
                            this.readConfig(reader, subsystem.get("address"), endpointConfigs, false);
                            continue block19;
                        }
                        case CLIENT_CONFIG: {
                            this.readConfig(reader, subsystem.get("address"), clientConfigs, true);
                            continue block19;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(subsystem);
        list.addAll(endpointConfigs);
        list.addAll(clientConfigs);
    }

    private String parseElementNoAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        return reader.getElementText().trim();
    }

    private void readConfig(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationList, boolean client) throws XMLStreamException {
        String configName = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    configName = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address).add(client ? "client-config" : "endpoint-config", configName);
        operationList.add(node);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block9: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.PRE_HANDLER_CHAIN && element != Element.POST_HANDLER_CHAIN && element != Element.PROPERTY && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PRE_HANDLER_CHAIN: {
                    this.parseHandlerChain(reader, configName, operationList, true, client);
                    continue block9;
                }
                case POST_HANDLER_CHAIN: {
                    this.parseHandlerChain(reader, configName, operationList, false, client);
                    continue block9;
                }
                case PROPERTY: {
                    ModelNode operation = this.parseProperty(reader, configName, client);
                    operationList.add(operation);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseProperty(XMLExtendedStreamReader reader, String configName, boolean client) throws XMLStreamException {
        String propertyName = null;
        String propertyValue = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block6;
                }
                case VALUE: {
                    propertyValue = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        if (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                default: 
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add(client ? "client-config" : "endpoint-config", configName).add("property", propertyName);
        if (propertyValue != null) {
            operation.get("value").set(propertyValue);
        }
        return operation;
    }

    private void parseHandlerChain(XMLExtendedStreamReader reader, String configName, List<ModelNode> operationList, boolean isPreHandlerChain, boolean client) throws XMLStreamException {
        String handlerChainId = null;
        String protocolBindings = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    handlerChainId = value;
                    continue block7;
                }
                case PROTOCOL_BINDINGS: {
                    protocolBindings = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        LinkedList<ModelNode> addHandlerOperations = new LinkedList<ModelNode>();
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.HANDLER && !encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case HANDLER: {
                    this.parseHandler(reader, configName, handlerChainId, isPreHandlerChain, addHandlerOperations, client);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        String handlerChainType = isPreHandlerChain ? "pre-handler-chain" : "post-handler-chain";
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add(client ? "client-config" : "endpoint-config", configName).add(handlerChainType, handlerChainId);
        if (protocolBindings != null) {
            operation.get("protocol-bindings").set(protocolBindings);
        }
        operationList.add(operation);
        operationList.addAll(addHandlerOperations);
    }

    private void parseHandler(XMLExtendedStreamReader reader, String configName, String handlerChainId, boolean isPreHandlerChain, List<ModelNode> operations, boolean client) throws XMLStreamException {
        String handlerName = null;
        String handlerClass = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    handlerName = value;
                    continue block6;
                }
                case CLASS: {
                    handlerClass = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        if (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                default: 
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode operation = new ModelNode();
        String handlerChainType = isPreHandlerChain ? "pre-handler-chain" : "post-handler-chain";
        operation.get("operation").set("add");
        operation.get("address").add("subsystem", "webservices").add(client ? "client-config" : "endpoint-config", configName).add(handlerChainType, handlerChainId).add("handler", handlerName);
        operation.get("class").set(handlerClass);
        operations.add(operation);
    }
}

