/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class WSSubsystemWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    private static final WSSubsystemWriter INSTANCE = new WSSubsystemWriter();

    private WSSubsystemWriter() {
    }

    static WSSubsystemWriter getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode subsystem = context.getModelNode();
        if (WSSubsystemWriter.has(subsystem, "modify-wsdl-address")) {
            String modifyWsdlAddress = subsystem.require("modify-wsdl-address").asString();
            WSSubsystemWriter.writeElement(writer, "modify-wsdl-address", modifyWsdlAddress);
        }
        if (WSSubsystemWriter.has(subsystem, "wsdl-host")) {
            String wsdlHost = subsystem.require("wsdl-host").asString();
            WSSubsystemWriter.writeElement(writer, "wsdl-host", wsdlHost);
        }
        if (WSSubsystemWriter.has(subsystem, "wsdl-port")) {
            String wsdlPort = subsystem.require("wsdl-port").asString();
            WSSubsystemWriter.writeElement(writer, "wsdl-port", wsdlPort);
        }
        if (WSSubsystemWriter.has(subsystem, "wsdl-secure-port")) {
            String wsdlSecurePort = subsystem.require("wsdl-secure-port").asString();
            WSSubsystemWriter.writeElement(writer, "wsdl-secure-port", wsdlSecurePort);
        }
        if (WSSubsystemWriter.has(subsystem, "endpoint-config")) {
            ModelNode endpointConfigs = subsystem.get("endpoint-config");
            WSSubsystemWriter.writeConfigs("endpoint-config", writer, endpointConfigs);
        }
        if (WSSubsystemWriter.has(subsystem, "client-config")) {
            ModelNode clientConfigs = subsystem.get("client-config");
            WSSubsystemWriter.writeConfigs("client-config", writer, clientConfigs);
        }
        writer.writeEndElement();
    }

    private static void writeConfigs(String elementName, XMLExtendedStreamWriter writer, ModelNode configs) throws XMLStreamException {
        ModelNode config = null;
        for (String configName : configs.keys()) {
            ModelNode handlerChains;
            config = configs.get(configName);
            writer.writeStartElement(elementName);
            writer.writeAttribute("name", configName);
            if (config.hasDefined("pre-handler-chain")) {
                handlerChains = config.get("pre-handler-chain");
                WSSubsystemWriter.writeHandlerChains(writer, handlerChains, true);
            }
            if (config.hasDefined("post-handler-chain")) {
                handlerChains = config.get("post-handler-chain");
                WSSubsystemWriter.writeHandlerChains(writer, handlerChains, false);
            }
            if (config.hasDefined("property")) {
                ModelNode properties = config.get("property");
                WSSubsystemWriter.writeProperties(writer, properties);
            }
            writer.writeEndElement();
        }
    }

    private static void writeProperties(XMLExtendedStreamWriter writer, ModelNode properties) throws XMLStreamException {
        ModelNode property = null;
        String propertyValue = null;
        for (String propertyName : properties.keys()) {
            property = properties.get(propertyName);
            writer.writeStartElement("property");
            writer.writeAttribute("name", propertyName);
            if (property.hasDefined("value")) {
                propertyValue = property.get("value").asString();
                writer.writeAttribute("value", propertyValue);
            }
            writer.writeEndElement();
        }
    }

    private static void writeHandlerChains(XMLExtendedStreamWriter writer, ModelNode handlerChains, boolean isPre) throws XMLStreamException {
        ModelNode handlerChain = null;
        ModelNode handler = null;
        for (String handlerChainName : handlerChains.keys()) {
            handlerChain = handlerChains.get(handlerChainName);
            writer.writeStartElement(isPre ? "pre-handler-chain" : "post-handler-chain");
            writer.writeAttribute("name", handlerChainName);
            if (handlerChain.hasDefined("protocol-bindings")) {
                String protocolBinding = handlerChain.get("protocol-bindings").asString();
                writer.writeAttribute("protocol-bindings", protocolBinding);
            }
            if (handlerChain.hasDefined("handler")) {
                for (String handlerName : handlerChain.require("handler").keys()) {
                    handler = handlerChain.get("handler").get(handlerName);
                    writer.writeStartElement("handler");
                    writer.writeAttribute("name", handlerName);
                    writer.writeAttribute("class", handler.get("class").asString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }

    private static void writeElement(XMLExtendedStreamWriter writer, String elementName, String elementValue) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (elementValue.indexOf(10) > -1) {
            writer.writeCharacters(elementValue);
        } else {
            char[] chars = elementValue.toCharArray();
            writer.writeCharacters(chars, 0, chars.length);
        }
        writer.writeEndElement();
    }

    private static boolean has(ModelNode node, String name) {
        return node.has(name) && node.get(name).isDefined();
    }
}

