/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.webservices.WSMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.util.URLLoaderAdapter;

public final class VirtualFileAdaptor
implements UnifiedVirtualFile {
    private static final long serialVersionUID = -4509594124653184349L;
    private transient VirtualFile file;

    public VirtualFileAdaptor(VirtualFile file) {
        this.file = file;
    }

    protected VirtualFile getFile() throws IOException {
        return this.file;
    }

    public UnifiedVirtualFile findChild(String child) throws IOException {
        VirtualFile virtualFile = this.getFile();
        VirtualFile childFile = this.file.getChild(child);
        if (!childFile.exists()) {
            throw WSMessages.MESSAGES.missingChild(child, virtualFile);
        }
        return new VirtualFileAdaptor(childFile);
    }

    public URL toURL() {
        try {
            return this.getFile().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object writeReplace() {
        try {
            File archive = this.file.getPhysicalFile();
            if (archive.list().length == 0) {
                File parent = this.file.getPhysicalFile().getParentFile();
                File[] children = parent.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File fileOrDir) {
                        return fileOrDir.isFile();
                    }
                });
                archive = children[0];
            }
            return new URLLoaderAdapter(archive.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<UnifiedVirtualFile> getChildren() throws IOException {
        List vfList = this.getFile().getChildren();
        if (vfList == null) {
            return null;
        }
        LinkedList<UnifiedVirtualFile> uvfList = new LinkedList<UnifiedVirtualFile>();
        for (VirtualFile vf : vfList) {
            uvfList.add(new VirtualFileAdaptor(vf));
        }
        return uvfList;
    }

    public String getName() {
        try {
            return this.getFile().getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

