/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.LinkedHashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerOperations;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;

abstract class AbstractHandlerDefinition
extends SimpleResourceDefinition {
    public static final String UPDATE_OPERATION_NAME = "update-properties";
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    static final AttributeDefinition[] DEFAULT_WRITABLE_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.LEVEL, CommonAttributes.ENCODING, CommonAttributes.FORMATTER, CommonAttributes.FILTER};
    private final HandlerOperations.LogHandlerWriteAttributeHandler writeHandler;
    private final AttributeDefinition[] writableAttributes;
    private final AttributeDefinition[] readOnlyAttributes;

    protected AbstractHandlerDefinition(PathElement path, String key, LoggingOperations.LoggingAddOperationStepHandler addHandler, AttributeDefinition ... writableAttributes) {
        this(path, key, addHandler, (AttributeDefinition[])null, writableAttributes);
    }

    protected AbstractHandlerDefinition(PathElement path, String key, LoggingOperations.LoggingAddOperationStepHandler addHandler, AttributeDefinition[] readOnlyAttributes, AttributeDefinition ... writableAttributes) {
        super(path, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver("handler"), (OperationStepHandler)addHandler, (OperationStepHandler)HandlerOperations.REMOVE_HANDLER);
        this.writableAttributes = writableAttributes;
        this.writeHandler = new HandlerOperations.LogHandlerWriteAttributeHandler(this.writableAttributes);
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : this.writableAttributes) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)this.writeHandler);
        }
        if (this.readOnlyAttributes != null) {
            for (AttributeDefinition def : this.readOnlyAttributes) {
                resourceRegistration.registerReadOnlyAttribute(def, null);
            }
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        ResourceDescriptionResolver resolver = this.getResourceDescriptionResolver();
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("enable", resolver), (OperationStepHandler)HandlerOperations.ENABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition("disable", resolver), (OperationStepHandler)HandlerOperations.DISABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(CHANGE_LEVEL_OPERATION_NAME, resolver, new AttributeDefinition[]{CommonAttributes.LEVEL}), (OperationStepHandler)HandlerOperations.CHANGE_LEVEL);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(UPDATE_OPERATION_NAME, resolver, this.writableAttributes), (OperationStepHandler)new HandlerOperations.HandlerUpdateOperationStepHandler(this.writableAttributes));
    }

    static AttributeDefinition[] appendDefaultWritableAttributes(AttributeDefinition ... attributes) {
        return AbstractHandlerDefinition.joinUnique(DEFAULT_WRITABLE_ATTRIBUTES, attributes);
    }

    static AttributeDefinition[] joinUnique(AttributeDefinition[] base, AttributeDefinition ... attributes) {
        LinkedHashMap<String, AttributeDefinition> result = new LinkedHashMap<String, AttributeDefinition>();
        if (base != null) {
            for (AttributeDefinition attr : base) {
                result.put(attr.getName(), attr);
            }
        }
        if (attributes != null) {
            for (AttributeDefinition attr : attributes) {
                if (result.containsKey(attr.getName())) continue;
                result.put(attr.getName(), attr);
            }
        }
        return result.values().toArray(new AttributeDefinition[result.size()]);
    }
}

