/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.LoggerOperations;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.resolvers.FilterResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.PatternFormatter;

final class HandlerOperations {
    private static final Logger.AttachmentKey<Map<String, String>> DISABLED_HANDLERS_KEY = new Logger.AttachmentKey();
    private static final Object HANDLER_LOCK = new Object();
    public static HandlerUpdateOperationStepHandler CHANGE_LEVEL = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.LEVEL});
    public static LoggingOperations.LoggingRemoveOperationStepHandler REMOVE_HANDLER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            logContextConfiguration.removeHandlerConfiguration(name);
            if (logContextConfiguration.getFormatterNames().contains(name)) {
                logContextConfiguration.removeFormatterConfiguration(name);
            }
        }

        @Override
        protected void performRollback(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode originalModel) throws OperationFailedException {
            LoggerOperations.ADD_HANDLER.performRuntime(context, operation, logContextConfiguration, name, originalModel);
        }
    };
    public static final HandlerUpdateOperationStepHandler ADD_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            model.get(CommonAttributes.SUBHANDLERS.getName()).add(operation.get(CommonAttributes.HANDLER_NAME.getName()));
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString();
            if (name.equals(handlerName)) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(configuration.getName()));
            }
            if (configuration.getHandlerNames().contains(handlerName)) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
            }
            configuration.addHandlerName(handlerName);
        }

        @Override
        public void performRollback(OperationContext context, HandlerConfiguration configuration, String name, ModelNode originalModel) throws OperationFailedException {
            REMOVE_SUBHANDLER.performRollback(context, configuration, name, originalModel);
        }
    };
    public static final HandlerUpdateOperationStepHandler REMOVE_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            String handlerName = model.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(CommonAttributes.SUBHANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(CommonAttributes.SUBHANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString());
        }

        @Override
        public void performRollback(OperationContext context, HandlerConfiguration configuration, String name, ModelNode originalModel) throws OperationFailedException {
            ADD_SUBHANDLER.performRollback(context, configuration, name, originalModel);
        }
    };
    public static HandlerUpdateOperationStepHandler CHANGE_FILE = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.FILE});
    public static LoggingOperations.LoggingUpdateOperationStepHandler ENABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.enableHandler(configuration, name);
        }

        @Override
        public void performRollback(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration, String name, ModelNode originalModel) throws OperationFailedException {
        }
    };
    public static LoggingOperations.LoggingUpdateOperationStepHandler DISABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.disableHandler(configuration, name);
        }

        @Override
        public void performRollback(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration, String name, ModelNode originalModel) throws OperationFailedException {
        }
    };

    HandlerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.ENCODING.resolvePropertyValue(context, model) : model.asString();
            configuration.setEncoding(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.FORMATTER.getName())) {
            String formatterName = configuration.getName();
            FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(formatterName) ? logContextConfiguration.getFormatterConfiguration(formatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), formatterName, new String[]{"pattern"});
            String resolvedValue = resolveValue ? CommonAttributes.FORMATTER.resolvePropertyValue(context, model) : model.asString();
            fmtConfig.setPropertyValueString("pattern", resolvedValue);
            configuration.setFormatterName(formatterName);
        } else if (attribute.getName().equals(CommonAttributes.FILTER.getName())) {
            ModelNode valueNode = resolveValue ? CommonAttributes.FILTER.resolveModelAttribute(context, model) : model;
            String resolvedValue = FilterResolver.INSTANCE.resolveValue(context, valueNode);
            configuration.setFilter(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.SUBHANDLERS.getName())) {
            Set<String> resolvedValue;
            Set<String> set = resolvedValue = resolveValue ? CommonAttributes.SUBHANDLERS.resolvePropertyValue(context, model) : CommonAttributes.SUBHANDLERS.resolver().resolveValue(context, model);
            if (resolvedValue.contains(configuration.getName())) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(configuration.getName()));
            }
            configuration.setHandlerNames(resolvedValue);
        } else if (!attribute.getName().equals(CommonAttributes.HANDLER_NAME.getName())) {
            if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
                if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                    for (Property property : CommonAttributes.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                }
            } else if (attribute instanceof ConfigurationProperty) {
                ((ConfigurationProperty)attribute).setPropertyValue(context, model, (PropertyConfigurable)configuration);
            } else {
                LoggingLogger.ROOT_LOGGER.invalidPropertyAttribute(attribute.getName());
            }
        }
    }

    private static boolean equalValue(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        boolean result;
        if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = CommonAttributes.ENCODING.resolvePropertyValue(context, model);
            String currentValue = configuration.getEncoding();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.FORMATTER.getName())) {
            String formatterName = configuration.getName();
            if (logContextConfiguration.getFormatterNames().contains(formatterName)) {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterConfiguration(formatterName);
                String resolvedValue = CommonAttributes.FORMATTER.resolvePropertyValue(context, model);
                String currentValue = fmtConfig.getPropertyValueString("pattern");
                result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
            } else {
                result = false;
            }
        } else if (attribute.getName().equals(CommonAttributes.FILTER.getName())) {
            ModelNode valueNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
            String resolvedValue = FilterResolver.INSTANCE.resolveValue(context, valueNode);
            String currentValue = configuration.getFilter();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = CommonAttributes.LEVEL.resolvePropertyValue(context, model);
            String currentValue = configuration.getLevel();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(configuration.getLevel());
        } else if (attribute.getName().equals(CommonAttributes.SUBHANDLERS.getName())) {
            Object resolvedValue = CommonAttributes.SUBHANDLERS.resolvePropertyValue(context, model);
            List currentValue = configuration.getHandlerNames();
            result = resolvedValue == null ? currentValue == null : resolvedValue.containsAll(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
            result = true;
            if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                for (Property property : CommonAttributes.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                    String resolvedValue = property.getValue().asString();
                    String currentValue = configuration.getPropertyValueString(property.getName());
                    if (resolvedValue != null ? resolvedValue.equals(currentValue) : currentValue == null) continue;
                    return false;
                }
            }
        } else if (attribute instanceof PropertyAttributeDefinition) {
            PropertyAttributeDefinition propAttribute = (PropertyAttributeDefinition)attribute;
            String resolvedValue = propAttribute.resolvePropertyValue(context, model);
            String currentValue = configuration.getPropertyValueString(propAttribute.getPropertyName());
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "true");
            return;
        }
        catch (IllegalArgumentException e) {
            Map disableHandlers = (Map)configuration.getLogContext().getAttachment("", DISABLED_HANDLERS_KEY);
            if (disableHandlers != null && disableHandlers.containsKey(handlerName)) {
                Object object = HANDLER_LOCK;
                synchronized (object) {
                    String filter = (String)disableHandlers.get(handlerName);
                    handlerConfiguration.setFilter(filter);
                    disableHandlers.remove(handlerName);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "false");
            return;
        }
        catch (IllegalArgumentException e) {
            Logger root = configuration.getLogContext().getLogger("");
            Map<String, String> disableHandlers = (HashMap<String, String>)root.getAttachment(DISABLED_HANDLERS_KEY);
            Object object = HANDLER_LOCK;
            synchronized (object) {
                Map current;
                if (disableHandlers == null && (current = (Map)root.attachIfAbsent(DISABLED_HANDLERS_KEY, disableHandlers = new HashMap<String, String>())) != null) {
                    disableHandlers = current;
                }
                if (!disableHandlers.containsKey(handlerName)) {
                    disableHandlers.put(handlerName, handlerConfiguration.getFilter());
                    handlerConfiguration.setFilter(CommonAttributes.DENY.getName());
                }
            }
            return;
        }
    }

    public static class LogHandlerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        protected LogHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            boolean restartRequired;
            block14: {
                restartRequired = false;
                if (!logContextConfiguration.getHandlerNames().contains(addressName)) break block14;
                HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FORMATTER, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.ENCODING, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.SUBHANDLERS.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.SUBHANDLERS, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.PROPERTIES.getName().equals(attributeName)) {
                    for (Property property : value.asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                } else {
                    for (AttributeDefinition attribute : this.getAttributes()) {
                        if (!attribute.getName().equals(attributeName)) continue;
                        HandlerOperations.handleProperty(attribute, context, value, logContextConfiguration, configuration, false);
                        restartRequired = Logging.requiresRestart(attribute.getFlags());
                        break;
                    }
                }
            }
            return restartRequired;
        }
    }

    static class HandlerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final String[] constructionProperties;
        private final AttributeDefinition[] attributes;
        private final Class<? extends Handler> type;

        protected HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes) {
            this.type = type;
            this.constructionProperties = null;
            this.attributes = attributes;
        }

        protected HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
            this.type = type;
            this.attributes = attributes;
            ArrayList<String> names = new ArrayList<String>();
            for (ConfigurationProperty<?> prop : constructionProperties) {
                names.add(prop.getPropertyName());
            }
            this.constructionProperties = names.toArray(new String[names.size()]);
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            boolean exists;
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            boolean bl = exists = configuration != null;
            if (!exists) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                configuration = this.createHandlerConfiguration(context, model, name, logContextConfiguration);
            }
            for (AttributeDefinition attribute : this.attributes) {
                boolean skip;
                if (attribute.equals(CommonAttributes.CLASS) || attribute.equals(CommonAttributes.MODULE)) {
                    skip = true;
                } else {
                    boolean bl2 = skip = exists && HandlerOperations.equalValue(attribute, context, model, logContextConfiguration, configuration);
                }
                if (skip) continue;
                HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
            }
        }

        @Override
        public void performRollback(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name) throws OperationFailedException {
            if (logContextConfiguration != null) {
                logContextConfiguration.removeHandlerConfiguration(name);
            }
        }

        protected HandlerConfiguration createHandlerConfiguration(OperationContext context, ModelNode model, String name, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String moduleName;
            String className;
            if (this.type == null) {
                className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
                moduleName = CommonAttributes.MODULE.resolveModelAttribute(context, model).asString();
            } else {
                className = this.type.getName();
                moduleName = null;
            }
            HandlerConfiguration configuration = this.constructionProperties == null ? logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]) : logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
            return configuration;
        }
    }

    static class HandlerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        private final AttributeDefinition[] attributes;

        protected HandlerUpdateOperationStepHandler() {
            this.attributes = null;
        }

        protected HandlerUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            this.attributes = attributes;
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.handlerConfigurationNotFound(name));
            }
            if (this.attributes != null) {
                for (AttributeDefinition attribute : this.attributes) {
                    HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
                    if (!Logging.requiresRestart(attribute.getFlags())) continue;
                    context.restartRequired();
                }
            }
            this.performRuntime(context, configuration, name, model);
        }

        @Override
        public final void performRollback(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration, String name, ModelNode originalModel) throws OperationFailedException {
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration != null) {
                if (this.attributes != null) {
                    if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                        for (Property property : CommonAttributes.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                            configuration.removeProperty(property.getName());
                        }
                    }
                    for (AttributeDefinition attribute : this.attributes) {
                        HandlerOperations.handleProperty(attribute, context, originalModel, logContextConfiguration, configuration);
                        if (!Logging.requiresRestart(attribute.getFlags())) continue;
                        context.restartRequired();
                    }
                }
                this.performRollback(context, configuration, name, originalModel);
            }
        }

        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
        }

        public void performRollback(OperationContext context, HandlerConfiguration configuration, String name, ModelNode originalModel) throws OperationFailedException {
        }
    }
}

