/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.resolvers.HandlerResolver;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.PropertyConfigurable;

public class LogHandlerListAttributeDefinition
extends SimpleListAttributeDefinition
implements ConfigurationProperty<Set<String>> {
    private final String propertyName;
    private final HandlerResolver resolver = HandlerResolver.INSTANCE;

    LogHandlerListAttributeDefinition(String name, String xmlName, String propertyName, AttributeDefinition valueType, boolean allowNull, int minSize, int maxSize, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecationData, AttributeAccess.Flag ... flags) {
        super(name, xmlName, valueType, allowNull, minSize, maxSize, alternatives, requires, attributeMarshaller, resourceOnly, deprecationData, flags);
        this.propertyName = propertyName;
    }

    @Override
    public ModelNodeResolver<Set<String>> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Set<String> resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        Object result = Collections.emptySet();
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver.resolveValue(context, value);
        }
        return result;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        throw LoggingMessages.MESSAGES.unsupportedMethod("setPropertyValue", this.getClass().getName());
    }

    public void marshallAsElement(ModelNode resourceModel, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName())) {
            writer.writeStartElement(this.getXmlName());
            for (ModelNode handler : resourceModel.get(this.getName()).asList()) {
                this.getValueType().marshallAsElement(handler, writer);
            }
            writer.writeEndElement();
        }
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, LogHandlerListAttributeDefinition> {
        private String propertyName;
        private AttributeDefinition valueType;

        Builder(String name, SimpleAttributeDefinition valueType) {
            super(name, ModelType.LIST);
            this.valueType = valueType;
        }

        public static Builder of(String name, SimpleAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        public LogHandlerListAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            if (this.propertyName == null) {
                this.propertyName = this.name;
            }
            return new LogHandlerListAttributeDefinition(this.name, this.xmlName, this.propertyName, this.valueType, this.allowNull, this.minSize, this.maxSize, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.flags);
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }
    }
}

