/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggerOperations;
import org.jboss.as.logging.LoggingExtension;

public class LoggerResourceDefinition
extends SimpleResourceDefinition {
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    public static final String ADD_HANDLER_OPERATION_NAME = "assign-handler";
    public static final String REMOVE_HANDLER_OPERATION_NAME = "unassign-handler";
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.CATEGORY, CommonAttributes.FILTER, CommonAttributes.LEVEL, CommonAttributes.HANDLERS, CommonAttributes.USE_PARENT_HANDLERS};
    static final AttributeDefinition[] WRITABLE_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER, CommonAttributes.LEVEL, CommonAttributes.HANDLERS, CommonAttributes.USE_PARENT_HANDLERS};
    static LoggerOperations.LoggerWriteAttributeHandler LOGGER_WRITE_HANDLER = new LoggerOperations.LoggerWriteAttributeHandler(WRITABLE_ATTRIBUTES);
    static LoggerOperations.LoggerAddOperationStepHandler ADD_LOGGER = new LoggerOperations.LoggerAddOperationStepHandler(ATTRIBUTES);
    static final LoggerResourceDefinition INSTANCE = new LoggerResourceDefinition();

    private LoggerResourceDefinition() {
        super(LoggingExtension.LOGGER_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver("logger"), (OperationStepHandler)ADD_LOGGER, (OperationStepHandler)LoggerOperations.REMOVE_LOGGER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : WRITABLE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)LOGGER_WRITE_HANDLER);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.CATEGORY, null);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        ResourceDescriptionResolver resolver = this.getResourceDescriptionResolver();
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(CHANGE_LEVEL_OPERATION_NAME, resolver, new AttributeDefinition[]{CommonAttributes.LEVEL}), (OperationStepHandler)LoggerOperations.CHANGE_LEVEL);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(ADD_HANDLER_OPERATION_NAME, resolver, new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}), (OperationStepHandler)LoggerOperations.ADD_HANDLER);
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinition(REMOVE_HANDLER_OPERATION_NAME, resolver, new AttributeDefinition[]{CommonAttributes.HANDLER_NAME}), (OperationStepHandler)LoggerOperations.REMOVE_HANDLER);
    }
}

