/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.SecurityActions;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class LoggingDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    static final LoggingDeploymentUnitProcessor INSTANCE = new LoggingDeploymentUnitProcessor();
    public static final String PER_DEPLOYMENT_LOGGING = "org.jboss.as.logging.per-deployment";
    public static final AttachmentKey<LogContext> LOG_CONTEXT_KEY = AttachmentKey.create(LogContext.class);
    private static final String ENCODING = "utf-8";
    private static final String LOGGING_PROFILE = "Logging-Profile";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String JBOSS_LOG4J_XML = "jboss-log4j.xml";
    private static final String DEFAULT_PROPERTIES = "logging.properties";
    private static final String JBOSS_PROPERTIES = "jboss-logging.properties";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.MODULE) && deploymentUnit.hasAttachment(Attachments.DEPLOYMENT_ROOT) && !this.processLoggingProfiles(deploymentUnit)) {
            this.processDeploymentLogging(deploymentUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit context) {
        if (context.hasAttachment(Attachments.MODULE)) {
            Module module = (Module)context.getAttachment(Attachments.MODULE);
            ClassLoader current = SecurityActions.getThreadContextClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader((ClassLoader)module.getClassLoader());
                LogContext logContext = LogContext.getLogContext();
                LoggingExtension.CONTEXT_SELECTOR.unregisterLogContext((ClassLoader)module.getClassLoader(), logContext);
                LoggingLogger.ROOT_LOGGER.tracef("Removing LogContext '%s' from '%s'", logContext, module);
                context.removeAttachment(LOG_CONTEXT_KEY);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(current);
            }
        }
    }

    private boolean processLoggingProfiles(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        boolean result = false;
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        String loggingProfile = this.findLoggingProfile(root);
        if (loggingProfile != null) {
            result = true;
            LoggingProfileContextSelector loggingProfileContext = LoggingProfileContextSelector.getInstance();
            if (loggingProfileContext.exists(loggingProfile)) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = loggingProfileContext.get(loggingProfile);
                LoggingExtension.CONTEXT_SELECTOR.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
                LoggingLogger.ROOT_LOGGER.tracef("Registering log context '%s' on '%s' for profile '%s'", logContext, root, loggingProfile);
            } else {
                LoggingLogger.ROOT_LOGGER.loggingProfileNotFound(loggingProfile, root);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeploymentLogging(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        if (Boolean.valueOf(SecurityActions.getSystemProperty(PER_DEPLOYMENT_LOGGING, Boolean.toString(true))).booleanValue()) {
            LogContext logContext;
            if (deploymentUnit.hasAttachment(LOG_CONTEXT_KEY)) {
                return;
            }
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)root) && (logContext = this.findParentLogContext(deploymentUnit)) != null) {
                LoggingExtension.CONTEXT_SELECTOR.registerLogContext((ClassLoader)module.getClassLoader(), logContext);
                return;
            }
            LoggingLogger.ROOT_LOGGER.trace("Scanning for logging configuration files.");
            VirtualFile configFile = this.findConfigFile(root);
            if (configFile != null) {
                InputStream configStream;
                block15: {
                    configStream = null;
                    try {
                        LoggingLogger.ROOT_LOGGER.debugf("Found logging configuration file: %s", configFile);
                        LogContext logContext2 = LogContext.create();
                        LoggingExtension.CONTEXT_SELECTOR.registerLogContext((ClassLoader)module.getClassLoader(), logContext2);
                        deploymentUnit.putAttachment(LOG_CONTEXT_KEY, (Object)logContext2);
                        String fileName = configFile.getName();
                        configStream = configFile.openStream();
                        if (LOG4J_PROPERTIES.equals(fileName) || LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName)) {
                            ClassLoader current = SecurityActions.getThreadContextClassLoader();
                            try {
                                SecurityActions.setThreadContextClassLoader((ClassLoader)module.getClassLoader());
                                if (LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName)) {
                                    new DOMConfigurator().doConfigure(configStream, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext2));
                                } else {
                                    Properties properties = new Properties();
                                    properties.load(new InputStreamReader(configStream, ENCODING));
                                    new PropertyConfigurator().doConfigure(properties, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext2));
                                }
                                break block15;
                            }
                            finally {
                                SecurityActions.setThreadContextClassLoader(current);
                            }
                        }
                        Properties properties = new Properties();
                        properties.load(new InputStreamReader(configStream, ENCODING));
                        if (LoggingDeploymentUnitProcessor.isJulConfiguration(properties)) {
                            LoggingLogger.ROOT_LOGGER.julConfigurationFileFound(configFile.getName());
                            break block15;
                        }
                        ConfigurationPersistence configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext2);
                        configurationPersistence.configure(properties);
                    }
                    catch (Exception e) {
                        try {
                            throw LoggingMessages.MESSAGES.failedToConfigureLogging(e, configFile.getName());
                        }
                        catch (Throwable throwable) {
                            LoggingDeploymentUnitProcessor.safeClose(configStream);
                            throw throwable;
                        }
                    }
                }
                LoggingDeploymentUnitProcessor.safeClose(configStream);
            }
        }
    }

    private String findLoggingProfile(ResourceRoot resourceRoot) {
        String loggingProfile;
        Manifest manifest = (Manifest)resourceRoot.getAttachment(Attachments.MANIFEST);
        if (manifest != null && (loggingProfile = manifest.getMainAttributes().getValue(LOGGING_PROFILE)) != null) {
            LoggingLogger.ROOT_LOGGER.debugf("Logging profile '%s' found in '%s'.", loggingProfile, resourceRoot);
            return loggingProfile;
        }
        return null;
    }

    private VirtualFile findConfigFile(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
        VirtualFile result = null;
        try {
            List configFiles = resourceRoot.getRoot().getChildrenRecursively((VirtualFileFilter)ConfigFilter.INSTANCE);
            for (VirtualFile file : configFiles) {
                String fileName = file.getName();
                if (DEFAULT_PROPERTIES.equals(fileName) || JBOSS_PROPERTIES.equals(fileName)) {
                    if (result != null) {
                        LoggingLogger.ROOT_LOGGER.debugf("The previously found configuration file '%s' is being ignored in favour of '%s'", result, file);
                    }
                    return file;
                }
                if (!LOG4J_PROPERTIES.equals(fileName) && !LOG4J_XML.equals(fileName) && !JBOSS_LOG4J_XML.equals(fileName)) continue;
                result = file;
            }
        }
        catch (IOException e) {
            throw LoggingMessages.MESSAGES.errorProcessingLoggingConfiguration(e);
        }
        return result;
    }

    private LogContext findParentLogContext(DeploymentUnit deploymentUnit) {
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent == null) {
            return (LogContext)deploymentUnit.getAttachment(LOG_CONTEXT_KEY);
        }
        return this.findParentLogContext(parent);
    }

    private static void safeClose(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isJulConfiguration(Properties properties) {
        String prop;
        if (properties.containsKey(".level")) {
            return true;
        }
        if (properties.containsKey("handlers") && (prop = properties.getProperty("handlers", "")) != null && !prop.trim().isEmpty()) {
            String[] handlers;
            for (String handler : handlers = prop.split("\\s*,\\s*")) {
                String key = String.format("handler.%s", handler);
                if (properties.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ConfigFilter
    implements VirtualFileFilter {
        static final ConfigFilter INSTANCE = new ConfigFilter();
        private final Set<String> configFiles = new HashSet<String>(Arrays.asList("log4j.properties", "log4j.xml", "jboss-log4j.xml", "jboss-logging.properties", "logging.properties"));

        private ConfigFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return this.configFiles.contains(file.getName());
        }
    }
}

