/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.FileHandlerResourceDefinition;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.LoggingRootResource;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.SizePeriodicHandlerResourceDefinition;
import org.jboss.logmanager.ContextClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class LoggingExtension
implements Extension {
    private static final String RESOURCE_NAME = LoggingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String SUBSYSTEM_NAME = "logging";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"logging");
    static final PathElement ROOT_LOGGER_PATH = PathElement.pathElement((String)"root-logger", (String)"ROOT");
    static final PathElement LOGGER_PATH = PathElement.pathElement((String)"logger");
    static final PathElement ASYNC_HANDLER_PATH = PathElement.pathElement((String)"async-handler");
    static final PathElement CONSOLE_HANDLER_PATH = PathElement.pathElement((String)"console-handler");
    static final PathElement CUSTOM_HANDLE_PATH = PathElement.pathElement((String)"custom-handler");
    static final PathElement FILE_HANDLER_PATH = PathElement.pathElement((String)"file-handler");
    static final PathElement PERIODIC_HANDLER_PATH = PathElement.pathElement((String)"periodic-rotating-file-handler");
    static final PathElement SIZE_ROTATING_HANDLER_PATH = PathElement.pathElement((String)"size-rotating-file-handler");
    static final PathElement LOGGING_PROFILE_PATH = PathElement.pathElement((String)"logging-profile");
    static final ResourceDescriptionResolver FILTER_ATTRIBUTE_RESOLVER = LoggingExtension.getResourceDescriptionResolver(CommonAttributes.HANDLER.getName());
    static final ContextClassLoaderLogContextSelector CONTEXT_SELECTOR = new ContextClassLoaderLogContextSelector();
    static final GenericSubsystemDescribeHandler DESCRIBE_HANDLER = GenericSubsystemDescribeHandler.create((Comparator)LoggingChildResourceComparator.INSTANCE);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new LoggingResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, LoggingExtension.class.getClassLoader());
    }

    public void initialize(ExtensionContext context) {
        LogContext.setLogContextSelector((LogContextSelector)CONTEXT_SELECTOR);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)LoggingRootResource.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)DESCRIBE_HANDLER);
        this.registerSubModels(registration);
        this.registerSubModels(registration.registerSubModel((ResourceDefinition)new SimpleResourceDefinition(LOGGING_PROFILE_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0]), LoggingProfileOperations.ADD_PROFILE, LoggingProfileOperations.REMOVE_PROFILE)));
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemParser.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.readable()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
        }
    }

    private void registerSubModels(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)RootLoggerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)LoggerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)AsyncHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)ConsoleHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)FileHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)PeriodicHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)SizePeriodicHandlerResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)CustomHandlerResourceDefinition.INSTANCE);
    }

    public static class LoggingChildResourceComparator
    implements Comparator<PathElement> {
        static final LoggingChildResourceComparator INSTANCE = new LoggingChildResourceComparator();
        static final int GREATER = 1;
        static final int EQUAL = 0;
        static final int LESS = -1;

        @Override
        public int compare(PathElement o1, PathElement o2) {
            String key2;
            String key1 = o1.getKey();
            int result = key1.compareTo(key2 = o2.getKey());
            if (result != 0) {
                if ("subsystem".equals(key1)) {
                    result = -1;
                } else if ("subsystem".equals(key2)) {
                    result = 1;
                } else if ("logging-profile".equals(key1)) {
                    result = -1;
                } else if ("logging-profile".equals(key2)) {
                    result = 1;
                } else if ("root-logger".equals(key1)) {
                    result = 1;
                } else if ("root-logger".equals(key2)) {
                    result = -1;
                } else if ("logger".equals(key1)) {
                    result = 1;
                } else if ("logger".equals(key2)) {
                    result = -1;
                } else if ("async-handler".equals(key1)) {
                    result = 1;
                } else if ("async-handler".equals(key2)) {
                    result = -1;
                }
            }
            return result;
        }
    }

    private static class LoggingResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private static final Map<String, String> COMMON_ATTRIBUTE_NAMES = new HashMap<String, String>();

        public LoggingResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
            super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName.split("\\.")[0])) {
                return bundle2.getString(this.getBundleKey(attributeName));
            }
            return super.getResourceAttributeDescription(attributeName, locale, bundle2);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
            }
            return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getBundleKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
            }
            return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
        }

        private String getBundleKey(String name) {
            return this.getVariableBundleKey(name, new String[0]);
        }

        private String getVariableBundleKey(String name, String ... variable) {
            String prefix = COMMON_ATTRIBUTE_NAMES.get(name.split("\\.")[0]);
            StringBuilder sb = prefix == null ? new StringBuilder(name) : new StringBuilder(prefix).append('.').append(name);
            if (variable != null) {
                for (String arg : variable) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(arg);
                }
            }
            return sb.toString();
        }

        static {
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.APPEND.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.AUTOFLUSH.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.CLASS.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENCODING.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.HANDLERS.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.LEVEL.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.MAX_BACKUP_INDEX.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.MODULE.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.OVERFLOW_ACTION.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.PATH.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.PROPERTIES.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.QUEUE_LENGTH.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.RELATIVE_TO.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ROTATE_SIZE.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.SUBHANDLERS.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.SUFFIX.getName(), "logging.periodic-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.TARGET.getName(), "logging.console-handler");
        }
    }
}

