/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.LogContextConfiguration;

final class LoggingOperations {
    LoggingOperations() {
    }

    public static String getAddressName(ModelNode operation) {
        return LoggingOperations.getAddress(operation).getLastElement().getValue();
    }

    public static PathAddress getAddress(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address"));
    }

    static abstract class LoggingWriteAttributeHandler
    extends AbstractWriteAttributeHandler<ConfigurationPersistence> {
        private final AttributeDefinition[] attributes;

        protected LoggingWriteAttributeHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ConfigurationPersistence> handbackHolder) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence;
            String name = LoggingOperations.getAddressName(operation);
            PathAddress address = LoggingOperations.getAddress(operation);
            boolean isLoggingProfile = LoggingProfileOperations.isLoggingProfileAddress(address);
            if (isLoggingProfile) {
                LogContext logContext = LoggingProfileContextSelector.getInstance().getOrCreate(LoggingProfileOperations.getLoggingProfileName(address));
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext);
            } else {
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
            }
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            handbackHolder.setHandback((Object)configurationPersistence);
            boolean restartRequired = this.applyUpdate(context, attributeName, name, resolvedValue, logContextConfiguration);
            try {
                logContextConfiguration.commit();
            }
            finally {
                logContextConfiguration.forget();
            }
            if (!isLoggingProfile) {
                configurationPersistence.writeConfiguration(context);
            }
            return restartRequired;
        }

        protected abstract boolean applyUpdate(OperationContext var1, String var2, String var3, ModelNode var4, LogContextConfiguration var5) throws OperationFailedException;

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, ConfigurationPersistence configurationPersistence) throws OperationFailedException {
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            logContextConfiguration.forget();
            String name = LoggingOperations.getAddressName(operation);
            this.applyUpdate(context, attributeName, name, valueToRestore, logContextConfiguration);
            if (!LoggingProfileOperations.isLoggingProfileAddress(LoggingOperations.getAddress(operation))) {
                configurationPersistence.writeConfiguration(context);
            }
        }

        public final AttributeDefinition[] getAttributes() {
            return this.attributes;
        }
    }

    static abstract class LoggingRemoveOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingRemoveOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            final ModelNode originalModel = model.clone();
            this.performRemove(context, operation, logContextConfiguration, name, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingRemoveOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                logContextConfiguration.forget();
                                try {
                                    LoggingRemoveOperationStepHandler.this.performRollback(context, operation, logContextConfiguration, name, originalModel);
                                    logContextConfiguration.commit();
                                }
                                catch (OperationFailedException e) {
                                    throw LoggingMessages.MESSAGES.rollbackFailure(e);
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        protected abstract void performRemove(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;

        protected abstract void performRollback(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }

    static abstract class LoggingUpdateOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingUpdateOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            final ModelNode originalModel = model.clone();
            this.updateModel(operation, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingUpdateOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                logContextConfiguration.forget();
                                try {
                                    LoggingUpdateOperationStepHandler.this.performRollback(context, operation, model, logContextConfiguration, name, originalModel);
                                    logContextConfiguration.commit();
                                }
                                catch (OperationFailedException e) {
                                    throw LoggingMessages.MESSAGES.rollbackFailure(e);
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        public abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;

        public abstract void performRollback(OperationContext var1, ModelNode var2, ModelNode var3, LogContextConfiguration var4, String var5, ModelNode var6) throws OperationFailedException;
    }

    static abstract class LoggingAddOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingAddOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            this.updateModel(operation, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingAddOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                logContextConfiguration.forget();
                                try {
                                    LoggingAddOperationStepHandler.this.performRollback(context, operation, logContextConfiguration, name);
                                    logContextConfiguration.commit();
                                }
                                catch (OperationFailedException e) {
                                    throw LoggingMessages.MESSAGES.rollbackFailure(e);
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        public abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;

        public abstract void performRollback(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4) throws OperationFailedException;
    }

    private static abstract class LoggingOperationStepHandler
    implements OperationStepHandler {
        private static final OperationContext.AttachmentKey<Boolean> ATTACHMENT_KEY = OperationContext.AttachmentKey.create(Boolean.class);

        private LoggingOperationStepHandler() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence;
            PathAddress address = LoggingOperations.getAddress(operation);
            String name = LoggingOperations.getAddressName(operation);
            boolean isLoggingProfile = LoggingProfileOperations.isLoggingProfileAddress(address);
            if (isLoggingProfile) {
                LogContext logContext = LoggingProfileContextSelector.getInstance().getOrCreate(LoggingProfileOperations.getLoggingProfileName(address));
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext);
            } else {
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
            }
            final LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            this.execute(context, operation, name, logContextConfiguration);
            if (context.getProcessType().isServer()) {
                if (isLoggingProfile) {
                    context.addStep(new OperationStepHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            try {
                                logContextConfiguration.commit();
                            }
                            finally {
                                logContextConfiguration.forget();
                            }
                            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                        }
                    }, OperationContext.Stage.RUNTIME);
                } else {
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            context.attachIfAbsent(ATTACHMENT_KEY, (Object)Boolean.TRUE);
                            context.addStep(new OperationStepHandler(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                    Boolean addCommit = (Boolean)context.getAttachment(ATTACHMENT_KEY);
                                    try {
                                        logContextConfiguration.commit();
                                    }
                                    finally {
                                        logContextConfiguration.forget();
                                    }
                                    if (addCommit != null && addCommit.booleanValue()) {
                                        configurationPersistence.writeConfiguration(context);
                                        context.detach(ATTACHMENT_KEY);
                                        context.completeStep(new OperationContext.RollbackHandler(){

                                            public void handleRollback(OperationContext context, ModelNode operation) {
                                                LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
                                                logContextConfiguration.forget();
                                                try {
                                                    configurationPersistence.writeConfiguration(context);
                                                }
                                                catch (OperationFailedException e) {
                                                    throw LoggingMessages.MESSAGES.rollbackFailure(e);
                                                }
                                            }
                                        });
                                    } else {
                                        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                                    }
                                }
                            }, OperationContext.Stage.RUNTIME);
                            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                        }
                    }, OperationContext.Stage.RUNTIME);
                }
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        public abstract void execute(OperationContext var1, ModelNode var2, String var3, LogContextConfiguration var4) throws OperationFailedException;
    }
}

