/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.LogContextConfiguration;

public class LoggingProfileOperations {
    static OperationStepHandler ADD_PROFILE = new AbstractAddStepHandler(){

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.setEmptyObject();
        }
    };
    static OperationStepHandler REMOVE_PROFILE = new AbstractRemoveStepHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ConfigurationPersistence configuration;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String loggingProfile = LoggingProfileOperations.getLoggingProfileName(address);
            LogContext logContext = LoggingProfileContextSelector.getInstance().remove(loggingProfile);
            if (logContext != null && (configuration = ConfigurationPersistence.getConfigurationPersistence(logContext)) != null) {
                LogContextConfiguration logContextConfiguration = configuration.getLogContextConfiguration();
                try {
                    for (String loggerName : logContextConfiguration.getLoggerNames()) {
                        logContextConfiguration.removeLoggerConfiguration(loggerName);
                    }
                    for (String handlerName : logContextConfiguration.getHandlerNames()) {
                        logContextConfiguration.removeHandlerConfiguration(handlerName);
                    }
                    for (String filterName : logContextConfiguration.getFilterNames()) {
                        logContextConfiguration.removeFilterConfiguration(filterName);
                    }
                    for (String formatterName : logContextConfiguration.getFormatterNames()) {
                        logContextConfiguration.removeFormatterConfiguration(formatterName);
                    }
                    for (String errorManager : logContextConfiguration.getErrorManagerNames()) {
                        logContextConfiguration.removeErrorManagerConfiguration(errorManager);
                    }
                    logContextConfiguration.commit();
                    context.reloadRequired();
                }
                finally {
                    logContextConfiguration.forget();
                }
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    };

    static boolean isLoggingProfileAddress(PathAddress address) {
        return LoggingProfileOperations.getLoggingProfileName(address) != null;
    }

    static String getLoggingProfileName(PathAddress address) {
        for (PathElement pathElement : address) {
            if (!"logging-profile".equals(pathElement.getKey())) continue;
            return pathElement.getValue();
        }
        return null;
    }
}

