/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.LoggingDeploymentUnitProcessor;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.msc.service.ServiceController;

class LoggingSubsystemAdd
extends AbstractAddStepHandler {
    static final LoggingSubsystemAdd INSTANCE = new LoggingSubsystemAdd();

    private LoggingSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("logging", Phase.POST_MODULE, 11008, (DeploymentUnitProcessor)LoggingDeploymentUnitProcessor.INSTANCE);
            }
        }, OperationContext.Stage.RUNTIME);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        LogContextConfiguration logContextConfiguration = ConfigurationPersistence.getOrCreateConfigurationPersistence().getLogContextConfiguration();
        try {
            if (!resource.hasChild(LoggingExtension.ROOT_LOGGER_PATH)) {
                LoggingLogger.ROOT_LOGGER.tracef("Removing the root logger configuration.", new Object[0]);
                logContextConfiguration.removeLoggerConfiguration("");
            }
            if (resource.hasChild(PathElement.pathElement((String)"logger"))) {
                Set loggerNames = resource.getChildrenNames("logger");
                List configuredLoggerNames = logContextConfiguration.getLoggerNames();
                configuredLoggerNames.remove("");
                configuredLoggerNames.removeAll(loggerNames);
                for (String name : configuredLoggerNames) {
                    LoggingLogger.ROOT_LOGGER.tracef("Removing logger configuration for '%s'", name);
                    logContextConfiguration.removeLoggerConfiguration(name);
                }
            }
            List configuredHandlerNames = logContextConfiguration.getHandlerNames();
            configuredHandlerNames.removeAll(resource.getChildrenNames("async-handler"));
            configuredHandlerNames.removeAll(resource.getChildrenNames("console-handler"));
            configuredHandlerNames.removeAll(resource.getChildrenNames("custom-handler"));
            configuredHandlerNames.removeAll(resource.getChildrenNames("file-handler"));
            configuredHandlerNames.removeAll(resource.getChildrenNames("periodic-rotating-file-handler"));
            configuredHandlerNames.removeAll(resource.getChildrenNames("size-rotating-file-handler"));
            for (String name : configuredHandlerNames) {
                LoggingLogger.ROOT_LOGGER.tracef("Removing handler configuration for '%s'", name);
                logContextConfiguration.removeHandlerConfiguration(name);
            }
            logContextConfiguration.commit();
            LoggingLogger.ROOT_LOGGER.trace("Logging subsystem has been added.");
        }
        finally {
            logContextConfiguration.forget();
        }
    }
}

