/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.util.Map;
import org.jboss.as.logging.logmanager.ConfigAction;
import org.jboss.as.logging.logmanager.LogContextConfigurationImpl;
import org.jboss.logmanager.config.NamedConfigurable;

abstract class AbstractBasicConfiguration<T, C extends AbstractBasicConfiguration<T, C>>
implements NamedConfigurable {
    private final LogContextConfigurationImpl configuration;
    private final String name;
    private boolean removed;
    protected final Map<String, T> refs;
    protected final Map<String, C> configs;

    AbstractBasicConfiguration(String name, LogContextConfigurationImpl configuration, Map<String, T> refs, Map<String, C> configs) {
        this.name = name;
        this.configuration = configuration;
        this.refs = refs;
        this.configs = configs;
    }

    public String getName() {
        return this.name;
    }

    void clearRemoved() {
        this.removed = false;
    }

    void setRemoved() {
        this.removed = true;
    }

    boolean isRemoved() {
        return this.removed;
    }

    LogContextConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    ConfigAction<Void> getRemoveAction() {
        return new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                AbstractBasicConfiguration.this.refs.remove(AbstractBasicConfiguration.this.name);
            }

            @Override
            public void applyPostCreate(Void param) {
            }

            @Override
            public void rollback() {
                AbstractBasicConfiguration.this.configs.put(AbstractBasicConfiguration.this.name, AbstractBasicConfiguration.this);
                AbstractBasicConfiguration.this.clearRemoved();
            }
        };
    }

    Map<String, T> getRefs() {
        return this.refs;
    }

    Map<String, C> getConfigs() {
        return this.configs;
    }
}

