/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import org.apache.log4j.Appender;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.logmanager.AbstractBasicConfiguration;
import org.jboss.as.logging.logmanager.ConfigAction;
import org.jboss.as.logging.logmanager.Log4jAppenderHandler;
import org.jboss.as.logging.logmanager.LogContextConfigurationImpl;
import org.jboss.as.logging.logmanager.ObjectProducer;
import org.jboss.logmanager.config.ObjectConfigurable;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

abstract class AbstractPropertyConfiguration<T, C extends AbstractPropertyConfiguration<T, C>>
extends AbstractBasicConfiguration<T, C>
implements ObjectConfigurable,
PropertyConfigurable {
    private final Class<? extends T> actualClass;
    private final Class<? extends Appender> appenderClass;
    private final String moduleName;
    private final String className;
    private final String[] constructorProperties;
    private final Map<String, String> properties = new LinkedHashMap<String, String>(0);

    protected AbstractPropertyConfiguration(Class<T> baseClass, LogContextConfigurationImpl configuration, Map<String, T> refs, Map<String, C> configs, String name, String moduleName, String className, String[] constructorProperties) {
        super(name, configuration, refs, configs);
        Class<T> actualClass;
        ClassLoader classLoader;
        if (className == null) {
            throw LoggingMessages.MESSAGES.nullVar("className");
        }
        this.constructorProperties = constructorProperties;
        if (moduleName != null) {
            try {
                classLoader = ModuleFinder.getClassLoader(moduleName);
            }
            catch (Throwable e) {
                throw LoggingMessages.MESSAGES.cannotLoadModule(e, moduleName, this.getDescription(), name);
            }
        } else {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> temp = Class.forName(className, true, classLoader);
            if (baseClass == Handler.class && Appender.class.isAssignableFrom(temp)) {
                actualClass = Log4jAppenderHandler.class.asSubclass(baseClass);
                this.appenderClass = temp.asSubclass(Appender.class);
            } else {
                actualClass = temp.asSubclass(baseClass);
                this.appenderClass = null;
            }
        }
        catch (Exception e) {
            throw LoggingMessages.MESSAGES.failedToLoadClass(e, className, this.getDescription(), name);
        }
        this.moduleName = moduleName;
        this.className = className;
        this.actualClass = actualClass;
    }

    ConfigAction<T> getConstructAction() {
        return new ConstructAction();
    }

    abstract String getDescription();

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    void activate() {
        if (this.isLog4jAppender()) {
            ((Log4jAppenderHandler)((Object)this.getRefs().get(this.getName()))).activate();
        }
    }

    boolean isLog4jAppender() {
        return this.actualClass == Log4jAppenderHandler.class;
    }

    static boolean contains(Object[] array, Object val) {
        for (Object o : array) {
            if (!o.equals(val)) continue;
            return true;
        }
        return false;
    }

    public void setPropertyValueString(final String propertyName, final String value) throws IllegalArgumentException {
        if (this.isRemoved()) {
            throw LoggingMessages.MESSAGES.cannotSetRemovedProperty(propertyName, this.getDescription(), this.getName());
        }
        if (propertyName == null) {
            throw LoggingMessages.MESSAGES.nullVar("propertyName");
        }
        final boolean replacement = this.properties.containsKey(propertyName);
        boolean constructorProp = AbstractPropertyConfiguration.contains(this.constructorProperties, propertyName);
        final Class<Object> useClass = this.appenderClass == null ? this.actualClass : this.appenderClass;
        final Method setter = AbstractPropertyConfiguration.getPropertySetter(useClass, propertyName);
        if (setter == null && !constructorProp) {
            throw LoggingMessages.MESSAGES.propertySetterNotFound(propertyName, this.getDescription(), this.getName());
        }
        final String oldValue = this.properties.put(propertyName, value);
        this.getConfiguration().addAction(new ConfigAction<ObjectProducer>(){

            @Override
            public ObjectProducer validate() throws IllegalArgumentException {
                if (setter == null) {
                    return ObjectProducer.NULL_PRODUCER;
                }
                Class<?> propertyType = AbstractPropertyConfiguration.getPropertyType(useClass, propertyName);
                if (propertyType == null) {
                    throw LoggingMessages.MESSAGES.propertyTypeNotFound(propertyName, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName());
                }
                return AbstractPropertyConfiguration.this.getConfiguration().getValue(useClass, propertyName, propertyType, value, false);
            }

            @Override
            public void applyPreCreate(ObjectProducer param) {
            }

            @Override
            public void applyPostCreate(ObjectProducer param) {
                if (setter != null) {
                    Object instance = AbstractPropertyConfiguration.this.getRefs().get(AbstractPropertyConfiguration.this.getName());
                    if (AbstractPropertyConfiguration.this.isLog4jAppender()) {
                        try {
                            setter.invoke((Object)((Log4jAppenderHandler)((Object)instance)).getAppender(), param.getObject());
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            setter.invoke(instance, param.getObject());
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void rollback() {
                if (replacement) {
                    AbstractPropertyConfiguration.this.properties.put(propertyName, oldValue);
                } else {
                    AbstractPropertyConfiguration.this.properties.remove(propertyName);
                }
            }
        });
    }

    public String getPropertyValueString(String propertyName) {
        return this.properties.get(propertyName);
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProperty(String propertyName) {
        if (this.isRemoved()) {
            throw LoggingMessages.MESSAGES.propertyAlreadyRemoved(propertyName, this.getDescription(), this.getName());
        }
        try {
            boolean bl = this.properties.containsKey(propertyName);
            return bl;
        }
        finally {
            this.properties.remove(propertyName);
        }
    }

    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public boolean hasConstructorProperty(String propertyName) {
        return AbstractPropertyConfiguration.contains(this.constructorProperties, propertyName);
    }

    Class<? extends T> getActualClass() {
        return this.actualClass;
    }

    public List<String> getConstructorProperties() {
        return Arrays.asList(this.constructorProperties);
    }

    static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        Method setter = AbstractPropertyConfiguration.getPropertySetter(clazz, propertyName);
        return setter != null ? setter.getParameterTypes()[0] : null;
    }

    static Class<?> getConstructorPropertyType(Class<?> clazz, String propertyName) {
        Method getter = AbstractPropertyConfiguration.getPropertyGetter(clazz, propertyName);
        return getter != null ? getter.getReturnType() : AbstractPropertyConfiguration.getPropertyType(clazz, propertyName);
    }

    static Method getPropertySetter(Class<?> clazz, String propertyName) {
        String upperPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String set = "set" + upperPropertyName;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(set) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    static Method getPropertyGetter(Class<?> clazz, String propertyName) {
        String upperPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String get = "get" + upperPropertyName;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(get) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    static class ModuleFinder {
        private ModuleFinder() {
        }

        static ClassLoader getClassLoader(String moduleName) throws Exception {
            ModuleLoader moduleLoader = ModuleLoader.forClass(ModuleFinder.class);
            if (moduleLoader == null) {
                moduleLoader = Module.getBootModuleLoader();
            }
            return moduleLoader.loadModule(ModuleIdentifier.create((String)moduleName)).getClassLoader();
        }
    }

    class ConstructAction
    implements ConfigAction<T> {
        ConstructAction() {
        }

        @Override
        public T validate() throws IllegalArgumentException {
            Constructor appenderConstructor;
            Constructor constructor;
            int length = AbstractPropertyConfiguration.this.constructorProperties.length;
            Class[] paramTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                String property = AbstractPropertyConfiguration.this.constructorProperties[i];
                Class<?> type = AbstractPropertyConfiguration.getConstructorPropertyType(AbstractPropertyConfiguration.this.actualClass, property);
                if (type == null) {
                    throw LoggingMessages.MESSAGES.invalidProperty(property, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName(), AbstractPropertyConfiguration.this.appenderClass);
                }
                paramTypes[i] = type;
            }
            try {
                if (AbstractPropertyConfiguration.this.appenderClass != null) {
                    constructor = AbstractPropertyConfiguration.this.actualClass.getConstructor(Appender.class);
                    appenderConstructor = AbstractPropertyConfiguration.this.appenderClass.getConstructor(paramTypes);
                } else {
                    constructor = AbstractPropertyConfiguration.this.actualClass.getConstructor(paramTypes);
                    appenderConstructor = null;
                }
            }
            catch (Exception e) {
                throw LoggingMessages.MESSAGES.failedToLocateConstructor(e, AbstractPropertyConfiguration.this.className, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName());
            }
            Object[] params = new Object[length];
            Class c = AbstractPropertyConfiguration.this.appenderClass == null ? AbstractPropertyConfiguration.this.actualClass : AbstractPropertyConfiguration.this.appenderClass;
            for (int i = 0; i < length; ++i) {
                Object value;
                String property = AbstractPropertyConfiguration.this.constructorProperties[i];
                if (!AbstractPropertyConfiguration.this.properties.containsKey(property)) {
                    throw LoggingMessages.MESSAGES.invalidProperty(property, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName(), c);
                }
                String valueString = (String)AbstractPropertyConfiguration.this.properties.get(property);
                params[i] = value = AbstractPropertyConfiguration.this.getConfiguration().getValue(c, property, paramTypes[i], valueString, true).getObject();
            }
            try {
                if (appenderConstructor != null) {
                    AbstractPropertyConfiguration.this.getConfiguration().addAppenderName(AbstractPropertyConfiguration.this.getName());
                    return constructor.newInstance(appenderConstructor.newInstance(params));
                }
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw LoggingMessages.MESSAGES.cannotInstantiateClass(e, AbstractPropertyConfiguration.this.className, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName());
            }
        }

        @Override
        public void applyPreCreate(T param) {
            AbstractPropertyConfiguration.this.getRefs().put(AbstractPropertyConfiguration.this.getName(), param);
        }

        @Override
        public void applyPostCreate(T param) {
        }

        @Override
        public void rollback() {
            AbstractPropertyConfiguration.this.getConfigs().remove(AbstractPropertyConfiguration.this.getName());
        }
    }
}

