/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.logmanager.ConfigAction;
import org.jboss.as.logging.logmanager.ErrorManagerConfigurationImpl;
import org.jboss.as.logging.logmanager.FilterConfigurationImpl;
import org.jboss.as.logging.logmanager.FormatterConfigurationImpl;
import org.jboss.as.logging.logmanager.HandlerConfigurationImpl;
import org.jboss.as.logging.logmanager.LoggerConfigurationImpl;
import org.jboss.as.logging.logmanager.ObjectProducer;
import org.jboss.as.logging.logmanager.PropertyHelper;
import org.jboss.as.logging.logmanager.RefProducer;
import org.jboss.as.logging.logmanager.SimpleObjectProducer;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.filters.AnyFilter;
import org.jboss.logmanager.filters.DenyAllFilter;
import org.jboss.logmanager.filters.InvertFilter;
import org.jboss.logmanager.filters.LevelChangingFilter;
import org.jboss.logmanager.filters.LevelFilter;
import org.jboss.logmanager.filters.LevelRangeFilter;
import org.jboss.logmanager.filters.RegexFilter;
import org.jboss.logmanager.filters.SubstituteFilter;

final class LogContextConfigurationImpl
implements LogContextConfiguration {
    private final LogContext logContext;
    private final Map<String, LoggerConfigurationImpl> loggers = new HashMap<String, LoggerConfigurationImpl>();
    private final Map<String, HandlerConfigurationImpl> handlers = new HashMap<String, HandlerConfigurationImpl>();
    private final Map<String, FormatterConfigurationImpl> formatters = new HashMap<String, FormatterConfigurationImpl>();
    private final Map<String, FilterConfigurationImpl> filters = new HashMap<String, FilterConfigurationImpl>();
    private final Map<String, ErrorManagerConfigurationImpl> errorManagers = new HashMap<String, ErrorManagerConfigurationImpl>();
    private final Map<String, Logger> loggerRefs = new HashMap<String, Logger>();
    private final Map<String, Handler> handlerRefs = new HashMap<String, Handler>();
    private final Map<String, Filter> filterRefs = new HashMap<String, Filter>();
    private final Map<String, Formatter> formatterRefs = new HashMap<String, Formatter>();
    private final Map<String, ErrorManager> errorManagerRefs = new HashMap<String, ErrorManager>();
    private final Deque<ConfigAction<?>> transactionState = new ArrayDeque();
    private final Set<String> log4jAppendersName = new HashSet<String>();
    private static final ObjectProducer ACCEPT_PRODUCER = new SimpleObjectProducer(AcceptAllFilter.getInstance());
    private static final ObjectProducer DENY_PRODUCER = new SimpleObjectProducer(DenyAllFilter.getInstance());

    LogContextConfigurationImpl(LogContext logContext) {
        this.logContext = logContext;
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public LoggerConfiguration addLoggerConfiguration(final String loggerName) {
        if (this.loggers.containsKey(loggerName)) {
            throw LoggingMessages.MESSAGES.loggerAlreadyExists(loggerName);
        }
        LoggerConfigurationImpl loggerConfiguration = new LoggerConfigurationImpl(loggerName, this);
        this.loggers.put(loggerName, loggerConfiguration);
        this.transactionState.addLast(new ConfigAction<Logger>(){

            @Override
            public Logger validate() throws IllegalArgumentException {
                return LogContextConfigurationImpl.this.logContext.getLogger(loggerName);
            }

            @Override
            public void applyPreCreate(Logger param) {
                LogContextConfigurationImpl.this.loggerRefs.put(loggerName, param);
            }

            @Override
            public void applyPostCreate(Logger param) {
            }

            @Override
            public void rollback() {
                LogContextConfigurationImpl.this.loggers.remove(loggerName);
            }
        });
        return loggerConfiguration;
    }

    public boolean removeLoggerConfiguration(String loggerName) {
        LoggerConfigurationImpl removed = this.loggers.remove(loggerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        return this.loggers.get(loggerName);
    }

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public HandlerConfiguration addHandlerConfiguration(String moduleName, String className, String handlerName, String ... constructorProperties) {
        if (this.handlers.containsKey(handlerName)) {
            throw new IllegalArgumentException(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
        }
        HandlerConfigurationImpl handlerConfiguration = new HandlerConfigurationImpl(this, handlerName, moduleName, className, constructorProperties);
        this.handlers.put(handlerName, handlerConfiguration);
        this.addAction(handlerConfiguration.getConstructAction());
        return handlerConfiguration;
    }

    public boolean removeHandlerConfiguration(String handlerName) {
        HandlerConfigurationImpl removed = this.handlers.remove(handlerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    public HandlerConfiguration getHandlerConfiguration(String handlerName) {
        return this.handlers.get(handlerName);
    }

    public List<String> getHandlerNames() {
        return new ArrayList<String>(this.handlers.keySet());
    }

    public FormatterConfiguration addFormatterConfiguration(String moduleName, String className, String formatterName, String ... constructorProperties) {
        if (this.formatters.containsKey(formatterName)) {
            throw LoggingMessages.MESSAGES.formatterAlreadyExists(formatterName);
        }
        FormatterConfigurationImpl formatterConfiguration = new FormatterConfigurationImpl(this, formatterName, moduleName, className, constructorProperties);
        this.formatters.put(formatterName, formatterConfiguration);
        this.addAction(formatterConfiguration.getConstructAction());
        return formatterConfiguration;
    }

    public boolean removeFormatterConfiguration(String formatterName) {
        FormatterConfigurationImpl removed = this.formatters.remove(formatterName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    public FormatterConfiguration getFormatterConfiguration(String formatterName) {
        return this.formatters.get(formatterName);
    }

    public List<String> getFormatterNames() {
        return new ArrayList<String>(this.formatters.keySet());
    }

    public FilterConfiguration addFilterConfiguration(String moduleName, String className, String filterName, String ... constructorProperties) {
        if (this.filters.containsKey(filterName)) {
            throw LoggingMessages.MESSAGES.filterAlreadyExists(filterName);
        }
        FilterConfigurationImpl filterConfiguration = new FilterConfigurationImpl(this, filterName, moduleName, className, constructorProperties);
        this.filters.put(filterName, filterConfiguration);
        this.addAction(filterConfiguration.getConstructAction());
        return filterConfiguration;
    }

    public boolean removeFilterConfiguration(String filterName) {
        FilterConfigurationImpl removed = this.filters.remove(filterName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    public FilterConfiguration getFilterConfiguration(String filterName) {
        return this.filters.get(filterName);
    }

    public List<String> getFilterNames() {
        return new ArrayList<String>(this.filters.keySet());
    }

    public ErrorManagerConfiguration addErrorManagerConfiguration(String moduleName, String className, String errorManagerName, String ... constructorProperties) {
        if (this.errorManagers.containsKey(errorManagerName)) {
            throw LoggingMessages.MESSAGES.errorManagerAlreadyExists(errorManagerName);
        }
        ErrorManagerConfigurationImpl errorManagerConfiguration = new ErrorManagerConfigurationImpl(this, errorManagerName, moduleName, className, constructorProperties);
        this.errorManagers.put(errorManagerName, errorManagerConfiguration);
        this.addAction(errorManagerConfiguration.getConstructAction());
        return errorManagerConfiguration;
    }

    public boolean removeErrorManagerConfiguration(String errorManagerName) {
        ErrorManagerConfigurationImpl removed = this.errorManagers.remove(errorManagerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    public ErrorManagerConfiguration getErrorManagerConfiguration(String errorManagerName) {
        return this.errorManagers.get(errorManagerName);
    }

    public List<String> getErrorManagerNames() {
        return new ArrayList<String>(this.errorManagers.keySet());
    }

    public void commit() {
        ArrayList items = new ArrayList();
        for (ConfigAction<?> action : this.transactionState) {
            items.add(action.validate());
        }
        Iterator iterator = items.iterator();
        for (ConfigAction<?> action : this.transactionState) {
            LogContextConfigurationImpl.doApplyPreCreate(action, iterator.next());
        }
        iterator = items.iterator();
        for (ConfigAction<?> action : this.transactionState) {
            LogContextConfigurationImpl.doApplyPostCreate(action, iterator.next());
        }
        for (String name : this.log4jAppendersName) {
            this.handlers.get(name).activate();
        }
        this.log4jAppendersName.clear();
        this.transactionState.clear();
    }

    private static <T> void doApplyPreCreate(ConfigAction<T> action, Object arg) {
        try {
            action.applyPreCreate(arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static <T> void doApplyPostCreate(ConfigAction<T> action, Object arg) {
        try {
            action.applyPostCreate(arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void forget() {
        Iterator<ConfigAction<?>> iterator = this.transactionState.descendingIterator();
        while (iterator.hasNext()) {
            ConfigAction<?> action = iterator.next();
            try {
                action.rollback();
            }
            catch (Throwable throwable) {}
        }
        this.log4jAppendersName.clear();
        this.transactionState.clear();
    }

    void addAction(ConfigAction<?> action) {
        this.transactionState.addLast(action);
    }

    void addAppenderName(String name) {
        this.log4jAppendersName.add(name);
    }

    ObjectProducer getValue(Class<?> objClass, String propertyName, Class<?> paramType, String valueString, boolean immediate) {
        String replaced = PropertyHelper.resolveValue(valueString);
        if (valueString == null) {
            if (paramType.isPrimitive()) {
                throw LoggingMessages.MESSAGES.cannotAssignNullToPrimitive(propertyName, objClass);
            }
            return ObjectProducer.NULL_PRODUCER;
        }
        if (paramType == String.class) {
            return new SimpleObjectProducer(replaced);
        }
        if (paramType == Handler.class) {
            if (!this.handlers.containsKey(replaced) || immediate && !this.handlerRefs.containsKey(replaced)) {
                throw LoggingMessages.MESSAGES.handlerNotFound(replaced);
            }
            if (immediate) {
                return new SimpleObjectProducer(this.handlerRefs.get(replaced));
            }
            return new RefProducer(replaced, this.handlerRefs);
        }
        if (paramType == Filter.class) {
            return this.parseFilterExpression(replaced, immediate);
        }
        if (paramType == Formatter.class) {
            if (!this.formatters.containsKey(replaced) || immediate && !this.formatterRefs.containsKey(replaced)) {
                throw LoggingMessages.MESSAGES.formatterNotFound(replaced);
            }
            if (immediate) {
                return new SimpleObjectProducer(this.formatterRefs.get(replaced));
            }
            return new RefProducer(replaced, this.formatterRefs);
        }
        if (paramType == ErrorManager.class) {
            if (!this.errorManagers.containsKey(replaced) || immediate && !this.errorManagerRefs.containsKey(replaced)) {
                throw LoggingMessages.MESSAGES.errorManagerNotFound(replaced);
            }
            if (immediate) {
                return new SimpleObjectProducer(this.errorManagerRefs.get(replaced));
            }
            return new RefProducer(replaced, this.errorManagerRefs);
        }
        if (paramType == Level.class) {
            return new SimpleObjectProducer(LogContext.getSystemLogContext().getLevelForName(replaced));
        }
        if (paramType == java.util.logging.Logger.class) {
            return new SimpleObjectProducer(LogContext.getSystemLogContext().getLogger(replaced));
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return new SimpleObjectProducer(Boolean.valueOf(replaced));
        }
        if (paramType == Byte.TYPE || paramType == Byte.class) {
            return new SimpleObjectProducer(Byte.valueOf(replaced));
        }
        if (paramType == Short.TYPE || paramType == Short.class) {
            return new SimpleObjectProducer(Short.valueOf(replaced));
        }
        if (paramType == Integer.TYPE || paramType == Integer.class) {
            return new SimpleObjectProducer(Integer.valueOf(replaced));
        }
        if (paramType == Long.TYPE || paramType == Long.class) {
            return new SimpleObjectProducer(Long.valueOf(replaced));
        }
        if (paramType == Float.TYPE || paramType == Float.class) {
            return new SimpleObjectProducer(Float.valueOf(replaced));
        }
        if (paramType == Double.TYPE || paramType == Double.class) {
            return new SimpleObjectProducer(Double.valueOf(replaced));
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return new SimpleObjectProducer(Character.valueOf(replaced.length() > 0 ? replaced.charAt(0) : (char)'\u0000'));
        }
        if (paramType == TimeZone.class) {
            return new SimpleObjectProducer(TimeZone.getTimeZone(replaced));
        }
        if (paramType == Charset.class) {
            return new SimpleObjectProducer(Charset.forName(replaced));
        }
        if (paramType.isEnum()) {
            return new SimpleObjectProducer(Enum.valueOf(paramType.asSubclass(Enum.class), replaced));
        }
        throw LoggingMessages.MESSAGES.unknownParameterType(paramType, propertyName, objClass);
    }

    Map<String, Filter> getFilterRefs() {
        return this.filterRefs;
    }

    Map<String, FilterConfigurationImpl> getFilterConfigurations() {
        return this.filters;
    }

    Map<String, ErrorManager> getErrorManagerRefs() {
        return this.errorManagerRefs;
    }

    Map<String, ErrorManagerConfigurationImpl> getErrorManagerConfigurations() {
        return this.errorManagers;
    }

    Map<String, Handler> getHandlerRefs() {
        return this.handlerRefs;
    }

    Map<String, HandlerConfigurationImpl> getHandlerConfigurations() {
        return this.handlers;
    }

    Map<String, Formatter> getFormatterRefs() {
        return this.formatterRefs;
    }

    Map<String, FormatterConfigurationImpl> getFormatterConfigurations() {
        return this.formatters;
    }

    Map<String, Logger> getLoggerRefs() {
        return this.loggerRefs;
    }

    Map<String, LoggerConfigurationImpl> getLoggerConfigurations() {
        return this.loggers;
    }

    private static List<String> tokens(String source) {
        ArrayList<String> tokens = new ArrayList<String>();
        int length = source.length();
        int idx = 0;
        while (idx < length) {
            int start;
            block16: {
                int ch = source.codePointAt(idx);
                if (Character.isWhitespace(ch)) {
                    ch = source.codePointAt(idx);
                    idx = source.offsetByCodePoints(idx, 1);
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    start = idx;
                    while ((idx = source.offsetByCodePoints(idx, 1)) < length && Character.isJavaIdentifierPart(ch = source.codePointAt(idx))) {
                    }
                    tokens.add(source.substring(start, idx));
                    continue;
                }
                if (ch != 34) break block16;
                StringBuilder b = new StringBuilder();
                b.append('\"');
                idx = source.offsetByCodePoints(idx, 1);
                while (idx < length && (ch = source.codePointAt(idx)) != 34) {
                    block18: {
                        block17: {
                            ch = source.codePointAt(idx);
                            if (ch != 92) break block17;
                            if ((idx = source.offsetByCodePoints(idx, 1)) == length) {
                                throw LoggingMessages.MESSAGES.truncatedFilterExpression();
                            }
                            ch = source.codePointAt(idx);
                            switch (ch) {
                                case 92: {
                                    b.append('\\');
                                    break block18;
                                }
                                case 39: {
                                    b.append('\'');
                                    break block18;
                                }
                                case 34: {
                                    b.append('\"');
                                    break block18;
                                }
                                case 98: {
                                    b.append('\b');
                                    break block18;
                                }
                                case 102: {
                                    b.append('\f');
                                    break block18;
                                }
                                case 110: {
                                    b.append('\n');
                                    break block18;
                                }
                                case 114: {
                                    b.append('\r');
                                    break block18;
                                }
                                case 116: {
                                    b.append('\t');
                                    break block18;
                                }
                                default: {
                                    throw LoggingMessages.MESSAGES.invalidEscapeFoundInFilterExpression();
                                }
                            }
                        }
                        b.appendCodePoint(ch);
                    }
                    idx = source.offsetByCodePoints(idx, 1);
                }
                idx = source.offsetByCodePoints(idx, 1);
                tokens.add(b.toString());
                continue;
            }
            start = idx;
            idx = source.offsetByCodePoints(idx, 1);
            tokens.add(source.substring(start, idx));
        }
        return tokens;
    }

    private ObjectProducer parseFilterExpression(Iterator<String> iterator, boolean outermost, boolean immediate) {
        if (!iterator.hasNext()) {
            if (outermost) {
                return ObjectProducer.NULL_PRODUCER;
            }
            throw LoggingMessages.MESSAGES.unexpectedEnd();
        }
        String token = iterator.next();
        if ("accept".equals(token)) {
            return ACCEPT_PRODUCER;
        }
        if ("deny".equals(token)) {
            return DENY_PRODUCER;
        }
        if ("not".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            final ObjectProducer nested = this.parseFilterExpression(iterator, false, immediate);
            LogContextConfigurationImpl.expect(")", iterator);
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    return new InvertFilter((Filter)nested.getObject());
                }
            };
        }
        if ("all".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            final ArrayList<ObjectProducer> producers = new ArrayList<ObjectProducer>();
            do {
                producers.add(this.parseFilterExpression(iterator, false, immediate));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator));
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    int length = producers.size();
                    Filter[] filters = new Filter[length];
                    for (int i = 0; i < length; ++i) {
                        filters[i] = (Filter)((ObjectProducer)producers.get(i)).getObject();
                    }
                    return new AllFilter(filters);
                }
            };
        }
        if ("any".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            final ArrayList<ObjectProducer> producers = new ArrayList<ObjectProducer>();
            do {
                producers.add(this.parseFilterExpression(iterator, false, immediate));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator));
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    int length = producers.size();
                    Filter[] filters = new Filter[length];
                    for (int i = 0; i < length; ++i) {
                        filters[i] = (Filter)((ObjectProducer)producers.get(i)).getObject();
                    }
                    return new AnyFilter(filters);
                }
            };
        }
        if ("levelChange".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            String levelName = LogContextConfigurationImpl.expectName(iterator);
            Level level = this.logContext.getLevelForName(levelName);
            LogContextConfigurationImpl.expect(")", iterator);
            return new SimpleObjectProducer(new LevelChangingFilter(level));
        }
        if ("levels".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            HashSet<Level> levels = new HashSet<Level>();
            do {
                levels.add(this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator)));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator));
            return new SimpleObjectProducer(new LevelFilter(levels));
        }
        if ("levelRange".equals(token)) {
            boolean minInclusive = LogContextConfigurationImpl.expect("[", "(", iterator);
            Level minLevel = this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator));
            LogContextConfigurationImpl.expect(",", iterator);
            Level maxLevel = this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator));
            boolean maxInclusive = LogContextConfigurationImpl.expect("]", ")", iterator);
            return new SimpleObjectProducer(new LevelRangeFilter(minLevel, minInclusive, maxLevel, maxInclusive));
        }
        if ("match".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            String pattern = LogContextConfigurationImpl.expectString(iterator);
            LogContextConfigurationImpl.expect(")", iterator);
            return new SimpleObjectProducer(new RegexFilter(pattern));
        }
        if ("substitute".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            String pattern = LogContextConfigurationImpl.expectString(iterator);
            LogContextConfigurationImpl.expect(",", iterator);
            String replacement = LogContextConfigurationImpl.expectString(iterator);
            LogContextConfigurationImpl.expect(")", iterator);
            return new SimpleObjectProducer(new SubstituteFilter(pattern, replacement, false));
        }
        if ("substituteAll".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator);
            String pattern = LogContextConfigurationImpl.expectString(iterator);
            LogContextConfigurationImpl.expect(",", iterator);
            String replacement = LogContextConfigurationImpl.expectString(iterator);
            LogContextConfigurationImpl.expect(")", iterator);
            return new SimpleObjectProducer(new SubstituteFilter(pattern, replacement, true));
        }
        String name = LogContextConfigurationImpl.expectName(iterator);
        if (!this.filters.containsKey(name) || immediate && !this.filterRefs.containsKey(name)) {
            throw LoggingMessages.MESSAGES.filterNotFound(name);
        }
        if (immediate) {
            return new SimpleObjectProducer(this.filterRefs.get(name));
        }
        return new RefProducer(name, this.filterRefs);
    }

    private static String expectName(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && Character.isJavaIdentifierStart((next = iterator.next()).codePointAt(0))) {
            return next;
        }
        throw LoggingMessages.MESSAGES.expectedIdentifier();
    }

    private static String expectString(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && (next = iterator.next()).codePointAt(0) == 34) {
            return next.substring(1);
        }
        throw LoggingMessages.MESSAGES.expectedString();
    }

    private static boolean expect(String trueToken, String falseToken, Iterator<String> iterator) {
        boolean result;
        String next;
        boolean hasNext = iterator.hasNext();
        String string = next = hasNext ? iterator.next() : null;
        if (!hasNext || !(result = trueToken.equals(next)) && !falseToken.equals(next)) {
            throw LoggingMessages.MESSAGES.expected(trueToken, falseToken);
        }
        return result;
    }

    private static void expect(String token, Iterator<String> iterator) {
        if (!iterator.hasNext() || !token.equals(iterator.next())) {
            throw LoggingMessages.MESSAGES.expected(token);
        }
    }

    private ObjectProducer parseFilterExpression(String expression, boolean immediate) {
        if (expression == null) {
            return ObjectProducer.NULL_PRODUCER;
        }
        Iterator<String> iterator = LogContextConfigurationImpl.tokens(expression).iterator();
        ObjectProducer result = this.parseFilterExpression(iterator, true, immediate);
        if (iterator.hasNext()) {
            throw LoggingMessages.MESSAGES.extraData();
        }
        return result;
    }

    ObjectProducer parseFilterExpression(String expression) {
        return this.parseFilterExpression(expression, false);
    }
}

