/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.resolvers;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.resolvers.LevelResolver;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;

public class FilterResolver
implements ModelNodeResolver<String> {
    public static final FilterResolver INSTANCE = new FilterResolver();

    private FilterResolver() {
    }

    @Override
    public String resolveValue(OperationContext context, ModelNode value) throws OperationFailedException {
        if (!value.isDefined()) {
            return null;
        }
        if (value.hasDefined(CommonAttributes.ACCEPT.getName())) {
            return "accept";
        }
        if (value.hasDefined(CommonAttributes.ALL.getName())) {
            StringBuilder result = new StringBuilder("all(");
            boolean add = false;
            for (ModelNode filterValue : value.get(CommonAttributes.ALL.getName()).asList()) {
                if (add) {
                    result.append(",");
                } else {
                    add = true;
                }
                result.append(this.resolveValue(context, filterValue));
            }
            return result.append(")").toString();
        }
        if (value.hasDefined(CommonAttributes.ANY.getName())) {
            StringBuilder result = new StringBuilder("any(");
            boolean add = false;
            for (ModelNode filterValue : value.get(CommonAttributes.ANY.getName()).asList()) {
                if (add) {
                    result.append(",");
                } else {
                    add = true;
                }
                result.append(this.resolveValue(context, filterValue));
            }
            return result.append(")").toString();
        }
        if (value.hasDefined(CommonAttributes.CHANGE_LEVEL.getName())) {
            return String.format("levelChange(%s)", LevelResolver.INSTANCE.resolveValue(context, CommonAttributes.CHANGE_LEVEL.resolveModelAttribute(context, value)));
        }
        if (value.hasDefined(CommonAttributes.DENY.getName())) {
            return "deny";
        }
        if (value.hasDefined(CommonAttributes.LEVEL.getName())) {
            return String.format("levels(%s)", LevelResolver.INSTANCE.resolveValue(context, CommonAttributes.LEVEL.resolveModelAttribute(context, value)));
        }
        if (value.hasDefined(CommonAttributes.LEVEL_RANGE.getName())) {
            ModelNode levelRange = CommonAttributes.LEVEL_RANGE.resolveModelAttribute(context, value);
            StringBuilder result = new StringBuilder("levelRange");
            boolean minInclusive = CommonAttributes.MIN_INCLUSIVE.resolveModelAttribute(context, levelRange).asBoolean();
            boolean maxInclusive = CommonAttributes.MAX_INCLUSIVE.resolveModelAttribute(context, levelRange).asBoolean();
            if (minInclusive) {
                result.append("[");
            } else {
                result.append("(");
            }
            result.append(LevelResolver.INSTANCE.resolveValue(context, CommonAttributes.MIN_LEVEL.resolveModelAttribute(context, levelRange))).append(",");
            result.append(LevelResolver.INSTANCE.resolveValue(context, CommonAttributes.MAX_LEVEL.resolveModelAttribute(context, levelRange)));
            if (maxInclusive) {
                result.append("]");
            } else {
                result.append(")");
            }
            return result.toString();
        }
        if (value.hasDefined(CommonAttributes.MATCH.getName())) {
            return String.format("match(%s)", FilterResolver.escapeString(context, (AttributeDefinition)CommonAttributes.MATCH, value));
        }
        if (value.hasDefined(CommonAttributes.NOT.getName())) {
            return String.format("not(%s)", this.resolveValue(context, CommonAttributes.NOT.resolveModelAttribute(context, value)));
        }
        if (value.hasDefined(CommonAttributes.REPLACE.getName())) {
            ModelNode replace = CommonAttributes.REPLACE.resolveModelAttribute(context, value);
            boolean replaceAll = CommonAttributes.REPLACE_ALL.resolveModelAttribute(context, replace).asBoolean();
            StringBuilder result = new StringBuilder("substitute");
            if (replaceAll) {
                result.append("All");
            }
            return result.append("(").append(FilterResolver.escapeString(context, (AttributeDefinition)CommonAttributes.PATTERN, replace)).append(",").append(FilterResolver.escapeString(context, (AttributeDefinition)CommonAttributes.REPLACEMENT, replace)).append(")").toString();
        }
        String name = value.hasDefined(CommonAttributes.FILTER.getName()) ? value.get(CommonAttributes.FILTER.getName()).asString() : value.asString();
        throw Logging.createOperationFailure(LoggingMessages.MESSAGES.invalidFilter(name));
    }

    private static String escapeString(OperationContext context, AttributeDefinition attribute, ModelNode value) throws OperationFailedException {
        return "\"" + attribute.resolveModelAttribute(context, value).asString() + "\"";
    }
}

