/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.scanner.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.DeploymentScannerLogger;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;

class DeploymentScannerAdd
implements OperationStepHandler {
    private final PathManager pathManager;

    public DeploymentScannerAdd(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        this.populateModel(context, operation, resource);
        final ModelNode model = resource.getModel();
        boolean stepCompleted = false;
        if (context.isNormalServer()) {
            FileSystemDeploymentService bootTimeScanner;
            Boolean enabled = DeploymentScannerDefinition.SCAN_ENABLED.resolveModelAttribute(context, operation).asBoolean();
            boolean bootTimeScan = context.isBooting() && (enabled == null || enabled == true);
            String path = DeploymentScannerDefinition.PATH.resolveModelAttribute(context, operation).asString();
            ModelNode relativeToNode = DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, operation);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            Boolean autoDeployZip = DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.resolveModelAttribute(context, operation).asBoolean();
            Boolean autoDeployExp = DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.resolveModelAttribute(context, operation).asBoolean();
            Boolean autoDeployXml = DeploymentScannerDefinition.AUTO_DEPLOY_XML.resolveModelAttribute(context, operation).asBoolean();
            Long deploymentTimeout = DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.resolveModelAttribute(context, operation).asLong();
            Integer scanInterval = DeploymentScannerDefinition.SCAN_INTERVAL.resolveModelAttribute(context, operation).asInt();
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("DeploymentScanner-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory);
            if (bootTimeScan) {
                String pathName = this.pathManager.resolveRelativePathEntry(path, relativeTo);
                File relativePath = null;
                if (relativeTo != null) {
                    relativePath = new File(this.pathManager.getPathEntry(relativeTo).resolvePath());
                }
                bootTimeScanner = new FileSystemDeploymentService(relativeTo, new File(pathName), relativePath, null, scheduledExecutorService);
                bootTimeScanner.setAutoDeployExplodedContent(autoDeployExp);
                bootTimeScanner.setAutoDeployZippedContent(autoDeployZip);
                bootTimeScanner.setAutoDeployXMLContent(autoDeployXml);
                if (deploymentTimeout != null) {
                    bootTimeScanner.setDeploymentTimeout(deploymentTimeout);
                }
                if (scanInterval != null) {
                    bootTimeScanner.setScanInterval(scanInterval.intValue());
                }
            } else {
                bootTimeScanner = null;
            }
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    DeploymentScannerAdd.this.performRuntime(context, operation, model, verificationHandler, controllers, scheduledExecutorService, bootTimeScanner);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            DeploymentScannerAdd.this.rollbackRuntime(context, operation, model, controllers);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            if (bootTimeScan) {
                AtomicReference<ModelNode> deploymentOperation = new AtomicReference<ModelNode>();
                final AtomicReference<ModelNode> deploymentResults = new AtomicReference<ModelNode>(new ModelNode());
                final CountDownLatch scanDoneLatch = new CountDownLatch(1);
                final CountDownLatch deploymentDoneLatch = new CountDownLatch(1);
                final BootTimeScannerDeployment deploymentOps = new BootTimeScannerDeployment(deploymentOperation, deploymentDoneLatch, deploymentResults, scanDoneLatch);
                scheduledExecutorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            bootTimeScanner.oneOffScan(deploymentOps);
                        }
                        catch (Throwable t) {
                            DeploymentScannerLogger.ROOT_LOGGER.initialScanFailed(t);
                        }
                        finally {
                            scanDoneLatch.countDown();
                        }
                    }
                });
                boolean interrupted = false;
                boolean asyncCountDown = false;
                try {
                    scanDoneLatch.await();
                    ModelNode op = deploymentOperation.get();
                    if (op != null) {
                        final ModelNode result = new ModelNode();
                        PathAddress opPath = PathAddress.pathAddress((ModelNode)op.get("address"));
                        OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(opPath, op.get("operation").asString());
                        context.addStep(result, op, handler, OperationContext.Stage.MODEL);
                        stepCompleted = true;
                        context.completeStep(new OperationContext.ResultHandler(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                try {
                                    deploymentResults.set(result);
                                }
                                finally {
                                    deploymentDoneLatch.countDown();
                                }
                            }
                        });
                        asyncCountDown = true;
                    } else {
                        stepCompleted = true;
                        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    throw new RuntimeException(e);
                }
                finally {
                    if (!asyncCountDown) {
                        deploymentDoneLatch.countDown();
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (!stepCompleted) {
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (SimpleAttributeDefinition atr : DeploymentScannerDefinition.ALL_ATTRIBUTES) {
            atr.validateAndSet(operation, resource.getModel());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, ScheduledExecutorService executorService, FileSystemDeploymentService bootTimeScanner) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String path = DeploymentScannerDefinition.PATH.resolveModelAttribute(context, operation).asString();
        Boolean enabled = DeploymentScannerDefinition.SCAN_ENABLED.resolveModelAttribute(context, operation).asBoolean();
        Integer interval = DeploymentScannerDefinition.SCAN_INTERVAL.resolveModelAttribute(context, operation).asInt();
        String relativeTo = operation.hasDefined("relative-to") ? DeploymentScannerDefinition.RELATIVE_TO.resolveModelAttribute(context, operation).asString() : null;
        Boolean autoDeployZip = DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.resolveModelAttribute(context, operation).asBoolean();
        Boolean autoDeployExp = DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.resolveModelAttribute(context, operation).asBoolean();
        Boolean autoDeployXml = DeploymentScannerDefinition.AUTO_DEPLOY_XML.resolveModelAttribute(context, operation).asBoolean();
        Long deploymentTimeout = DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.resolveModelAttribute(context, operation).asLong();
        ServiceTarget serviceTarget = context.getServiceTarget();
        DeploymentScannerService.addService(serviceTarget, name, relativeTo, path, interval, TimeUnit.MILLISECONDS, autoDeployZip, autoDeployExp, autoDeployXml, enabled, deploymentTimeout, newControllers, bootTimeScanner, executorService, new ServiceListener[]{verificationHandler});
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        for (ServiceController<?> controller : controllers) {
            context.removeService(controller.getName());
        }
    }

    private static class BootTimeScannerDeployment
    implements DeploymentOperations {
        private final AtomicReference<ModelNode> deploymentOperation;
        private final CountDownLatch deploymentDoneLatch;
        private final AtomicReference<ModelNode> deploymentResults;
        private final CountDownLatch scanDoneLatch;

        public BootTimeScannerDeployment(AtomicReference<ModelNode> deploymentOperation, CountDownLatch deploymentDoneLatch, AtomicReference<ModelNode> deploymentResults, CountDownLatch scanDoneLatch) {
            this.deploymentOperation = deploymentOperation;
            this.deploymentDoneLatch = deploymentDoneLatch;
            this.deploymentResults = deploymentResults;
            this.scanDoneLatch = scanDoneLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Future<ModelNode> deploy(ModelNode operation, ScheduledExecutorService scheduledExecutor) {
            try {
                this.deploymentOperation.set(operation);
                FutureTask<ModelNode> task = new FutureTask<ModelNode>(new Callable<ModelNode>(){

                    @Override
                    public ModelNode call() throws Exception {
                        BootTimeScannerDeployment.this.deploymentDoneLatch.await();
                        return (ModelNode)BootTimeScannerDeployment.this.deploymentResults.get();
                    }
                });
                scheduledExecutor.submit(task);
                FutureTask<ModelNode> futureTask = task;
                return futureTask;
            }
            finally {
                this.scanDoneLatch.countDown();
            }
        }

        @Override
        public Map<String, Boolean> getDeploymentsStatus() {
            return Collections.emptyMap();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

